#!/usr/bin/env ruby

$: << "./src"

require 'webrick'
require 'KakiRequestHandler.rb'
require 'PropertyFile.rb'
require 'KakiServ_config.rb'

unless $config then
	$config = PropertyFile.load("kaki.conf");
end

unless $page_data_source then
	$page_data_source = Wiki::FilePageDataSource.new($config['data_dir'])
	$page_data_source.use_cache = $config['use_cache']
	$page_data_source.use_memory_cache = $config['use_memory_cache']
end

unless $template_data_source then
	$template_data_source = Wiki::TemplateDataSource.new($config['template_dir'])
end

class WikiServlet < WEBrick::HTTPServlet::AbstractServlet
	def do_GET(req, res)
		app = KakiRequestHandler.new($page_data_source, $template_data_source);

		app.theme_dir = $config['theme_dir'] if $config['theme_dir']
		app.theme_base_url = $config['theme_base_url']if $config['theme_base_url']

		app.request_variables = req.meta_vars
		app.request_parameters = req.query
		app.main()
		header = app.response_header
		body = app.response_body

		header.each(){ |key, value|
			res[key] = value
		}
		res.body =  body
	end

	def do_POST(req, res)
		do_GET(req, res)
	end
end

class RedirectServlet < WEBrick::HTTPServlet::AbstractServlet
	def do_GET(req, res)
		res.set_redirect(WEBrick::HTTPStatus::MovedPermanently.new, '/kaki')
	end
	def do_POST(req, res) do_GET(req, res); end
	def do_HEAD(req, res) do_GET(req, res); end
end

$port_number = 8888 unless $port_number
server = WEBrick::HTTPServer.new( :Port => $port_number )

server.mount("/", RedirectServlet)
server.mount("/kaki", WikiServlet)
server.mount("/theme", WEBrick::HTTPServlet::FileHandler, "./theme")
server.mount("/files", WEBrick::HTTPServlet::FileHandler, "./files")

#Thread.start{
#	sleep(5);
#	server.shutdown;
#}

trap("INT"){ server.shutdown }
server.start

