
class Wiki::InLineParser
	prechigh
		left STRONG EM STROKE
	preclow
rule
	inlines : inlines inline { result << val[1] }
		| { result = [] }

	inline : text 
		| emphasis 
		| strong 
		| stroke 
		| link 
		| wiki_name
		| uri

	non_strong_inlines : non_strong_inline { result = val }
		| non_strong_inlines non_strong_inline { result << val[1] }

	non_strong_inline : text 
		| emphasis 
		| stroke 
		| link 
		| wiki_name 
		| uri 

	non_emphasis_inlines : non_emphasis_inline { result = val }
		| non_emphasis_inlines non_emphasis_inline { result << val[1] }

	non_emphasis_inline : text 
		| strong 
		| stroke 
		| link 
		| wiki_name 
		| uri 

	non_stroke_inlines : non_stroke_inline { result = val }
		| non_stroke_inlines non_stroke_inline { result << val[1] }

	non_stroke_inline : text 
		| strong 
		| emphasis 
		| link 
		| wiki_name 
		| uri 

	stroke :  '==' non_stroke_inlines '==' 
		{
			result = Strike.new() 
			val[1].each(){ |element|
				result.append_child(element)
			}
		}

	strong :  '\'\'\'' non_strong_inlines '\'\'\'' 
		{
			result = Strong.new() 
			val[1].each(){ |element|
				result.append_child(element)
			}
		}

	emphasis :  '\'\'' non_emphasis_inlines '\'\'' 
		{
			result = Emphasis.new() 
			val[1].each(){ |element|
				result.append_child(element)
			}
		}


	link : '[[' TEXT ']]' { 
		label, uri = val[1].split('|')
		if uri then
			result = URILink.new(label, uri)
		else
			result = Link.new(label)
		end
	}

	wiki_name : WIKI_NAME { result = Link.new(val[0]) }

	uri : URI { result = URILink.new(val[0], val[0]) }

	text : TEXT { result = Text.new(val[0]); }

end


---- header
require 'uri'
require 'cgi'

require 'DocumentModel.rb'

---- inner
def parse(line)
	@yydebug = true;
	@tokens = []
	@status = :NORMAL # :NORMAL or :INLINK

	while line and line.length > 0 do
		case @status
		when :INLINK then
			case line
			when /\A\]\]/ then
				@tokens.push([$&, $&])
				@status = :NORMAL
			when /\A./ then
				push_text($&)
			else
				puts "else : " + line
				p line
			end
		else # :NORMAL
			case line

			# strong
			when /\A'''/ then
				@tokens.push([$&, $&])
			# emphasis
			when /\A''/ then
				@tokens.push([$&, $&])
			# stroke
			when /\A==/ then
				@tokens.push([$&, $&])

			# link
			when /\A\[\[/ then
				if $'.index(']]') then
					@tokens.push([$&, $&])
					@status = :INLINK
				else
					push_text($&)
				end
			when /\A\]\]/ then
				push_text($&)

			# embedded uri 
			when %r!\A(http|https|ftp|mailto)://[\/\%\+\-_.\!~*'()a-zA-Z\d;?:@&=$,]+!n then
				@tokens.push([:URI, $&])
			when %r!\Amailto:[\/\%\+\-_.\!~*'()a-zA-Z\d;?:@&=$,]+!n then
				@tokens.push([:URI, $&])

			# not wiki name word
			when /\A([A-Z][A-Z])?[a-z0-9]+[A-Za-z0-9]+\b/ then
				push_text($&)

			# wiki name
			when /\A(?:[A-Z][a-z0-9]+){2,}\b/ then
				@tokens.push([:WIKI_NAME, $&])

			# space 
			when /\A\s+/ then
				push_text($&)

			# text
			when /\A./ then
				push_text($&)
			else
				puts "else : " + line
				p line
			end
		end

		line = $'
	end
	@tokens.push [false, '$']

#	@tokens.each(){ |token| p token}
	do_parse()
end

def push_text(str)
	if @tokens.last() and @tokens.last()[0] == :TEXT then
		@tokens.last()[1] += str
	else
		@tokens.push([:TEXT, str])
	end
end

def next_token()
	@tokens.shift
end


---- footer
if $0 == __FILE__ then
	require 'ToHtml.rb'
	begin
		parser = Wiki::InLineParser.new
		text = ARGF.each_line(){ |line|
			puts line
			result =  parser.parse(line);
			result.flatten!()
			formatter = Wiki::ToHtml.new
			result.each(){ |element|
				element.accept(formatter);
			}
			puts 
		}
	rescue Racc::ParseError
		p $!
	end
end

