#!/usr/bin/perl -w
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is the Kagetaka Libraries.
#
# The Initial Developer of the Original Code is Hizuya Atsuzaki
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

use Socket;
use strict;

my $bind = inet_aton("127.0.0.1");
my $port = 8080;

socket(CLIENT_WAITING, PF_INET, SOCK_STREAM, 0)
	|| die "Can not create socket. $!";

setsockopt(CLIENT_WAITING, SOL_SOCKET, SO_REUSEADDR, 1)
	|| die "Can not set socket options. $!";

bind(CLIENT_WAITING, pack_sockaddr_in($port, $bind))
	|| die "Can not bind to socket. $!";

listen(CLIENT_WAITING, SOMAXCONN)
	|| die "Can not listen from socket. $!";

while (1) {
	my $paddr = accept(CLIENT, CLIENT_WAITING);

	my($client_port, $client_iaddr) = unpack_sockaddr_in($paddr);
	my $client_hostname = gethostbyaddr($client_iaddr, AF_INET);
	my $client_ip = inet_ntoa($client_iaddr);

	print "#Connect: $client_hostname ($client_ip) - $client_port\r\n";

	select(CLIENT); $|=1; select(STDOUT);

	my ($count ) = 0;
	my (@lines ) = ();
	my ($length) = 0;

	while (<CLIENT>) {
		s/\r\n//g;
		$lines[$count++] = $_;
		print " [$_]\r\n";

		if (/^Content-Length: (.*)/i) {
			$length = $1;
		} elsif ("$_" eq "") {
			last if ($length == 0);
			my $data;
			my $rlen;
			print             " --- POST START ---\r\n";
			$lines[$count++] = "--- POST START ---";
			$lines[$count] = "";
			print             " [";
			while (defined($rlen = read(CLIENT, $data, $length))) {
				print "$data";
				$length -= $rlen;
				$lines[$count] = "$lines[$count]$data";
				last if ($length <= 0);
			}
			$count++;
			print             "]\r\n";
			print             " --- POST END ---\r\n";
			$lines[$count++] = "--- POST END ---";
			last;
		}
	}

	print CLIENT "HTTP/1.0 200 Ok\r\n";
	print CLIENT "Connection: close\r\n";
	print CLIENT "Content-Type: text/plain\r\n";
	print CLIENT "\r\n";

	my $i;
	for ($i = 0; $i < $count; $i++) {
		print CLIENT "$lines[$i]\r\n";
	}

	print "#Close: $client_hostname ($client_ip) - $client_port\r\n";
	close(CLIENT);
}
