/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.java2.bridge;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.util.HashMap;
import java.util.Map;

class FileFlavorMap
implements FlavorMap {
    static final String KEY_TEXT = "TEXT";
    static final String KEY_FILE_NAME = "FileName";
    static final String KEY_FILE_NAME_WIDE = "FileNameW";
    static final String HPN_TEXT = null;
    static final String HPN_FILE_NAME = "File Name";
    static final String HPN_FILE_NAME_WIDE = "File Name Wide";
    private Map nativeToFlavor;
    private Map flavorToNative;

    FileFlavorMap() {
        this(SystemFlavorMap.getDefaultFlavorMap().getFlavorsForNatives(null));
    }

    FileFlavorMap(Map map) {
        DataFlavorEx dataFlavorEx;
        Object object;
        this.nativeToFlavor = new HashMap(map.size());
        this.flavorToNative = new HashMap(map.size());
        String[][] stringArrayArray = map.keySet().iterator();
        while (stringArrayArray.hasNext()) {
            object = stringArrayArray.next();
            dataFlavorEx = new DataFlavorEx((DataFlavor)map.get(object));
            this.nativeToFlavor.put(object, dataFlavorEx);
            this.flavorToNative.put(dataFlavorEx, object);
        }
        stringArrayArray = new String[][]{{KEY_TEXT, "text/plain; class=java.io.InputStream", HPN_TEXT}, {KEY_FILE_NAME, "text/plain; class=java.io.InputStream", HPN_FILE_NAME}, {KEY_FILE_NAME_WIDE, "text/plain; charset=UnicodeLittleUnmarked; class=java.io.InputStream", HPN_FILE_NAME_WIDE}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            object = stringArrayArray[i][0];
            if (this.nativeToFlavor.containsKey(object)) {
                this.flavorToNative.remove(this.nativeToFlavor.get(object));
                this.nativeToFlavor.remove(object);
            }
            dataFlavorEx = new DataFlavorEx(stringArrayArray[i][1], stringArrayArray[i][2]);
            this.nativeToFlavor.put(object, dataFlavorEx);
            this.flavorToNative.put(dataFlavorEx, object);
        }
    }

    public synchronized Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
        if (dataFlavorArray == null) {
            return new HashMap(this.flavorToNative);
        }
        if (dataFlavorArray.length == 0) {
            return null;
        }
        HashMap<DataFlavor, String> hashMap = new HashMap<DataFlavor, String>(dataFlavorArray.length);
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            String string = (String)this.flavorToNative.get(dataFlavor);
            if (string == null) {
                String string2 = SystemFlavorMap.encodeJavaMIMEType(dataFlavor.getMimeType());
                hashMap.put(dataFlavor, string2);
                this.nativeToFlavor.put(string2, dataFlavor);
                this.flavorToNative.put(dataFlavor, string2);
                continue;
            }
            hashMap.put(dataFlavor, string);
        }
        return hashMap;
    }

    public synchronized Map getFlavorsForNatives(String[] stringArray) {
        if (stringArray == null) {
            return new HashMap(this.flavorToNative);
        }
        if (stringArray.length == 0) {
            return new HashMap();
        }
        HashMap<String, DataFlavor> hashMap = new HashMap<String, DataFlavor>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            DataFlavor dataFlavor = this.getFlavorsForNatives(string);
            if (dataFlavor == null) continue;
            hashMap.put(string, dataFlavor);
        }
        return hashMap;
    }

    public synchronized DataFlavor getFlavorsForNatives(String string) {
        DataFlavor dataFlavor = (DataFlavor)this.nativeToFlavor.get(string);
        if (dataFlavor == null) {
            if (!SystemFlavorMap.isJavaMIMEType(string)) {
                return null;
            }
            String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
            try {
                dataFlavor = new DataFlavor(string2);
            }
            catch (Exception exception) {
                System.out.println("Exception \"" + exception.getClass().getName() + ": " + exception.getMessage() + "\"while constructing DataFlavor for: " + string2);
                return null;
            }
            this.nativeToFlavor.put(string, dataFlavor);
            this.flavorToNative.put(dataFlavor, string);
        }
        return dataFlavor;
    }

    private class DataFlavorEx
    extends DataFlavor {
        private DataFlavorEx(DataFlavor dataFlavor) {
            super(dataFlavor.getMimeType(), dataFlavor.getHumanPresentableName());
        }

        private DataFlavorEx(String string, String string2) {
            super(string, string2);
        }

        public boolean equals(DataFlavor dataFlavor) {
            if (!super.equals(dataFlavor)) {
                return false;
            }
            String string = this.getHumanPresentableName();
            String string2 = dataFlavor.getHumanPresentableName();
            return string == null && string2 == null || string != null && string2 != null && string.compareTo(string2) == 0;
        }

        public int hashCode() {
            int n = super.hashCode();
            return (n += this.getHumanPresentableName().hashCode()) != 0 ? n : 25324987;
        }
    }
}

