/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.java2.DnDListener;
import net.hizlab.kagetaka.java2.DnDWrapper;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

public abstract class TextComponent
extends Component {
    private static final Font DEFAULT_FONT = Font.decode("Monospaced-plain-12");
    private static final int INPUT_FIX = 5;
    private static final int BLINK_INTERVAL = 700;
    static final int INSET_H = 4;
    static final int INSET_V = 4;
    String value = "";
    Text text;
    private boolean locked;
    private boolean multiline;
    private int cols;
    private int rows;
    private boolean wordwrap;
    private Point viewPosition = new Point(0, 0);
    private Dimension textSize = new Dimension(0, 0);
    private Insets frameSize = new Insets(0, 0, 0, 0);
    private int lineHeight;
    private Blink blink;
    private boolean viewCursor;
    private boolean calcSize;
    private boolean openWindow;
    private long lastClose;

    public TextComponent(Option option, ImageCreator imageCreator, String string, int n, int n2, boolean bl) {
        super(option, imageCreator);
        this.multiline = bl;
        this.setText(string);
        this.setRows(n);
        this.setColumns(n2);
        this.setFrameSize(4, 4, 4, 4);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!TextComponent.this.isEnabled()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 32: {
                        keyEvent.consume();
                        TextComponent.this.showInputBox(0, 0, false);
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!TextComponent.this.isEnabled()) {
                    return;
                }
                mouseEvent.consume();
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    TextComponent.this.showInputBox(mouseEvent.getX(), mouseEvent.getY(), true);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusGained(FocusEvent focusEvent) {
                TextComponent textComponent = TextComponent.this;
                synchronized (textComponent) {
                    if (TextComponent.this.blink == null) {
                        TextComponent.this.blink = new Blink(700);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusLost(FocusEvent focusEvent) {
                TextComponent textComponent = TextComponent.this;
                synchronized (textComponent) {
                    if (TextComponent.this.blink != null) {
                        TextComponent.this.blink.interrupt();
                        TextComponent.this.blink = null;
                    }
                }
            }
        });
        DnDWrapper dnDWrapper = DnDWrapper.getInstance();
        if (dnDWrapper != null) {
            dnDWrapper.addDnDListener(this, new DnDListener(){

                public boolean isActive() {
                    return TextComponent.this.isEnabled() && !TextComponent.this.locked;
                }

                public void drop(String string) {
                    if (TextComponent.this.getText() == null) {
                        TextComponent.this.setText(string);
                    } else {
                        TextComponent.this.setText(TextComponent.this.getText() + string);
                    }
                }
            });
        }
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.textText);
        if (Environment.javaVersion < 102) {
            this.setBackground(SystemColor.window);
        } else {
            this.setBackground(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            if (this.text == null && this.value.length() > 0) {
                this.resetText();
            }
            if (!this.calcSize) {
                this.calculateSize();
            }
        }
        return super.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean bl) {
        if (!bl) {
            TextComponent textComponent = this;
            synchronized (textComponent) {
                if (this.blink != null) {
                    this.blink.interrupt();
                    this.blink = null;
                }
            }
        }
        super.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics graphics, Dimension dimension, int n, boolean bl) {
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        Text text = null;
        Insets insets = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.text == null && this.value.length() > 0) {
                this.resetText();
            }
            text = this.text;
            insets = (Insets)this.frameSize.clone();
        }
        graphics.setColor(color2);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (text != null) {
            serializable = color;
            if (n == 4) {
                serializable = new Color(new GrayFilter(color2).filterRGB(0, 0, ((Color)serializable).getRGB()));
            }
            graphics.setColor((Color)serializable);
            graphics.setFont(this.getFont());
            text.draw(graphics, dimension.width - insets.right + this.viewPosition.x, insets.top - this.viewPosition.y, this.wordwrap ? dimension.height - insets.top - insets.bottom : 0);
        }
        if ((serializable = this.getBorder()) != null) {
            serializable.draw(graphics, 0, 0, dimension.width - 1, dimension.height - 1, color);
        } else {
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(1, 1, dimension.width - 2, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 2);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(2, dimension.height - 2, dimension.width - 2, dimension.height - 2);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        }
        if (bl && this.viewCursor) {
            this.paintCursor(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintCursor(Graphics graphics) {
        Dimension dimension;
        if (this.viewPosition.x >= this.lineHeight || this.viewPosition.y >= 1) {
            return;
        }
        graphics.setColor(Color.white);
        graphics.setXORMode(this.getBackground());
        int n = 0;
        int n2 = 0;
        TextComponent textComponent = this;
        synchronized (textComponent) {
            dimension = this.getSize();
            n = dimension.width + this.viewPosition.x - this.frameSize.right - 1;
            n2 = this.viewPosition.y + this.frameSize.top;
        }
        graphics.drawLine(Math.min(dimension.width - this.frameSize.right + 1, n), n2, n - this.lineHeight, n2);
        graphics.setPaintMode();
    }

    public String getText() {
        return this.value;
    }

    public synchronized void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (!this.multiline) {
            int n = string.indexOf(13);
            int n2 = string.indexOf(10);
            if (n != -1 || n2 != -1) {
                string = string.substring(0, n != -1 && n2 != -1 ? Math.min(n, n2) : Math.max(n, n2));
            }
        }
        if (this.value.compareTo(string) == 0) {
            return;
        }
        this.value = string;
        this.text = null;
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    void resetText() {
        this.text = null;
        if (this.value.length() > 0) {
            try {
                this.text = super.getText(this.value);
                Insets insets = (Insets)this.frameSize.clone();
                Dimension dimension = this.text.getSize(this.wordwrap ? this.getSize().height - insets.top - insets.bottom : 0);
                this.setTextSize(dimension.width, dimension.height);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.setPreferredSize(0, 0);
        }
    }

    private void calculateSize() {
        this.calcSize = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.cols; ++i) {
            stringBuffer.append('y');
        }
        try {
            Text text = super.getText(stringBuffer.toString());
            Dimension dimension = text.getSize(0);
            this.lineHeight = dimension.width;
            if (this.rows > 0) {
                dimension.width *= this.rows;
            }
            this.setPreferredSize(dimension.width + this.frameSize.left + this.frameSize.right, dimension.height + this.frameSize.top + this.frameSize.bottom);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.setPreferredSize(0, 0);
            return;
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    int getColumns() {
        return this.cols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setColumns(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.cols = n;
            this.calcSize = false;
        }
    }

    int getRows() {
        return this.rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRows(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.rows = n;
            this.calcSize = false;
        }
    }

    boolean getWordwrap() {
        return this.wordwrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWordwrap(boolean bl) {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.wordwrap = bl;
            this.calcSize = false;
        }
    }

    Point getViewPosition() {
        return new Point(this.viewPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setViewPosition(int n, int n2) {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.viewPosition.x = n;
            this.viewPosition.y = n2;
        }
    }

    Dimension getTextSize() {
        return new Dimension(this.textSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTextSize(int n, int n2) {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.textSize.width = n;
            this.textSize.height = n2;
        }
    }

    Insets getFrameSize() {
        return (Insets)this.frameSize.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFrameSize(int n, int n2, int n3, int n4) {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.frameSize.top = n;
            this.frameSize.left = n2;
            this.frameSize.bottom = n3;
            this.frameSize.right = n4;
        }
    }

    int getLineHeight() {
        return this.lineHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInputBox(int n, int n2, boolean bl) {
        if (!this.isEnabled() || this.locked) {
            return;
        }
        Dimension dimension = this.getSize();
        if (bl && (n < this.frameSize.left - 2 || n2 < this.frameSize.top - 2 || dimension.width - this.frameSize.right + 2 <= n || dimension.height - this.frameSize.bottom + 2 <= n2)) {
            return;
        }
        Container container = this.getParent();
        if (container == null) {
            return;
        }
        while (!(container instanceof Frame)) {
            if ((container = container.getParent()) != null) continue;
            return;
        }
        java.awt.Component component = this;
        synchronized (component) {
            if (this.openWindow || this.lastClose + 200L > System.currentTimeMillis()) {
                return;
            }
            this.openWindow = true;
            this.lastClose = 0L;
        }
        component = this.showInputBox((Frame)container, n, n2);
        if (component == null) {
            this.openWindow = false;
            return;
        }
        ((Window)component).addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                ((Window)windowEvent.getComponent()).removeWindowListener(this);
                TextComponent.this.lastClose = System.currentTimeMillis();
                TextComponent.this.openWindow = false;
            }
        });
    }

    abstract Window showInputBox(Frame var1, int var2, int var3);

    private class Blink
    extends Thread {
        private int interval;

        private Blink(int n) {
            this.interval = n;
            TextComponent.this.viewCursor = true;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Thread.sleep(this.interval);
                    Graphics graphics = TextComponent.this.getGraphics();
                    if (graphics != null) {
                        try {
                            TextComponent.this.paintCursor(graphics);
                        }
                        finally {
                            graphics.dispose();
                        }
                    }
                    TextComponent.this.viewCursor = !TextComponent.this.viewCursor;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

