/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.InnerScrollbar;
import net.hizlab.kagetaka.awt.tate.TextComponent;
import net.hizlab.kagetaka.rendering.Option;

public class TextArea
extends TextComponent {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.tate.Resource";
    private static final String BASE = "textarea";
    private static int nameCounter = 0;
    private static final int SCROLLBAR_SIZE = 16;
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    private int scrollbarVisibility;
    private Scrollbar scrollbarHorizontal;
    private Scrollbar scrollbarVertical;

    public TextArea(Option option, ImageCreator imageCreator) {
        this(option, imageCreator, null, 0, 0, 0);
    }

    public TextArea(Option option, ImageCreator imageCreator, String string) {
        this(option, imageCreator, string, 0, 0, 0);
    }

    public TextArea(Option option, ImageCreator imageCreator, int n, int n2) {
        this(option, imageCreator, null, n, n2, 0);
    }

    public TextArea(Option option, ImageCreator imageCreator, String string, int n, int n2) {
        this(option, imageCreator, string, n, n2, 0);
    }

    public TextArea(Option option, ImageCreator imageCreator, String string, int n, int n2, int n3) {
        super(option, imageCreator, string, n, n2, true);
        this.scrollbarVisibility = n3;
        this.setFrameSize(4, 4, 4 + (n3 == 0 || n3 == 2 ? 16 : 0), 4 + (n3 == 0 || n3 == 1 ? 16 : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (this.scrollbarVisibility == 0 || this.scrollbarVisibility == 2) {
                this.scrollbarHorizontal = new Scrollbar(0);
            }
            if (this.scrollbarVisibility == 0 || this.scrollbarVisibility == 1) {
                this.scrollbarVertical = new Scrollbar(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.removeNotify();
            if (this.scrollbarHorizontal != null) {
                this.scrollbarHorizontal.dispose();
                this.scrollbarHorizontal = null;
            }
            if (this.scrollbarVertical != null) {
                this.scrollbarVertical.dispose();
                this.scrollbarVertical = null;
            }
        }
    }

    protected String paramString() {
        String string;
        String string2 = super.paramString();
        switch (this.scrollbarVisibility) {
            case 0: {
                string = "both";
                break;
            }
            case 1: {
                string = "vertical-only";
                break;
            }
            case 2: {
                string = "horizontal-only";
                break;
            }
            case 3: {
                string = "none";
                break;
            }
            default: {
                string = "invalid display policy";
            }
        }
        return string2 + ",rows=" + this.getRows() + ",columns=" + this.getColumns() + ", scrollbarVisibility=" + string;
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    protected void refresh(Graphics graphics, Dimension dimension, int n, boolean bl) {
        int n2;
        super.refresh(graphics, dimension, n, bl);
        Point point = this.getViewPosition();
        Dimension dimension2 = this.getTextSize();
        Insets insets = this.getFrameSize();
        if (this.scrollbarHorizontal != null) {
            n2 = dimension.width - insets.left - insets.right;
            this.scrollbarHorizontal.setBounds(2, dimension.height - 16 - 2, dimension.width - (this.scrollbarVertical != null ? 16 : 0) - 4, 16);
            this.scrollbarHorizontal.setReverseValues(point.x, n2, 0, dimension2.width);
            this.scrollbarHorizontal.setBlockIncrement(Math.max(10, n2 - 10));
            this.scrollbarHorizontal.setUnitIncrement(10);
            this.scrollbarHorizontal.setEnabled(this.scrollbarHorizontal.canScroll());
            this.scrollbarHorizontal.paint(graphics, true);
        }
        if (this.scrollbarVertical != null) {
            n2 = dimension.height - insets.top - insets.bottom;
            this.scrollbarVertical.setBounds(dimension.width - 16 - 2, 2, 16, dimension.height - (this.scrollbarHorizontal != null ? 16 : 0) - 4);
            this.scrollbarVertical.setValues(point.y, n2, 0, dimension2.height);
            this.scrollbarVertical.setBlockIncrement(Math.max(this.getLineHeight(), n2 - this.getLineHeight()));
            this.scrollbarVertical.setUnitIncrement(this.getLineHeight());
            this.scrollbarVertical.setEnabled(this.scrollbarVertical.canScroll());
            this.scrollbarVertical.paint(graphics, true);
        }
        if (this.scrollbarHorizontal != null && this.scrollbarVertical != null) {
            graphics.setColor(SystemColor.control);
            graphics.fillRect(dimension.width - 16 - 2, dimension.height - 16 - 2, 16, 16);
        }
    }

    public int getColumns() {
        return super.getColumns();
    }

    public void setColumns(int n) {
        super.setColumns(n);
    }

    public int getRows() {
        return super.getRows();
    }

    public void setRows(int n) {
        super.setRows(n);
    }

    public boolean getWordwrap() {
        return super.getWordwrap();
    }

    public void setWordwrap(boolean bl) {
        super.setWordwrap(bl);
    }

    Window showInputBox(Frame frame, int n, int n2) {
        Point point = this.getLocationOnScreen();
        Input input = new Input(frame);
        Insets insets = input.getInsets();
        ((Component)input).setLocation(point.x + n - insets.left, point.y + n2 - insets.top);
        input.show();
        input.text.requestFocus();
        input.toFront();
        return input;
    }

    private class Scrollbar
    extends InnerScrollbar {
        private int orientation;

        private Scrollbar(int n) {
            super(n, (Component)TextArea.this);
            this.orientation = n;
        }

        public void repaint() {
            TextArea.this.repaintForce();
        }

        public void changedValue() {
            Point point = TextArea.this.getViewPosition();
            if (this.orientation == 0) {
                int n = this.getReverseValue();
                if (n == point.x) {
                    return;
                }
                TextArea.this.setViewPosition(n, point.y);
            } else {
                int n = this.getValue();
                if (n == point.y) {
                    return;
                }
                TextArea.this.setViewPosition(point.x, n);
            }
            TextArea.this.repaintForce();
        }
    }

    private class Input
    extends Dialog
    implements ActionListener {
        private static final String COMMAND_OK = "ok";
        private static final String COMMAND_CANCEL = "cancel";
        private java.awt.TextArea text;
        private boolean isClosed;

        private Input(Frame frame) {
            super(frame, Resource.getMessage((String)TextArea.RESOURCE, (String)"input.title", null), false);
            this.text = new java.awt.TextArea(TextArea.this.value, TextArea.this.getRows(), TextArea.this.getColumns(), TextArea.this.scrollbarVisibility);
            this.text.setForeground(TextArea.this.getForeground());
            ((Component)this.text).setBackground(TextArea.this.getBackground());
            this.text.setFont(TextArea.this.getFont());
            this.add(this.text);
            Panel panel = new Panel();
            this.add((Component)panel, "South");
            panel.setLayout(new GridLayout(1, 2, 10, 5));
            Button button = new Button(Resource.getMessage((String)TextArea.RESOURCE, (String)"textarea.button.ok", null));
            panel.add(button);
            button.setActionCommand(COMMAND_OK);
            button.addActionListener(this);
            button = new Button(Resource.getMessage((String)TextArea.RESOURCE, (String)"textarea.button.cancel", null));
            panel.add(button);
            button.setActionCommand(COMMAND_CANCEL);
            button.addActionListener(this);
            this.pack();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    this.close(false);
                }

                public void windowDeactivated(WindowEvent windowEvent) {
                    this.close(true);
                }
            });
            this.text.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ Input this$1;
                {
                    this.this$1 = input;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 27: {
                            keyEvent.consume();
                            Input.access$400(this.this$1, false);
                            break;
                        }
                        case 10: {
                            if ((keyEvent.getModifiers() & 2) == 0) break;
                            keyEvent.consume();
                            Input.access$400(this.this$1, true);
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean bl) {
            Input input = this;
            synchronized (input) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            if (bl) {
                TextArea.this.setText(this.text.getText());
            }
            this.dispose();
        }

        public void update(Graphics graphics) {
            ((Container)this).paint(graphics);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.close(COMMAND_OK.compareTo(actionEvent.getActionCommand()) == 0);
        }
    }
}

