/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Vector;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.InnerScrollbar;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

public class List
extends Component {
    private static final String BASE = "list";
    private static int nameCounter = 0;
    private static final int INSET_LIST_H = 2;
    private static final int INSET_LIST_V = 2;
    private static final int INSET_NONE_H = 1;
    private static final int INSET_NONE_V = 1;
    private static final int INSET_S = 1;
    private static final int SB_H = 16;
    private static final int MOVE_CLICK = 1;
    private static final int MOVE_DRAG = 2;
    private static final int MOVE_KEY = 3;
    private int INSET_H;
    private int INSET_V;
    private int rows;
    private boolean multipleMode;
    private boolean listMode;
    private Vector values = new Vector();
    private Vector texts = new Vector();
    private int selectedIndex = -1;
    private Vector selections = null;
    private int currentIndex = 0;
    private int currentIndex2 = 0;
    private int currentIndex3 = 0;
    private int viewStart = 0;
    private int viewEnd = 0;
    private int visibleIndex = -1;
    private int visibleReq = -1;
    private int rowWidth = -1;
    private Scrollbar scrollbar = null;
    private boolean lastMultipleSelected = true;
    private AutoScroll autoScroll;
    private boolean resetText = true;

    public List(Option option, ImageCreator imageCreator) {
        this(option, imageCreator, 0, false, true);
    }

    public List(Option option, ImageCreator imageCreator, int n) {
        this(option, imageCreator, n, false, true);
    }

    public List(Option option, ImageCreator imageCreator, int n, boolean bl) {
        this(option, imageCreator, n, bl, true);
    }

    List(Option option, ImageCreator imageCreator, int n, boolean bl, boolean bl2) {
        super(option, imageCreator);
        this.rows = n;
        this.setMultipleMode(bl);
        this.listMode = bl2;
        if (bl2) {
            this.INSET_H = 2;
            this.INSET_V = 2;
        } else {
            this.INSET_H = 1;
            this.INSET_V = 1;
        }
        this.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent keyEvent) {
                if (!List.this.isEnabled()) {
                    return;
                }
                boolean bl = (keyEvent.getModifiers() & 1) != 0;
                boolean bl2 = (keyEvent.getModifiers() & 2) != 0;
                switch (keyEvent.getKeyCode()) {
                    case 37: 
                    case 40: {
                        keyEvent.consume();
                        int n = List.this.currentIndex;
                        if (n + 1 >= List.this.values.size()) {
                            return;
                        }
                        List.this.moveCurrent(++n, 3, (keyEvent.getModifiers() & 1) != 0, (keyEvent.getModifiers() & 2) != 0);
                        break;
                    }
                    case 38: 
                    case 39: {
                        keyEvent.consume();
                        int n = List.this.currentIndex;
                        if (n <= 0) {
                            return;
                        }
                        List.this.moveCurrent(--n, 3, (keyEvent.getModifiers() & 1) != 0, (keyEvent.getModifiers() & 2) != 0);
                        break;
                    }
                    case 32: {
                        keyEvent.consume();
                        boolean bl3 = false;
                        List list = List.this;
                        synchronized (list) {
                            if (List.this.currentIndex == -1 || List.this.currentIndex >= List.this.values.size()) {
                                return;
                            }
                            if (List.this.multipleMode) {
                                bl3 = List.this.isIndexSelected(List.this.currentIndex);
                            }
                        }
                        if (bl3) {
                            List.this.deselect(List.this.currentIndex);
                            break;
                        }
                        List.this.select(List.this.currentIndex);
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!List.this.isEnabled()) {
                    return;
                }
                mouseEvent.consume();
                if (List.this.scrollbar.contains(mouseEvent.getX(), mouseEvent.getY(), false)) {
                    return;
                }
                List.this.moveCurrentFromPoint(mouseEvent.getX(), mouseEvent.getY(), 1, true, (mouseEvent.getModifiers() & 1) != 0, (mouseEvent.getModifiers() & 2) != 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!List.this.isEnabled()) {
                    return;
                }
                mouseEvent.consume();
                if (List.this.scrollbar.contains(mouseEvent.getX(), mouseEvent.getY(), false)) {
                    return;
                }
                List list = List.this;
                synchronized (list) {
                    if (List.this.autoScroll != null) {
                        List.this.autoScroll.interrupt();
                        List.this.autoScroll = null;
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!List.this.isEnabled()) {
                    return;
                }
                mouseEvent.consume();
                if (List.this.scrollbar.contains(mouseEvent.getX(), mouseEvent.getY(), true)) {
                    return;
                }
                List.this.moveCurrentFromPoint(mouseEvent.getX(), mouseEvent.getY(), 2, true, (mouseEvent.getModifiers() & 1) != 0, (mouseEvent.getModifiers() & 2) != 0);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (!List.this.isEnabled()) {
                    return;
                }
                mouseEvent.consume();
                if (List.this.scrollbar.contains(mouseEvent.getX(), mouseEvent.getY(), false)) {
                    return;
                }
                if (!List.this.listMode) {
                    List.this.moveCurrentFromPoint(mouseEvent.getX(), mouseEvent.getY(), 2, false, false, false);
                }
            }
        });
        this.setForeground(SystemColor.textText);
        if (Environment.javaVersion < 102) {
            this.setBackground(SystemColor.window);
        } else {
            this.setBackground(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        List list = this;
        synchronized (list) {
            if (this.resetText) {
                this.resetText();
            }
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean bl) {
        if (!bl) {
            List list = this;
            synchronized (list) {
                if (this.autoScroll != null) {
                    this.autoScroll.interrupt();
                    this.autoScroll = null;
                }
            }
        }
        super.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            this.scrollbar = new Scrollbar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.removeNotify();
            if (this.scrollbar != null) {
                this.scrollbar.dispose();
                this.scrollbar = null;
            }
        }
    }

    protected String paramString() {
        String string = super.paramString();
        return string + ",selected=" + this.getSelectedItem();
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics graphics, Dimension dimension, int n, boolean bl) {
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        Vector vector = null;
        Vector vector2 = null;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.resetText) {
                this.resetText();
            }
            vector = (Vector)this.texts.clone();
            if (this.multipleMode) {
                vector2 = (Vector)this.selections.clone();
            }
            n2 = this.selectedIndex;
            n3 = vector.size();
            n4 = dimension.width / this.rowWidth;
            if (n3 == 0) {
                return;
            }
            if (n3 <= n4) {
                this.viewStart = 0;
            } else if (this.visibleReq != -1 && this.visibleReq < this.viewStart) {
                this.viewStart = this.visibleReq;
            } else if (this.visibleReq != -1 && this.visibleReq > this.viewEnd) {
                this.viewStart = Math.max(0, this.visibleReq - n4 + 1);
            } else if (this.viewStart + n4 > n3) {
                this.viewStart = Math.max(0, n3 - n4);
            }
            this.viewEnd = Math.min(this.viewStart + n4 - 1, n3 - 1);
            this.visibleReq = -1;
        }
        graphics.setColor(color2);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        serializable = color;
        if (n == 4) {
            serializable = new Color(new GrayFilter(color2).filterRGB(0, 0, ((Color)serializable).getRGB()));
        }
        graphics.setFont(this.getFont());
        int n5 = dimension.width - this.INSET_H - 1;
        int n6 = this.INSET_V;
        int n7 = this.rowWidth;
        int n8 = dimension.height - this.INSET_V * 2;
        if (this.scrollbar.isVisible()) {
            n8 -= 16;
        }
        for (int i = this.viewStart; i <= this.viewEnd; ++i) {
            if (this.isIndexSelected(i)) {
                graphics.setColor(SystemColor.textHighlight);
                graphics.fillRect(n5 - n7 + 1, n6, n7, n8);
                graphics.setColor(SystemColor.textHighlightText);
            } else {
                graphics.setColor((Color)serializable);
            }
            ((Text)vector.elementAt(i)).draw(graphics, n5 + 1, n6 + 1, 0);
            if (bl && i == this.currentIndex) {
                GraphicsUtils.drawDashed((Graphics)graphics, (int)(n5 - n7 + 1), (int)n6, (int)n7, (int)1, (int)1, (int)1, (int)1);
                GraphicsUtils.drawDashed((Graphics)graphics, (int)(n5 - n7 + 1), (int)n6, (int)1, (int)n8, (int)1, (int)1, (int)2);
                GraphicsUtils.drawDashed((Graphics)graphics, (int)(n5 - n7 + 1), (int)(n6 + n8 - 1), (int)n7, (int)1, (int)1, (int)1, (int)1);
                GraphicsUtils.drawDashed((Graphics)graphics, (int)n5, (int)n6, (int)1, (int)n8, (int)1, (int)1, (int)2);
            }
            n5 -= this.rowWidth;
        }
        Border border = this.getBorder();
        if (border != null) {
            border.draw(graphics, 0, 0, dimension.width - 1, dimension.height - 1, color);
        } else if (this.listMode) {
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(1, 1, dimension.width - 2, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 2);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(2, dimension.height - 2, dimension.width - 2, dimension.height - 2);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        } else {
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        if (this.scrollbar.isVisible()) {
            this.scrollbar.setBounds(this.INSET_H, dimension.height - 16 - this.INSET_V, dimension.width - this.INSET_H * 2, 16);
            this.scrollbar.setReverseValues(this.viewStart, n4, 0, n3);
            this.scrollbar.setBlockIncrement(Math.max(1, n4 - 1));
            this.scrollbar.paint(graphics, true);
        }
    }

    public synchronized void add(String string) {
        this.addItem(string);
    }

    public synchronized void addItem(String string) {
        int n;
        this.resetText = true;
        this.values.addElement(string);
        this.texts.addElement(null);
        if (this.multipleMode) {
            this.selections.addElement(Boolean.FALSE);
        }
        if (this.viewStart <= (n = this.values.size()) && n <= this.viewEnd) {
            this.repaintForce();
        }
    }

    public synchronized void add(String string, int n) {
        this.addItem(string, n);
    }

    public synchronized void addItem(String string, int n) {
        this.resetText = true;
        this.values.insertElementAt(string, n);
        this.texts.insertElementAt(null, n);
        if (this.multipleMode) {
            this.selections.insertElementAt(Boolean.FALSE, n);
        }
        if (this.viewStart <= n && n <= this.viewEnd) {
            this.repaintForce();
        }
    }

    public synchronized void replaceItem(String string, int n) {
        this.resetText = true;
        this.values.setElementAt(string, n);
        this.texts.setElementAt(null, n);
        if (this.viewStart <= n && n <= this.viewEnd) {
            this.repaintForce();
        }
    }

    public String getItem(int n) {
        return (String)this.values.elementAt(n);
    }

    public synchronized String[] getItems() {
        Object[] objectArray = new String[this.values.size()];
        this.values.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void delItem(int n) {
        this.remove(n);
    }

    public synchronized void remove(int n) {
        this.values.removeElementAt(n);
        this.texts.removeElementAt(n);
        if (this.multipleMode) {
            this.selections.removeElementAt(n);
        }
        if (n == this.selectedIndex) {
            this.select(-1);
        }
        if (this.viewStart <= n && n <= this.viewEnd) {
            this.repaintForce();
        }
    }

    public synchronized void remove(String string) {
        int n = this.values.indexOf(string);
        if (n == -1) {
            return;
        }
        this.remove(n);
    }

    public synchronized void removeAll() {
        this.values.removeAllElements();
        this.texts.removeAllElements();
        if (this.multipleMode) {
            this.selections.removeAllElements();
        }
        this.selectedIndex = -1;
        this.currentIndex = 0;
        this.currentIndex2 = 0;
        this.currentIndex3 = 0;
        this.visibleReq = -1;
        this.repaintForce();
    }

    public int getItemCount() {
        return this.values.size();
    }

    public synchronized int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized int[] getSelectedIndexs() {
        if (!this.multipleMode) {
            if (this.selectedIndex == -1) {
                return new int[0];
            }
            return new int[]{this.selectedIndex};
        }
        int n = 0;
        for (int i = this.selections.size() - 1; i >= 0; --i) {
            if (!((Boolean)this.selections.elementAt(i)).booleanValue()) continue;
            ++n;
        }
        int[] nArray = new int[n];
        if (n > 0) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                if (!((Boolean)this.selections.elementAt(i)).booleanValue()) continue;
                nArray[--n] = i;
            }
        }
        return nArray;
    }

    public synchronized String getSelectedItem() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.getItem(this.selectedIndex);
    }

    public synchronized String[] getSelectedItems() {
        if (!this.multipleMode) {
            if (this.selectedIndex == -1) {
                return new String[0];
            }
            return new String[]{(String)this.values.elementAt(this.selectedIndex)};
        }
        int n = 0;
        for (int i = this.selections.size() - 1; i >= 0; --i) {
            if (!((Boolean)this.selections.elementAt(i)).booleanValue()) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        if (n > 0) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                if (!((Boolean)this.selections.elementAt(i)).booleanValue()) continue;
                stringArray[--n] = (String)this.values.elementAt(i);
            }
        }
        return stringArray;
    }

    public synchronized boolean isIndexSelected(int n) {
        if (this.multipleMode) {
            return (Boolean)this.selections.elementAt(n);
        }
        return this.selectedIndex == n;
    }

    public synchronized void select(int n) {
        if (this.selectedIndex == n) {
            return;
        }
        boolean bl = this.currentIndex == -1 || !this.multipleMode || this.multipleMode && this.currentIndex < this.selections.size() && !this.isIndexSelected(this.currentIndex);
        this.selectedIndex = n;
        if (bl) {
            this.currentIndex = n;
            this.currentIndex2 = n;
            this.currentIndex3 = n;
            this.visibleReq = n;
        }
        if (this.multipleMode) {
            this.selections.setElementAt(Boolean.TRUE, n);
        }
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    public synchronized void deselect(int n) {
        if (this.selectedIndex == n) {
            this.selectedIndex = -1;
        }
        if (this.multipleMode) {
            this.selections.setElementAt(Boolean.FALSE, n);
        }
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    public int getRows() {
        return this.rows;
    }

    public boolean getMultipleMode() {
        return this.multipleMode;
    }

    public synchronized void setMultipleMode(boolean bl) {
        this.multipleMode = bl;
        if (this.multipleMode) {
            this.selections = new Vector();
            for (int i = this.values.size() - 1; i >= 0; --i) {
                this.selections.addElement(Boolean.FALSE);
            }
            if (this.selectedIndex != -1) {
                this.selections.setElementAt(Boolean.TRUE, this.selectedIndex);
            }
        } else {
            this.selections = null;
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void makeVisible(int n) {
        this.visibleIndex = n;
        if ((this.visibleIndex < this.viewStart || this.viewEnd < this.visibleIndex) && this.isVisible()) {
            this.visibleReq = n;
            this.repaintForce();
        }
    }

    public boolean containsScrollbar(int n, int n2) {
        Scrollbar scrollbar = this.scrollbar;
        return scrollbar != null && scrollbar.contains(n, n2, false);
    }

    private void resetText() {
        Dimension dimension;
        Scrollbar scrollbar = this.scrollbar;
        if (scrollbar == null) {
            return;
        }
        this.resetText = false;
        int n = 0;
        int n2 = 0;
        for (int i = this.values.size() - 1; i >= 0; --i) {
            String string = (String)this.values.elementAt(i);
            Text text = (Text)this.texts.elementAt(i);
            if (string != null && text == null) {
                try {
                    text = super.getText(string);
                    this.texts.setElementAt(text, i);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (text == null) continue;
            dimension = text.getSize(0);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        try {
            dimension = super.getText("y").getSize(0);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        int n3 = 0;
        n3 = this.listMode ? (this.rows > 0 ? this.rows : this.values.size()) : Math.min(this.rows, this.values.size());
        this.setPreferredSize((n + 2) * n3 + this.INSET_H * 2, n2 + 2 + this.INSET_V * 2 + 16);
        this.rowWidth = n + 2;
        scrollbar.setVisible(n3 < this.values.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCurrentFromPoint(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        int n4 = 0;
        List list = this;
        synchronized (list) {
            Dimension dimension = this.getSize();
            if (n3 != 2) {
                if (n <= this.INSET_H || dimension.width - this.INSET_H <= n || n2 <= this.INSET_V || dimension.height - this.INSET_V <= n2) {
                    return;
                }
            } else {
                if (n <= this.INSET_H) {
                    if (bl && this.viewEnd + 1 < this.values.size()) {
                        int n5 = -1 * (n - this.INSET_H);
                        if (this.autoScroll == null) {
                            this.autoScroll = new AutoScroll(true, n5, bl2, bl3);
                            this.autoScroll.start();
                        } else {
                            this.autoScroll.setDistance(true, n5, bl2, bl3);
                        }
                    }
                    return;
                }
                if (dimension.width - this.INSET_H <= n) {
                    if (bl && this.viewStart > 0) {
                        int n6 = n - (dimension.width - this.INSET_H);
                        if (this.autoScroll == null) {
                            this.autoScroll = new AutoScroll(false, n6, bl2, bl3);
                            this.autoScroll.start();
                        } else {
                            this.autoScroll.setDistance(false, n6, bl2, bl3);
                        }
                    }
                    return;
                }
                if (this.autoScroll != null) {
                    this.autoScroll.interrupt();
                    this.autoScroll = null;
                }
            }
            int n7 = dimension.width - this.INSET_H * 2;
            int n8 = n7 % this.rowWidth;
            int n9 = this.viewStart + n7 / this.rowWidth - 1;
            n4 = (n -= this.INSET_H) <= n8 ? n9 : n9 - (n - n8) / this.rowWidth;
        }
        this.moveCurrent(n4, n3, bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCurrent(int n, int n2, boolean bl, boolean bl2) {
        block24: {
            List list = this;
            synchronized (list) {
                block22: {
                    int n3;
                    block25: {
                        block23: {
                            int n4;
                            n3 = this.values.size();
                            if (n >= n3 || n == this.currentIndex && n == this.selectedIndex && !this.multipleMode) {
                                return;
                            }
                            this.currentIndex = n;
                            if (!bl) {
                                this.currentIndex2 = n;
                            }
                            if (n2 == 1) {
                                this.currentIndex3 = n;
                            }
                            this.visibleReq = n;
                            if (!this.multipleMode) break block22;
                            if (!bl) break block23;
                            int n5 = Math.min(this.currentIndex, this.currentIndex2);
                            int n6 = Math.max(this.currentIndex, this.currentIndex2);
                            for (n4 = 0; n4 < n5; ++n4) {
                                this.selections.setElementAt(Boolean.FALSE, n4);
                            }
                            for (n4 = n5; n4 <= n6; ++n4) {
                                this.selections.setElementAt(Boolean.TRUE, n4);
                            }
                            for (n4 = n6 + 1; n4 < n3; ++n4) {
                                this.selections.setElementAt(Boolean.FALSE, n4);
                            }
                            break block24;
                        }
                        if (!bl2) break block25;
                        switch (n2) {
                            case 1: {
                                this.lastMultipleSelected = this.isIndexSelected(n);
                                if (this.lastMultipleSelected) {
                                    this.selections.setElementAt(Boolean.FALSE, n);
                                    break;
                                }
                                this.selections.setElementAt(Boolean.TRUE, n);
                                break;
                            }
                            case 2: {
                                if (this.lastMultipleSelected) {
                                    this.selections.setElementAt(Boolean.FALSE, n);
                                    break;
                                }
                                this.selections.setElementAt(Boolean.TRUE, n);
                                break;
                            }
                        }
                        break block24;
                    }
                    switch (n2) {
                        case 2: {
                            int n7;
                            int n8 = Math.min(this.currentIndex, this.currentIndex3);
                            int n9 = Math.max(this.currentIndex, this.currentIndex3);
                            for (n7 = 0; n7 < n8; ++n7) {
                                this.selections.setElementAt(Boolean.FALSE, n7);
                            }
                            for (n7 = n8; n7 <= n9; ++n7) {
                                this.selections.setElementAt(Boolean.TRUE, n7);
                            }
                            for (n7 = n9 + 1; n7 < n3; ++n7) {
                                this.selections.setElementAt(Boolean.FALSE, n7);
                            }
                            break block24;
                        }
                        default: {
                            for (int i = 0; i < n3; ++i) {
                                this.selections.setElementAt(Boolean.FALSE, i);
                            }
                            this.selections.setElementAt(Boolean.TRUE, n);
                            break;
                        }
                    }
                    break block24;
                }
                this.selectedIndex = n;
            }
        }
        this.repaintForce();
    }

    private class AutoScroll
    extends Thread {
        private boolean forward;
        private int interval;
        private boolean isShift;
        private boolean isCtrl;

        private AutoScroll(boolean bl, int n, boolean bl2, boolean bl3) {
            this.setDistance(bl, n, bl2, bl3);
        }

        private void setDistance(boolean bl, int n, boolean bl2, boolean bl3) {
            this.forward = bl;
            this.isShift = bl2;
            this.isCtrl = bl3;
            this.interval = n < 4 ? 200 : (n < 8 ? 80 : 20);
        }

        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Thread.sleep(this.interval);
                    int n = 0;
                    if (!(this.forward ? (n = List.this.viewEnd + 1) >= List.this.values.size() : (n = List.this.viewStart - 1) < 0)) {
                        List.this.moveCurrent(n, 2, this.isShift, this.isCtrl);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class Scrollbar
    extends InnerScrollbar {
        private Scrollbar() {
            super(0, (java.awt.Component)List.this);
        }

        public void repaint() {
            List.this.repaintForce();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changedValue() {
            List list = List.this;
            synchronized (list) {
                int n = this.getReverseValue();
                if (n == List.this.viewStart) {
                    return;
                }
                List.this.viewStart = n;
            }
            List.this.repaintForce();
        }
    }
}

