/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.TextManager;
import net.hizlab.kagetaka.rendering.Option;

public abstract class Component
extends java.awt.Component {
    private static final Font DEFAULT_FONT = Font.decode("Dialog-plain-12");
    private static final int NONE = -1;
    public static final int NORMAL = 0;
    public static final int MOUSE_OVER = 1;
    public static final int MOUSE_DOWN = 2;
    public static final int KEY_DOWN = 3;
    public static final int DISABLE = 4;
    final Option option;
    final ImageCreator ic;
    private String name;
    private boolean nameExplicitlySet = false;
    private TextManager textManager;
    private Border border;
    private Object stateLock = new Object();
    private int stateRequest;
    private int stateEnable;
    private int statePaint = -1;
    private boolean focusRequest;
    private boolean focusPaint = false;
    private boolean repaintForce;
    private Dimension preferredSize = new Dimension(0, 0);
    private int pressX = -1;
    private int pressY = -1;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;

    public Component(Option option, ImageCreator imageCreator) {
        this.option = option;
        this.ic = imageCreator;
        this.textManager = new TextManager(option, imageCreator);
        this.addFocusListener(new FocusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusGained(FocusEvent focusEvent) {
                boolean bl = false;
                Object object = Component.this.stateLock;
                synchronized (object) {
                    if (!Component.this.focusRequest) {
                        Component.this.focusRequest = true;
                        bl = true;
                    }
                }
                if (bl) {
                    Component.this.repaint();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusLost(FocusEvent focusEvent) {
                boolean bl = false;
                Object object = Component.this.stateLock;
                synchronized (object) {
                    if (Component.this.focusRequest) {
                        Component.this.focusRequest = false;
                        bl = true;
                    }
                }
                Component.this.setViewState(0);
                if (bl) {
                    Component.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (Component.this.stateRequest == 3) {
                    return;
                }
                if (Component.this.isEnabled()) {
                    Component.this.requestFocus();
                    mouseEvent.consume();
                }
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Dimension dimension = Component.this.getSize();
                if (n < 0 || n2 < 0 || n >= dimension.width || n2 > dimension.height) {
                    return;
                }
                Component.this.setViewState(2);
                Component.this.pressX = mouseEvent.getX();
                Component.this.pressY = mouseEvent.getY();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (Component.this.isEnabled()) {
                    mouseEvent.consume();
                }
                if (Component.this.stateRequest == 3) {
                    return;
                }
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Dimension dimension = Component.this.getSize();
                if (n < 0 || n2 < 0 || n >= dimension.width || n2 > dimension.height) {
                    Component.this.setViewState(0);
                } else {
                    Component.this.setViewState(1);
                }
                if (mouseEvent.getClickCount() > 0 && n >= 0 && n2 >= 0 && n < dimension.width && n2 < dimension.height && (n != Component.this.pressX || n2 != Component.this.pressY)) {
                    Component.this.getToolkit().getSystemEventQueue().postEvent(new MouseEvent(mouseEvent.getComponent(), 500, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (Component.this.stateRequest != 3) {
                    Component.this.setViewState(1);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (Component.this.stateRequest != 3) {
                    Component.this.setViewState(0);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (Component.this.isEnabled()) {
                    mouseEvent.consume();
                }
                if (Component.this.stateRequest != 1) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Dimension dimension = Component.this.getSize();
                if (n < 0 || n2 < 0 || n >= dimension.width || n2 > dimension.height) {
                    return;
                }
                Component.this.setViewState(2);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (Component.this.isEnabled()) {
                    mouseEvent.consume();
                }
                if (Component.this.stateRequest != 3) {
                    Component.this.setViewState(1);
                }
            }
        });
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredSize(int n, int n2) {
        Dimension dimension = this.preferredSize;
        synchronized (dimension) {
            if (this.preferredSize.width != n || this.preferredSize.height != n2) {
                this.preferredSize.width = n;
                this.preferredSize.height = n2;
                this.invalidate();
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.offScreenImage == null || !dimension.equals(this.offScreenSize)) {
                if (this.offScreenImage != null) {
                    this.offScreenGraphics.dispose();
                    this.offScreenImage.flush();
                }
                if (dimension.width == 0 || dimension.height == 0) {
                    this.offScreenImage = null;
                    this.offScreenSize = null;
                    this.offScreenGraphics = null;
                    return;
                }
                this.offScreenImage = this.createImage(dimension.width, dimension.height);
                this.offScreenSize = dimension;
                this.offScreenGraphics = this.offScreenImage.getGraphics();
                this.statePaint = -1;
            }
            if (this.offScreenGraphics != null && (this.stateRequest != this.statePaint || this.focusRequest != this.focusPaint || this.repaintForce)) {
                this.refresh(this.offScreenGraphics, dimension, this.stateRequest, this.focusRequest);
                this.statePaint = this.stateRequest;
                this.focusPaint = this.focusRequest;
                this.repaintForce = false;
            }
        }
        if (this.offScreenImage != null) {
            graphics.drawImage(this.offScreenImage, 0, 0, dimension.width, dimension.height, this);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setViewState(bl ? this.stateEnable : 4);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected String paramString() {
        String string = super.paramString();
        return string + ",state=" + this.statePaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            Component component = this;
            synchronized (component) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        Component component = this;
        synchronized (component) {
            super.setName(string);
            this.name = string;
            this.nameExplicitlySet = true;
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    String constructComponentName() {
        return null;
    }

    protected abstract void refresh(Graphics var1, Dimension var2, int var3, boolean var4);

    protected int getViewState() {
        return this.stateRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setViewState(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (n != 4) {
                this.stateEnable = n;
            }
            if (!this.isEnabled()) {
                n = 4;
            }
            if (this.stateRequest != n) {
                this.stateRequest = n;
                if (this.isVisible()) {
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        try {
                            this.update(graphics);
                        }
                        finally {
                            graphics.dispose();
                        }
                    } else {
                        this.repaint();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repaintForce() {
        Object object = this.stateLock;
        synchronized (object) {
            this.repaintForce = true;
        }
        this.repaint();
    }

    protected Text getText(String string) {
        return this.textManager.getText(FontData.getInstance((ImageCreator)this.ic, (Font)this.getFont()), string);
    }
}

