/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.awt.tate.List;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

public class Choice
extends Component {
    private static final String BASE = "choice";
    private static int nameCounter = 0;
    private static final int INSET_H = 2;
    private static final int INSET_V = 2;
    private static final int INSET_A = 2;
    private static final int INSET_S = 3;
    private static final int ARROW_WIDTH = 11;
    private static final int ARROW_HEIGHT = 12;
    private static final int[] ARROW_ALLOW = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int index = -1;
    private Vector values = new Vector();
    private Vector texts = new Vector();
    private List list;
    private boolean openWindow;
    private long lastClose;
    private boolean resetText = true;

    public Choice(Option option, ImageCreator imageCreator) {
        super(option, imageCreator);
        this.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent keyEvent) {
                if (!Choice.this.isEnabled()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 37: 
                    case 40: {
                        keyEvent.consume();
                        if ((keyEvent.getModifiers() & 8) != 0) {
                            Choice.this.showItemList();
                            return;
                        }
                        Choice choice = Choice.this;
                        synchronized (choice) {
                            if (Choice.this.index + 1 >= Choice.this.values.size()) {
                                return;
                            }
                            Choice.this.index++;
                        }
                        Choice.this.repaintForce();
                        break;
                    }
                    case 38: 
                    case 39: {
                        keyEvent.consume();
                        if ((keyEvent.getModifiers() & 8) != 0) {
                            Choice.this.showItemList();
                            return;
                        }
                        Choice choice = Choice.this;
                        synchronized (choice) {
                            if (Choice.this.index <= 0) {
                                return;
                            }
                            Choice.this.index--;
                        }
                        Choice.this.repaintForce();
                        break;
                    }
                    case 32: {
                        keyEvent.consume();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!Choice.this.isEnabled()) {
                    return;
                }
                mouseEvent.consume();
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    Choice.this.showItemList();
                }
            }
        });
        this.setForeground(SystemColor.textText);
        if (Environment.javaVersion < 102) {
            this.setBackground(SystemColor.window);
        } else {
            this.setBackground(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Choice choice = this;
        synchronized (choice) {
            if (this.resetText) {
                this.resetText();
            }
        }
        return super.getPreferredSize();
    }

    protected String paramString() {
        String string = super.paramString();
        return string + ",current=" + this.getSelectedItem();
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics graphics, Dimension dimension, int n, boolean bl) {
        Border border;
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        Text text = null;
        Choice choice = this;
        synchronized (choice) {
            if (this.resetText) {
                this.resetText();
            }
            if (this.index != -1 && this.index < this.texts.size()) {
                text = (Text)this.texts.elementAt(this.index);
            }
        }
        graphics.setColor(color2);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n2 = 3;
        int n3 = 3;
        int n4 = dimension.width - 4 - 2;
        int n5 = dimension.height - 4 - 4 - 12 - 2;
        Color color3 = color;
        if (bl) {
            graphics.setColor(SystemColor.textHighlight);
            graphics.fillRect(n2, n3, n4, n5);
            graphics.setColor(SystemColor.textHighlightText);
        } else {
            if (n == 4) {
                color3 = new Color(new GrayFilter(color2).filterRGB(0, 0, color3.getRGB()));
            }
            graphics.setColor(color3);
        }
        if (text != null) {
            graphics.setFont(this.getFont());
            text.draw(graphics, dimension.width - 2 - 3, 5, 0);
        }
        if (bl) {
            GraphicsUtils.drawDashed((Graphics)graphics, (int)n2, (int)n3, (int)n4, (int)1, (int)1, (int)1, (int)1);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)n2, (int)n3, (int)1, (int)n5, (int)1, (int)1, (int)2);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)n2, (int)(n3 + n5 - 1), (int)n4, (int)1, (int)1, (int)1, (int)1);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)(n2 + n4 - 1), (int)n3, (int)1, (int)n5, (int)1, (int)1, (int)2);
        }
        if ((border = this.getBorder()) != null) {
            border.draw(graphics, 0, 0, dimension.width - 1, dimension.height - 1, color);
        } else {
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(1, 1, dimension.width - 2, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 2);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(2, dimension.height - 2, dimension.width - 2, dimension.height - 2);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        }
        int n6 = 2;
        int n7 = dimension.height - 2 - 12 - 4;
        int n8 = dimension.width - 2 - 1;
        int n9 = n7 + 12 + 4 - 1;
        graphics.setColor(SystemColor.control);
        graphics.fillRect(n6 + 2, n7 + 2, n8 - n6 + 1 - 4, n9 - n7 + 1 - 4);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n6, n7, n8, n7);
        graphics.drawLine(n6, n7, n6, n9);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n6 + 1, n7 + 1, n8 - 1, n7 + 1);
        graphics.drawLine(n6 + 1, n7 + 1, n6 + 1, n9 - 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n8 - 1, n7 + 1, n8 - 1, n9 - 1);
        graphics.drawLine(n6 + 1, n9 - 1, n8 - 1, n9 - 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n8, n7, n8, n9);
        graphics.drawLine(n6, n9, n8, n9);
        this.drawArray(graphics, ARROW_ALLOW, (dimension.width - 11) / 2, n7 + 2, 11, 12, color3);
    }

    public synchronized void add(String string) {
        this.addItem(string);
    }

    public synchronized void addItem(String string) {
        this.resetText = true;
        this.values.addElement(string);
        this.texts.addElement(null);
        if (this.list != null) {
            this.list.addItem(string);
        }
    }

    public synchronized void insert(String string, int n) {
        this.resetText = true;
        this.values.insertElementAt(string, n);
        this.texts.insertElementAt(null, n);
        if (this.list != null) {
            this.list.addItem(string, n);
        }
    }

    public String getItem(int n) {
        return (String)this.values.elementAt(n);
    }

    public synchronized void remove(int n) {
        this.values.removeElementAt(n);
        this.texts.removeElementAt(n);
        if (n == this.index) {
            this.select(-1);
        }
        if (this.list != null) {
            this.list.remove(n);
        }
    }

    public synchronized void remove(String string) {
        int n = this.values.indexOf(string);
        if (n == -1) {
            return;
        }
        this.remove(n);
    }

    public synchronized void removeAll() {
        this.values.removeAllElements();
        this.texts.removeAllElements();
        this.index = -1;
        this.repaintForce();
        if (this.list != null) {
            this.list.removeAll();
        }
    }

    public int getItemCount() {
        return this.values.size();
    }

    public synchronized int getSelectedIndex() {
        return this.index;
    }

    public synchronized String getSelectedItem() {
        if (this.index == -1) {
            return null;
        }
        return this.getItem(this.index);
    }

    public synchronized void select(int n) {
        if (this.index == n) {
            return;
        }
        this.index = n;
        if (this.isVisible() && this.values.size() > 0) {
            this.repaintForce();
        }
    }

    public synchronized void select(String string) {
        int n = this.values.indexOf(string);
        if (n == -1) {
            return;
        }
        this.select(n);
    }

    private void resetText() {
        Dimension dimension;
        this.resetText = false;
        int n = 11;
        int n2 = 0;
        for (int i = this.values.size() - 1; i >= 0; --i) {
            String string = (String)this.values.elementAt(i);
            Text text = (Text)this.texts.elementAt(i);
            if (string != null && text == null) {
                try {
                    text = super.getText(string);
                    this.texts.setElementAt(text, i);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (text == null) continue;
            dimension = text.getSize(0);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        try {
            dimension = super.getText("y").getSize(0);
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.setPreferredSize(n + 4 + 6, n2 + 4 + 6 + 4 + 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArray(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, Color color) {
        SyncObserver syncObserver;
        int n5 = color.getRGB() | 0xFF000000;
        int n6 = 0;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i] == 1 ? n5 : n6;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n3, n4, nArray2, 0, n3);
        memoryImageSource.setAnimated(false);
        Image image = this.getToolkit().createImage(memoryImageSource);
        SyncObserver syncObserver2 = syncObserver = new SyncObserver();
        synchronized (syncObserver2) {
            syncObserver.init(graphics, n, n2, n3, n4);
            if (!graphics.drawImage(image, n, n2, n3, n4, (ImageObserver)syncObserver)) {
                try {
                    syncObserver.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("wait to draw a icon");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showItemList() {
        java.awt.Component component = this;
        synchronized (component) {
            if (this.openWindow || this.lastClose + 200L > System.currentTimeMillis()) {
                return;
            }
            this.openWindow = true;
            this.lastClose = 0L;
        }
        component = this.getParent();
        while (!(component instanceof Frame)) {
            if ((component = component.getParent()) != null) continue;
            this.openWindow = false;
            return;
        }
        ListWindow listWindow = new ListWindow((Frame)component);
        Point point = this.getLocationOnScreen();
        Dimension dimension = listWindow.getSize();
        ((java.awt.Component)listWindow).setLocation(point.x - dimension.width, point.y + 3);
        listWindow.show();
        this.list.requestFocus();
        listWindow.toFront();
    }

    private class ListWindow
    extends Window {
        private Frame parent;
        private MouseListener mouseListener;
        private ComponentListener componentListener;
        private boolean isClosed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListWindow(Frame frame) {
            super(frame);
            this.parent = frame;
            Choice choice2 = Choice.this;
            synchronized (choice2) {
                Choice.this.list = new List(Choice.this.option, Choice.this.ic, 10, false, false);
                int n = Choice.this.values.size();
                for (int i = 0; i < n; ++i) {
                    Choice.this.list.addItem((String)Choice.this.values.elementAt(i));
                }
                Choice.this.list.select(Choice.this.index);
            }
            this.add(Choice.this.list);
            this.pack();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = listWindow;
                }

                public void windowDeactivated(WindowEvent windowEvent) {
                    this.this$1.removeWindowListener(this);
                    ListWindow.access$500(this.this$1, false);
                }
            });
            Choice.this.list.addFocusListener(new FocusAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = listWindow;
                }

                public void focusLost(FocusEvent focusEvent) {
                    ListWindow.access$500(this.this$1, false);
                }
            });
            Choice.this.list.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = listWindow;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 27: {
                            keyEvent.consume();
                            ListWindow.access$500(this.this$1, false);
                            break;
                        }
                        case 10: {
                            keyEvent.consume();
                            ListWindow.access$500(this.this$1, true);
                        }
                    }
                }
            });
            Choice.this.list.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = listWindow;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    mouseEvent.consume();
                    if (Choice.access$400(ListWindow.access$600(this.this$1)).containsScrollbar(mouseEvent.getX(), mouseEvent.getY())) {
                        return;
                    }
                    ListWindow.access$500(this.this$1, true);
                }
            });
            this.mouseListener = new MouseAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = listWindow;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    ListWindow.access$500(this.this$1, false);
                }
            };
            frame.addMouseListener(this.mouseListener);
            this.componentListener = new ComponentAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = listWindow;
                }

                public void componentResized(ComponentEvent componentEvent) {
                    ListWindow.access$500(this.this$1, false);
                }

                public void componentMoved(ComponentEvent componentEvent) {
                    ListWindow.access$500(this.this$1, false);
                }
            };
            frame.addComponentListener(this.componentListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean bl) {
            ListWindow listWindow = this;
            synchronized (listWindow) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            if (bl) {
                Choice.this.select(Choice.this.list.getSelectedIndex());
            }
            Choice.this.lastClose = System.currentTimeMillis();
            Choice.this.openWindow = false;
            this.dispose();
        }

        public void update(Graphics graphics) {
            ((Container)this).paint(graphics);
        }

        public void dispose() {
            super.dispose();
            this.parent.removeMouseListener(this.mouseListener);
            this.parent.removeComponentListener(this.componentListener);
        }

        public void add(Component component) {
            super.add(component);
        }

        static /* synthetic */ void access$500(ListWindow listWindow, boolean bl) {
            listWindow.close(bl);
        }

        static /* synthetic */ Choice access$600(ListWindow listWindow) {
            return listWindow.Choice.this;
        }
    }
}

