/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.event.ActionEvent;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.rendering.Option;

public class Button
extends Component {
    private static final String BASE = "button";
    private static int nameCounter = 0;
    private static final int INSET_H = 5;
    private static final int INSET_V = 8;
    private String label;
    private String command;
    private Text text;
    private transient ActionListener actionListener;

    public Button(Option option, ImageCreator imageCreator) {
        this(option, imageCreator, null);
    }

    public Button(Option option, ImageCreator imageCreator, String string) {
        super(option, imageCreator);
        this.setLabel(string);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!Button.this.isEnabled()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        keyEvent.consume();
                        if (!Button.this.isEnabled()) break;
                        Button.this.postActionEvent(keyEvent.getModifiers());
                        break;
                    }
                    case 32: {
                        keyEvent.consume();
                        Button.this.setViewState(3);
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (!Button.this.isEnabled()) {
                    return;
                }
                keyEvent.consume();
                switch (keyEvent.getKeyCode()) {
                    case 32: {
                        keyEvent.consume();
                        if (Button.this.getViewState() != 3) break;
                        Button.this.setViewState(0);
                        if (!Button.this.isEnabled()) break;
                        Button.this.postActionEvent(keyEvent.getModifiers());
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!Button.this.isEnabled()) {
                    return;
                }
                mouseEvent.consume();
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    Button.this.postActionEvent(mouseEvent.getModifiers());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Button button = this;
        synchronized (button) {
            if (this.text == null && this.label != null) {
                this.resetText();
            }
        }
        return super.getPreferredSize();
    }

    protected String paramString() {
        String string = super.paramString();
        return string + ",label=" + this.label;
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics graphics, Dimension dimension, int n, boolean bl) {
        Border border;
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        Text text = null;
        Button button = this;
        synchronized (button) {
            if (this.text == null && this.label != null) {
                this.resetText();
            }
            text = this.text;
        }
        graphics.setColor(color2);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (text != null) {
            graphics.setFont(this.getFont());
            int n2 = n == 2 || n == 3 ? 1 : 0;
            Color color3 = color;
            if (n == 4) {
                graphics.setColor(SystemColor.controlLtHighlight);
                text.draw(graphics, dimension.width - 5 + n2 + 1, 8 + n2 + 1, 0);
                color3 = new Color(new GrayFilter(color2).filterRGB(0, 0, color3.getRGB()));
            }
            graphics.setColor(color3);
            text.draw(graphics, dimension.width - 5 + n2, 8 + n2, 0);
        }
        if ((border = this.getBorder()) != null) {
            border.draw(graphics, 0, 0, dimension.width - 1, dimension.height - 1, color);
        } else {
            int n3;
            int n4 = n3 = bl ? 1 : 0;
            if (n == 2 || n == 3) {
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(n3, n3, dimension.width - 1 - n3, n3);
                graphics.drawLine(n3, n3, n3, dimension.height - 1 - n3);
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(1 + n3, 1 + n3, dimension.width - 2 - n3, 1 + n3);
                graphics.drawLine(1 + n3, 1 + n3, 1 + n3, dimension.height - 2 - n3);
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(dimension.width - 1 - n3, 1 + n3, dimension.width - 1 - n3, dimension.height - 1 - n3);
                graphics.drawLine(1 + n3, dimension.height - 1 - n3, dimension.width - 1 - n3, dimension.height - 1 - n3);
            } else {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(n3, n3, dimension.width - 1 - n3, n3);
                graphics.drawLine(n3, n3, n3, dimension.height - 1 - n3);
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(dimension.width - 2 - n3, 2 + n3, dimension.width - 2 - n3, dimension.height - 2 - n3);
                graphics.drawLine(2 + n3, dimension.height - 2 - n3, dimension.width - 2 - n3, dimension.height - 2 - n3);
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(dimension.width - 1 - n3, 1 + n3, dimension.width - 1 - n3, dimension.height - 1 - n3);
                graphics.drawLine(1 + n3, dimension.height - 1 - n3, dimension.width - 1 - n3, dimension.height - 1 - n3);
            }
        }
        if (bl) {
            graphics.setColor(color);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)3, (int)3, (int)(dimension.width - 7), (int)1, (int)1, (int)1, (int)1);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)3, (int)3, (int)1, (int)(dimension.height - 7), (int)1, (int)1, (int)2);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)3, (int)(dimension.height - 4), (int)(dimension.width - 7), (int)1, (int)1, (int)1, (int)1);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)(dimension.width - 4), (int)3, (int)1, (int)(dimension.height - 7), (int)1, (int)1, (int)2);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        if (this.label == string || this.label != null && string != null && this.label.compareTo(string) == 0) {
            return;
        }
        this.label = string;
        this.text = null;
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    public String getActionCommand() {
        return this.command != null ? this.command : this.label;
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.enableEvents(128L);
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    private void postActionEvent(int n) {
        ActionEvent actionEvent = new ActionEvent(this, 3020, this.getActionCommand(), n);
        try {
            this.getToolkit().getSystemEventQueue().postEvent(actionEvent);
        }
        catch (SecurityException securityException) {
            this.processActionEvent(actionEvent);
        }
    }

    private void resetText() {
        this.text = null;
        if (this.label != null) {
            try {
                this.text = this.getText(this.label);
                Dimension dimension = this.text.getSize(0);
                this.setPreferredSize(dimension.width + 10, dimension.height + 16);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.setPreferredSize(0, 0);
        }
    }
}

