/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token.table;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.token.table.TableAttribute;
import net.hizlab.kagetaka.token.table.TbodyAttribute;
import net.hizlab.kagetaka.token.table.TdAttribute;
import net.hizlab.kagetaka.token.table.TrAttribute;

public class TableStartToken
extends StartToken {
    private TableStartToken tableToken = null;

    public TableStartToken(Document document, Reporter reporter, int n, int n2, int n3, boolean bl) {
        super(document, reporter, n, n2, n3, bl);
    }

    protected boolean setAttributeImple(String string, String string2) throws IllegalArgumentException {
        if (this.attribute == null) {
            switch (this.type) {
                case 3401: {
                    this.attribute = new TableAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3411: 
                case 3413: 
                case 3415: {
                    this.attribute = new TbodyAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3421: {
                    this.attribute = new TrAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3431: 
                case 3433: {
                    this.attribute = new TdAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                default: {
                    this.attribute = new Attribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                }
            }
        }
        return this.attribute.setAttribute(string, string2);
    }

    protected StartToken getDefaultParentTokenImple() {
        int n = -1;
        switch (this.type) {
            case 3401: {
                return new StartToken(this.document, this.reporter, this.lineNumber, this.columnNumber, 3001, true);
            }
            case 3403: {
                n = 3401;
                break;
            }
            case 3411: {
                n = 3401;
                break;
            }
            case 3413: {
                n = 3401;
                break;
            }
            case 3415: {
                n = 3401;
                break;
            }
            case 3421: {
                n = 3401;
                break;
            }
            case 3431: {
                n = 3421;
                break;
            }
            case 3433: {
                n = 3421;
                break;
            }
            default: {
                return null;
            }
        }
        return new TableStartToken(this.document, this.reporter, this.lineNumber, this.columnNumber, n, true);
    }

    protected boolean isContentsImple(int n) {
        switch (this.type) {
            case 3401: {
                switch (n) {
                    case 3403: 
                    case 3411: 
                    case 3413: 
                    case 3415: 
                    case 3421: {
                        return true;
                    }
                }
                return TokenTypes.isInline(n);
            }
            case 3403: {
                return TokenTypes.isInline(n);
            }
            case 3411: 
            case 3413: 
            case 3415: {
                return n == 3421 || TokenTypes.isInline(n);
            }
            case 3421: {
                return n == 3431 || n == 3433 || TokenTypes.isInline(n);
            }
            case 3431: 
            case 3433: {
                return TokenTypes.isBlock(n) || TokenTypes.isInline(n);
            }
        }
        return false;
    }

    protected void includeTokenImple(Token token) {
        if (token instanceof TableStartToken) {
            ((TableStartToken)token).tableToken = this.type == 3401 ? this : this.tableToken;
        }
    }

    protected void renderImple(Render render) {
        Status status = render.getStatus();
        switch (this.type) {
            case 3401: {
                if (this.attribute != null) {
                    TableAttribute tableAttribute = (TableAttribute)this.attribute;
                    if (tableAttribute.getBorder() != null && tableAttribute.getBorder() > 0) {
                        status.setBorderWidth(15, new Value((long)tableAttribute.getBorder().intValue(), 3));
                        status.setBorderStyle(15, new Value(19));
                    }
                    status.borderVerticalSpacing = status.borderHorizontalSpacing = tableAttribute.getCellspacing();
                    status.height = tableAttribute.getWidth();
                    if (tableAttribute.getHspace() != null) {
                        status.setMargin(5, new Value((long)tableAttribute.getHspace().intValue(), 3));
                    }
                    if (tableAttribute.getVspace() != null) {
                        status.setMargin(10, new Value((long)tableAttribute.getVspace().intValue(), 3));
                    }
                    switch (tableAttribute.getAlign()) {
                        case 31: {
                            status.floatType = 31;
                            break;
                        }
                        case 32: {
                            status.floatType = 32;
                            break;
                        }
                        default: {
                            status.floatType = 3;
                        }
                    }
                    if (tableAttribute.getBgcolor() != null) {
                        status.backColor = tableAttribute.getBgcolor();
                    }
                }
                status.setFontWeight(new Value(3));
                status.align = 3;
                status.valign = 46;
                status.isTable = true;
                break;
            }
            case 3403: {
                status.setFontWeight(new Value(2));
                status.align = 31;
                status.valign = 41;
                break;
            }
            case 3411: 
            case 3413: 
            case 3415: {
                status.valign = status.parent.valign;
                status.backColor = status.parent.backColor;
                if (this.attribute == null) break;
                TbodyAttribute tbodyAttribute = (TbodyAttribute)this.attribute;
                if (tbodyAttribute.getAlign() != 1) {
                    status.align = tbodyAttribute.getAlign();
                }
                if (tbodyAttribute.getVAlign() == 1) break;
                status.valign = tbodyAttribute.getVAlign();
                break;
            }
            case 3421: {
                status.valign = status.parent.valign;
                status.backColor = status.parent.backColor;
                if (this.attribute != null) {
                    TrAttribute trAttribute = (TrAttribute)this.attribute;
                    if (trAttribute.getAlign() != 1) {
                        status.align = trAttribute.getAlign();
                    }
                    if (trAttribute.getVAlign() != 1) {
                        status.valign = trAttribute.getVAlign();
                    }
                    if (trAttribute.getBgcolor() != null) {
                        status.backColor = trAttribute.getBgcolor();
                    }
                }
                render.createNewRow();
                break;
            }
            case 3431: 
            case 3433: {
                Attribute attribute;
                int n = 0;
                Value value = new Value(1L, 3);
                status.valign = status.parent.valign;
                status.backColor = status.parent.backColor;
                if (status.getFontWeight() < 0) {
                    status.setFontWeight(new Value(this.type == 3431 ? 75 : 2));
                }
                if (status.align == 3) {
                    int n2 = status.align = this.type == 3431 ? 33 : 31;
                }
                if (this.attribute != null) {
                    attribute = (TdAttribute)this.attribute;
                    if (((TdAttribute)attribute).getAlign() != 1) {
                        status.align = ((TdAttribute)attribute).getAlign();
                    }
                    if (((TdAttribute)attribute).getVAlign() != 1) {
                        status.valign = ((TdAttribute)attribute).getVAlign();
                    }
                    if (((TdAttribute)attribute).getBgcolor() != null) {
                        status.backColor = ((TdAttribute)attribute).getBgcolor();
                    }
                    if (((TdAttribute)attribute).getNowrap()) {
                        status.whiteSpace = 52;
                    }
                    if (((TdAttribute)attribute).getColspan() != null) {
                        status.colSpan = ((TdAttribute)attribute).getColspan();
                    }
                    if (((TdAttribute)attribute).getRowspan() != null) {
                        status.rowSpan = ((TdAttribute)attribute).getRowspan();
                    }
                    if (((TdAttribute)attribute).getWidth() != null) {
                        status.height = ((TdAttribute)attribute).getWidth();
                    }
                    if (((TdAttribute)attribute).getHeight() != null) {
                        status.width = ((TdAttribute)attribute).getHeight();
                    }
                }
                if (this.tableToken.attribute != null) {
                    attribute = (TableAttribute)this.tableToken.attribute;
                    if (((TableAttribute)attribute).getBorder() != null) {
                        n = ((TableAttribute)attribute).getBorder();
                    }
                    if (((TableAttribute)attribute).getCellpadding() != null) {
                        value = ((TableAttribute)attribute).getCellpadding();
                    }
                }
                if (n > 0) {
                    status.setBorderWidth(15, new Value(1L, 3));
                    status.setBorderStyle(15, new Value(18));
                }
                status.setPadding(15, value);
                status.isVertical = true;
            }
        }
    }
}

