/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import net.hizlab.kagetaka.token.Value;

public class AttributeConverter {
    private AttributeConverter() {
    }

    public static Color convertToColor(String string) throws IllegalArgumentException {
        Color color = AttributeConverter.convertToColorSilent(string);
        if (color == null) {
            throw new IllegalArgumentException();
        }
        return color;
    }

    public static Color convertToColorSilent(String string) {
        int n = string.length();
        int n2 = 0;
        if (n == 0) {
            return null;
        }
        if (string.charAt(0) == '#') {
            --n;
            n2 = 1;
        } else {
            if ("black".compareTo(string = string.toLowerCase()) == 0) {
                return new Color(0);
            }
            if ("silver".compareTo(string) == 0) {
                return new Color(0xC0C0C0);
            }
            if ("gray".compareTo(string) == 0) {
                return new Color(0x808080);
            }
            if ("white".compareTo(string) == 0) {
                return new Color(0xFFFFFF);
            }
            if ("maroon".compareTo(string) == 0) {
                return new Color(0x800000);
            }
            if ("red".compareTo(string) == 0) {
                return new Color(0xFF0000);
            }
            if ("purple".compareTo(string) == 0) {
                return new Color(0x800080);
            }
            if ("fuchsia".compareTo(string) == 0) {
                return new Color(0xFF00FF);
            }
            if ("green".compareTo(string) == 0) {
                return new Color(32768);
            }
            if ("lime".compareTo(string) == 0) {
                return new Color(65280);
            }
            if ("olive".compareTo(string) == 0) {
                return new Color(0x808000);
            }
            if ("yellow".compareTo(string) == 0) {
                return new Color(0xFFFF00);
            }
            if ("navy".compareTo(string) == 0) {
                return new Color(128);
            }
            if ("blue".compareTo(string) == 0) {
                return new Color(255);
            }
            if ("teal".compareTo(string) == 0) {
                return new Color(32896);
            }
            if ("aqua".compareTo(string) == 0) {
                return new Color(65535);
            }
            if ("activeborder".compareTo(string) == 0) {
                return SystemColor.activeCaptionBorder;
            }
            if ("activecaption".compareTo(string) == 0) {
                return SystemColor.activeCaption;
            }
            if ("appworkspace".compareTo(string) == 0) {
                return SystemColor.control;
            }
            if ("background".compareTo(string) == 0) {
                return SystemColor.desktop;
            }
            if ("buttonface".compareTo(string) == 0) {
                return SystemColor.control;
            }
            if ("buttonhighlight".compareTo(string) == 0) {
                return SystemColor.controlHighlight;
            }
            if ("buttonshadow".compareTo(string) == 0) {
                return SystemColor.controlShadow;
            }
            if ("buttontext".compareTo(string) == 0) {
                return SystemColor.controlText;
            }
            if ("captiontext".compareTo(string) == 0) {
                return SystemColor.activeCaptionText;
            }
            if ("graytext".compareTo(string) == 0) {
                return SystemColor.inactiveCaptionText;
            }
            if ("highlight".compareTo(string) == 0) {
                return SystemColor.textHighlight;
            }
            if ("highlighttext".compareTo(string) == 0) {
                return SystemColor.textHighlightText;
            }
            if ("inactiveborder".compareTo(string) == 0) {
                return SystemColor.inactiveCaptionBorder;
            }
            if ("inactivecaption".compareTo(string) == 0) {
                return SystemColor.inactiveCaption;
            }
            if ("inactivecaptiontext".compareTo(string) == 0) {
                return SystemColor.inactiveCaptionText;
            }
            if ("infobackground".compareTo(string) == 0) {
                return SystemColor.info;
            }
            if ("infotext".compareTo(string) == 0) {
                return SystemColor.infoText;
            }
            if ("menu".compareTo(string) == 0) {
                return SystemColor.menu;
            }
            if ("menutext".compareTo(string) == 0) {
                return SystemColor.menuText;
            }
            if ("scrollbar".compareTo(string) == 0) {
                return SystemColor.scrollbar;
            }
            if ("threeddarkshadow".compareTo(string) == 0) {
                return SystemColor.controlDkShadow;
            }
            if ("threedface".compareTo(string) == 0) {
                return SystemColor.controlHighlight;
            }
            if ("threedhighlight".compareTo(string) == 0) {
                return SystemColor.controlLtHighlight;
            }
            if ("threedlightshadow".compareTo(string) == 0) {
                return SystemColor.controlShadow;
            }
            if ("threedshadow".compareTo(string) == 0) {
                return SystemColor.controlShadow;
            }
            if ("window".compareTo(string) == 0) {
                return SystemColor.window;
            }
            if ("windowframe".compareTo(string) == 0) {
                return SystemColor.windowBorder;
            }
            if ("windowtext".compareTo(string) == 0) {
                return SystemColor.windowText;
            }
        }
        if (n != 3 && n != 6) {
            return null;
        }
        if (n == 3) {
            StringBuffer stringBuffer = new StringBuffer(7);
            stringBuffer.append('#');
            stringBuffer.append(string.charAt(n2));
            stringBuffer.append(string.charAt(n2));
            stringBuffer.append(string.charAt(n2 + 1));
            stringBuffer.append(string.charAt(n2 + 1));
            stringBuffer.append(string.charAt(n2 + 2));
            stringBuffer.append(string.charAt(n2 + 2));
            string = stringBuffer.toString();
            n = 6;
            n2 = 1;
        }
        int n3 = 0;
        while (--n >= 0) {
            char c;
            if ('0' <= (c = string.charAt(n2++)) && c <= '9') {
                n3 = (int)((double)n3 + (double)(c - 48) * Math.pow(16.0, n));
                continue;
            }
            if ('A' <= c && c <= 'F') {
                n3 = (int)((double)n3 + (double)(c - 65 + 10) * Math.pow(16.0, n));
                continue;
            }
            if ('a' <= c && c <= 'f') {
                n3 = (int)((double)n3 + (double)(c - 97 + 10) * Math.pow(16.0, n));
                continue;
            }
            return null;
        }
        return new Color(n3);
    }

    public static Font convertToFont(String string) throws IllegalArgumentException {
        return new Font(string, 12, 0);
    }

    public static Integer convertToInteger(String string) throws IllegalArgumentException {
        ParsePosition parsePosition = new ParsePosition(0);
        DecimalFormat decimalFormat = new DecimalFormat("0;-0");
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(0);
        Number number = decimalFormat.parse(string, parsePosition);
        if (!(number instanceof Long) || parsePosition.getIndex() < string.length()) {
            throw new IllegalArgumentException();
        }
        long l = number.longValue();
        if (l < Integer.MIN_VALUE || Integer.MAX_VALUE < l) {
            throw new IllegalArgumentException();
        }
        return new Integer((int)l);
    }

    public static int convertToAlign(String string) throws IllegalArgumentException {
        if ((string = string.toLowerCase()).compareTo("left") == 0) {
            return 31;
        }
        if (string.compareTo("center") == 0) {
            return 33;
        }
        if (string.compareTo("right") == 0) {
            return 32;
        }
        throw new IllegalArgumentException();
    }

    public static int convertToVAlign(String string) throws IllegalArgumentException {
        if ((string = string.toLowerCase()).compareTo("top") == 0) {
            return 44;
        }
        if (string.compareTo("middle") == 0) {
            return 46;
        }
        if (string.compareTo("bottom") == 0) {
            return 47;
        }
        throw new IllegalArgumentException();
    }

    public static Value convertToPercent(String string) throws IllegalArgumentException {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        Integer n = null;
        if (string.charAt(string.length() - 1) == '%') {
            bl = true;
            string = string.substring(0, string.length() - 1);
        }
        if ((n = AttributeConverter.convertToInteger(string)) == null) {
            throw new IllegalArgumentException();
        }
        return new Value((long)n.intValue(), bl ? 9 : 3);
    }
}

