/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import java.util.StringTokenizer;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Style;
import net.hizlab.kagetaka.token.StyleManager;

public class Attribute {
    protected Document document = null;
    protected Reporter reporter = null;
    protected int lineNumber = 0;
    protected int columnNumber = 0;
    private String attributeId = null;
    private String[] attributeClass = null;
    private String attributeTitle = null;
    private Style attributeStyle = null;

    public Attribute(Document document, Reporter reporter, int n, int n2) {
        this.document = document;
        this.reporter = reporter;
        this.lineNumber = n;
        this.columnNumber = n2;
    }

    public boolean setAttribute(String string, String string2) throws IllegalArgumentException {
        return this.setBaseAttribute(string, string2);
    }

    protected boolean setBaseAttribute(String string, String string2) throws IllegalArgumentException {
        if ("id".compareTo(string) == 0) {
            this.attributeId = string2;
            return true;
        }
        if ("class".compareTo(string) == 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            this.attributeClass = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < this.attributeClass.length; ++i) {
                this.attributeClass[i] = stringTokenizer.nextToken();
            }
            return true;
        }
        if ("title".compareTo(string) == 0) {
            this.attributeTitle = string2;
            return true;
        }
        if ("style".compareTo(string) == 0) {
            this.attributeStyle = StyleManager.createStyle(this.reporter, string2);
            return true;
        }
        return false;
    }

    protected void reportMessage(int n, String string, String[] stringArray) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.report(n, Resource.getMessage(string, stringArray), this.lineNumber, this.columnNumber);
    }

    public String getBaseId() {
        return this.attributeId;
    }

    public String[] getBaseClass() {
        return this.attributeClass;
    }

    public String getBaseTitle() {
        return this.attributeTitle;
    }

    public Style getStyle() {
        return this.attributeStyle;
    }
}

