/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.style;

import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.style.Selector;
import net.hizlab.kagetaka.style.Value;

public class Style
implements net.hizlab.kagetaka.token.Style {
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;
    private static final int TARGET_TOP = 1;
    private static final int TARGET_RIGHT = 2;
    private static final int TARGET_BOTTOM = 4;
    private static final int TARGET_LEFT = 8;
    private static final int TARGET_ALL = 15;
    protected Reporter reporter = null;
    protected int lineNumber = 0;
    protected int columnNumber = 0;
    Style next = null;
    private int media = 0;
    private Selector selector = null;
    private boolean page = false;
    private Hashtable properties = null;
    private Value propertyTextIndent = null;
    private Value propertyTextAlign = null;
    private Value propertyWhiteSpace = null;
    private Value[] propertyMargin = new Value[4];
    private Value[] propertyBorderStyle = new Value[4];
    private Value[] propertyBorderColor = new Value[4];
    private Value[] propertyBorderWidth = new Value[4];
    private Value[] propertyPadding = new Value[4];
    private Value propertyWidth = null;
    private Value propertyHeight = null;
    private Value propertyLineHeight = null;
    private Value propertyVerticalAlign = null;
    private Value propertyLetterSpacing = null;
    private Value propertyListStyleType = null;
    private Value propertyListStylePosition = null;
    private Value propertyListStyleImage = null;
    private Value propertyFloat = null;
    private Value propertyClear = null;
    private Value propertyColor = null;
    private Value propertyBackgroundColor = null;
    private Value[] propertyFontFamily = null;
    private Value propertyFontStyle = null;
    private Value propertyFontWeight = null;
    private Value propertyFontSize = null;
    private Value[] propertyTextDecoration = null;
    private static final int[] TYPES_LEN_PER = new int[]{1, -2, -3};
    private static final int[] TYPES_SIZE = new int[]{1, -2, -3};
    private static final int[] TYPES_COLOR = new int[]{1, -5};
    private static final int[] TYPES_COLOR_TRANS = new int[]{1, -5, 901};
    private static final int[] TYPES_ALIGN = new int[]{1, 31, 32, 33};
    private static final int[] TYPES_WHITE_SPACE = new int[]{1, 2, 51, 52};
    private static final int[] TYPES_BORDER_WIDTH = new int[]{1, 21, 22, 23, -2};
    private static final int[] TYPES_BORDER_STYLE = new int[]{1, 3, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    private static final int[] TYPES_LINE_HEIGHT = new int[]{1, 2, -1, -2, -3};
    private static final int[] TYPES_VERTICAL_ALIGN = new int[]{1, 41, 42, 43, 44, 45, 46, 47, 48, -1, -2, -3};
    private static final int[] TYPES_LETTER_SPACING = new int[]{1, 2, -2};
    private static final int[] TYPES_LIST_STYLE_TYPE = new int[]{1, 3, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100};
    private static final int[] TYPES_LIST_STYLE_POSITION = new int[]{1, 101, 102};
    private static final int[] TYPES_LIST_STYLE_IMAGE = new int[]{1, 3, -6};
    private static final int[] TYPES_FLOAT = new int[]{1, 31, 32, 3};
    private static final int[] TYPES_CLEAR = new int[]{1, 3, 31, 32, 35};
    private static final int[] TYPES_FONT_FAMILY = new int[]{1, -4};
    private static final int[] TYPES_FONT_STYLE = new int[]{1, 2, 72, 71};
    private static final int[] TYPES_FONT_WEIGHT = new int[]{1, 2, 75, 76, 77, -1};
    private static final int[] TYPES_FONT_SIZE = new int[]{1, 61, 62, 63, 22, 65, 66, 67, 69, 68, -2, -3};
    private static final int[] TYPES_TEXT_DECORATION = new int[]{1, 3, 4096, 8192, 16384, 32768};

    public Style(Reporter reporter, int n, int n2, int n3, Selector selector, boolean bl) {
        this.reporter = reporter;
        this.lineNumber = n;
        this.columnNumber = n2;
        this.media = n3;
        this.selector = selector;
        this.page = bl;
    }

    public void initProperties(String string, String[] stringArray) {
        string = string.toLowerCase();
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(string, stringArray);
        if (stringArray.length == 0) {
            return;
        }
        try {
            if (string.compareTo("text-indent") == 0) {
                this.propertyTextIndent = new Value(stringArray, TYPES_LEN_PER);
                return;
            }
            if (string.compareTo("text-align") == 0) {
                this.propertyTextAlign = new Value(stringArray, TYPES_ALIGN);
                return;
            }
            if (string.compareTo("white-space") == 0) {
                this.propertyWhiteSpace = new Value(stringArray, TYPES_WHITE_SPACE);
                return;
            }
            if (string.compareTo("clear") == 0) {
                this.propertyClear = new Value(stringArray, TYPES_CLEAR);
                return;
            }
            if (string.compareTo("margin-top") == 0) {
                this.propertyMargin[0] = new Value(stringArray, TYPES_SIZE);
                return;
            }
            if (string.compareTo("margin-right") == 0) {
                this.propertyMargin[1] = new Value(stringArray, TYPES_SIZE);
                return;
            }
            if (string.compareTo("margin-bottom") == 0) {
                this.propertyMargin[2] = new Value(stringArray, TYPES_SIZE);
                return;
            }
            if (string.compareTo("margin-left") == 0) {
                this.propertyMargin[3] = new Value(stringArray, TYPES_SIZE);
                return;
            }
            if (string.compareTo("margin") == 0) {
                this.distribute(stringArray, this.propertyMargin, TYPES_SIZE);
                return;
            }
            if (string.compareTo("border-top-width") == 0) {
                this.propertyBorderWidth[0] = new Value(stringArray, TYPES_BORDER_WIDTH);
                return;
            }
            if (string.compareTo("border-right-width") == 0) {
                this.propertyBorderWidth[1] = new Value(stringArray, TYPES_BORDER_WIDTH);
                return;
            }
            if (string.compareTo("border-bottom-width") == 0) {
                this.propertyBorderWidth[2] = new Value(stringArray, TYPES_BORDER_WIDTH);
                return;
            }
            if (string.compareTo("border-left-width") == 0) {
                this.propertyBorderWidth[3] = new Value(stringArray, TYPES_BORDER_WIDTH);
                return;
            }
            if (string.compareTo("border-width") == 0) {
                this.distribute(stringArray, this.propertyBorderWidth, TYPES_BORDER_WIDTH);
                return;
            }
            if (string.compareTo("border-top-color") == 0) {
                this.propertyBorderColor[0] = new Value(stringArray, TYPES_COLOR_TRANS);
                return;
            }
            if (string.compareTo("border-right-color") == 0) {
                this.propertyBorderColor[1] = new Value(stringArray, TYPES_COLOR_TRANS);
                return;
            }
            if (string.compareTo("border-bottom-color") == 0) {
                this.propertyBorderColor[2] = new Value(stringArray, TYPES_COLOR_TRANS);
                return;
            }
            if (string.compareTo("border-left-color") == 0) {
                this.propertyBorderColor[3] = new Value(stringArray, TYPES_COLOR_TRANS);
                return;
            }
            if (string.compareTo("border-color") == 0) {
                this.distribute(stringArray, this.propertyBorderColor, TYPES_COLOR_TRANS);
                return;
            }
            if (string.compareTo("border-top-style") == 0) {
                this.propertyBorderStyle[0] = new Value(stringArray, TYPES_BORDER_STYLE);
                return;
            }
            if (string.compareTo("border-right-style") == 0) {
                this.propertyBorderStyle[1] = new Value(stringArray, TYPES_BORDER_STYLE);
                return;
            }
            if (string.compareTo("border-bottom-style") == 0) {
                this.propertyBorderStyle[2] = new Value(stringArray, TYPES_BORDER_STYLE);
                return;
            }
            if (string.compareTo("border-left-style") == 0) {
                this.propertyBorderStyle[3] = new Value(stringArray, TYPES_BORDER_STYLE);
                return;
            }
            if (string.compareTo("border-style") == 0) {
                this.distribute(stringArray, this.propertyBorderStyle, TYPES_BORDER_STYLE);
                return;
            }
            if (string.compareTo("border-top") == 0) {
                this.normalizeBorder(stringArray, 1);
                return;
            }
            if (string.compareTo("border-right") == 0) {
                this.normalizeBorder(stringArray, 2);
                return;
            }
            if (string.compareTo("border-bottom") == 0) {
                this.normalizeBorder(stringArray, 4);
                return;
            }
            if (string.compareTo("border-left") == 0) {
                this.normalizeBorder(stringArray, 8);
                return;
            }
            if (string.compareTo("border") == 0) {
                this.normalizeBorder(stringArray, 15);
                return;
            }
            if (string.compareTo("padding-top") == 0) {
                this.propertyPadding[0] = new Value(stringArray, TYPES_LEN_PER);
                return;
            }
            if (string.compareTo("padding-right") == 0) {
                this.propertyPadding[1] = new Value(stringArray, TYPES_LEN_PER);
                return;
            }
            if (string.compareTo("padding-bottom") == 0) {
                this.propertyPadding[2] = new Value(stringArray, TYPES_LEN_PER);
                return;
            }
            if (string.compareTo("padding-left") == 0) {
                this.propertyPadding[3] = new Value(stringArray, TYPES_LEN_PER);
                return;
            }
            if (string.compareTo("padding") == 0) {
                this.distribute(stringArray, this.propertyPadding, TYPES_LEN_PER);
                return;
            }
            if (string.compareTo("width") == 0) {
                this.propertyWidth = new Value(stringArray, TYPES_SIZE);
                return;
            }
            if (string.compareTo("height") == 0) {
                this.propertyHeight = new Value(stringArray, TYPES_SIZE);
                return;
            }
            if (string.compareTo("line-height") == 0) {
                this.propertyLineHeight = new Value(stringArray, TYPES_LINE_HEIGHT);
                return;
            }
            if (string.compareTo("vertical-align") == 0) {
                this.propertyVerticalAlign = new Value(stringArray, TYPES_VERTICAL_ALIGN);
                return;
            }
            if (string.compareTo("letter-spacing") == 0) {
                this.propertyLetterSpacing = new Value(stringArray, TYPES_LETTER_SPACING);
                return;
            }
            if (string.compareTo("list-style-type") == 0) {
                this.propertyListStyleType = new Value(stringArray, TYPES_LIST_STYLE_TYPE);
                return;
            }
            if (string.compareTo("list-style-position") == 0) {
                this.propertyListStylePosition = new Value(stringArray, TYPES_LIST_STYLE_POSITION);
                return;
            }
            if (string.compareTo("list-style-image") == 0) {
                this.propertyListStyleImage = new Value(stringArray, TYPES_LIST_STYLE_IMAGE);
                return;
            }
            if (string.compareTo("list-style") == 0) {
                this.normalizeListStyle(stringArray);
                return;
            }
            if (string.compareTo("float") == 0) {
                this.propertyFloat = new Value(stringArray, TYPES_FLOAT);
                return;
            }
            if (string.compareTo("color") == 0) {
                this.propertyColor = new Value(stringArray, TYPES_COLOR);
                return;
            }
            if (string.compareTo("background-color") == 0) {
                this.propertyBackgroundColor = new Value(stringArray, TYPES_COLOR_TRANS);
                return;
            }
            if (string.compareTo("background") == 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        this.propertyBackgroundColor = new Value(stringArray[i], TYPES_COLOR_TRANS);
                        continue;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                return;
            }
            if (string.compareTo("font-style") == 0) {
                this.propertyFontStyle = new Value(stringArray, TYPES_FONT_STYLE);
                return;
            }
            if (string.compareTo("font-weight") == 0) {
                this.propertyFontWeight = new Value(stringArray, TYPES_FONT_WEIGHT);
                return;
            }
            if (string.compareTo("font-size") == 0) {
                this.propertyFontSize = new Value(stringArray, TYPES_FONT_SIZE);
                return;
            }
            if (string.compareTo("text-decoration") == 0) {
                this.propertyTextDecoration = this.createValues(stringArray, TYPES_TEXT_DECORATION, this.propertyTextDecoration);
                return;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.reportMessage(7, "style.warning.notsupported", new String[]{string});
    }

    public void changeStatus(Document document, boolean bl, Status status) {
        if (bl) {
            if (this.propertyTextIndent != null) {
                status.textIndent = this.propertyTextIndent;
            }
            if (this.propertyTextAlign != null) {
                status.align = this.propertyTextAlign.getType();
            }
            if (this.propertyWhiteSpace != null) {
                status.whiteSpace = this.propertyWhiteSpace.getType();
            }
            if (this.propertyClear != null) {
                status.clearType = this.propertyClear.getType();
            }
        }
        if (this.propertyMargin[0] != null) {
            status.setMargin(2, this.propertyMargin[0]);
        }
        if (this.propertyMargin[1] != null) {
            status.setMargin(4, this.propertyMargin[1]);
        }
        if (this.propertyMargin[2] != null) {
            status.setMargin(8, this.propertyMargin[2]);
        }
        if (this.propertyMargin[3] != null) {
            status.setMargin(1, this.propertyMargin[3]);
        }
        if (this.propertyBorderStyle[0] != null) {
            status.setBorderStyle(2, this.propertyBorderStyle[0]);
        }
        if (this.propertyBorderStyle[1] != null) {
            status.setBorderStyle(4, this.propertyBorderStyle[1]);
        }
        if (this.propertyBorderStyle[2] != null) {
            status.setBorderStyle(8, this.propertyBorderStyle[2]);
        }
        if (this.propertyBorderStyle[3] != null) {
            status.setBorderStyle(1, this.propertyBorderStyle[3]);
        }
        if (this.propertyBorderColor[0] != null) {
            status.setBorderColor(2, this.propertyBorderColor[0].getColor());
        }
        if (this.propertyBorderColor[1] != null) {
            status.setBorderColor(4, this.propertyBorderColor[1].getColor());
        }
        if (this.propertyBorderColor[2] != null) {
            status.setBorderColor(8, this.propertyBorderColor[2].getColor());
        }
        if (this.propertyBorderColor[3] != null) {
            status.setBorderColor(1, this.propertyBorderColor[3].getColor());
        }
        if (this.propertyBorderWidth[0] != null) {
            status.setBorderWidth(2, this.propertyBorderWidth[0]);
        }
        if (this.propertyBorderWidth[1] != null) {
            status.setBorderWidth(4, this.propertyBorderWidth[1]);
        }
        if (this.propertyBorderWidth[2] != null) {
            status.setBorderWidth(8, this.propertyBorderWidth[2]);
        }
        if (this.propertyBorderWidth[3] != null) {
            status.setBorderWidth(1, this.propertyBorderWidth[3]);
        }
        if (this.propertyPadding[0] != null) {
            status.setPadding(2, this.propertyPadding[0]);
        }
        if (this.propertyPadding[1] != null) {
            status.setPadding(4, this.propertyPadding[1]);
        }
        if (this.propertyPadding[2] != null) {
            status.setPadding(8, this.propertyPadding[2]);
        }
        if (this.propertyPadding[3] != null) {
            status.setPadding(1, this.propertyPadding[3]);
        }
        if (this.propertyWidth != null) {
            status.height = this.propertyWidth;
        }
        if (this.propertyHeight != null) {
            status.width = this.propertyHeight;
        }
        if (this.propertyLineHeight != null) {
            status.lineHeight = this.propertyLineHeight;
        }
        if (this.propertyVerticalAlign != null) {
            status.valign = this.propertyVerticalAlign.getType();
        }
        if (this.propertyLetterSpacing != null) {
            status.letterSpacing = this.propertyLetterSpacing;
        }
        if (this.propertyListStyleType != null) {
            status.setList(this.propertyListStyleType.getType());
        }
        if (this.propertyFloat != null) {
            status.floatType = this.propertyFloat.getType();
        }
        if (this.propertyColor != null) {
            status.foreColor = this.propertyColor.getColor();
        }
        if (this.propertyBackgroundColor != null) {
            status.backColor = this.propertyBackgroundColor.getColor();
        }
        if (this.propertyFontFamily != null) {
            status.setFontFamily(this.propertyFontFamily);
        }
        if (this.propertyFontStyle != null) {
            status.setFontStyle(this.propertyFontStyle);
        }
        if (this.propertyFontWeight != null) {
            status.setFontWeight(this.propertyFontWeight);
        }
        if (this.propertyFontSize != null) {
            status.setFontSize(this.propertyFontSize, 2);
        }
        if (this.propertyTextDecoration != null) {
            status.decoration = this.getOr(this.propertyTextDecoration);
        }
    }

    private void distribute(String[] stringArray, Value[] valueArray, int[] nArray) throws ParseException {
        switch (stringArray.length) {
            case 1: {
                valueArray[2] = valueArray[3] = new Value(stringArray[0], nArray);
                valueArray[1] = valueArray[3];
                valueArray[0] = valueArray[3];
                return;
            }
            case 2: {
                valueArray[0] = valueArray[2] = new Value(stringArray[0], nArray);
                valueArray[1] = valueArray[3] = new Value(stringArray[1], nArray);
                return;
            }
            case 3: {
                valueArray[0] = new Value(stringArray[0], nArray);
                valueArray[1] = valueArray[3] = new Value(stringArray[1], nArray);
                valueArray[2] = new Value(stringArray[2], nArray);
                return;
            }
            case 4: {
                valueArray[0] = new Value(stringArray[0], nArray);
                valueArray[1] = new Value(stringArray[1], nArray);
                valueArray[2] = new Value(stringArray[2], nArray);
                valueArray[3] = new Value(stringArray[3], nArray);
                return;
            }
        }
        throw new ParseException(stringArray[4], 0);
    }

    private Value[] createValues(String[] stringArray, int[] nArray, Value[] valueArray) throws ParseException {
        int n;
        Vector<Value> vector = new Vector<Value>();
        if (valueArray != null && valueArray.length > 0 && valueArray[0].getType() != 1) {
            for (n = 0; n < valueArray.length; ++n) {
                vector.addElement(valueArray[n]);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            Value value = new Value(stringArray[n], nArray);
            if (value.getType() == 1) {
                if (stringArray.length != 1) {
                    throw new ParseException(stringArray[n], 0);
                }
                return new Value[]{value};
            }
            vector.addElement(value);
        }
        valueArray = new Value[vector.size()];
        vector.copyInto(valueArray);
        return valueArray;
    }

    private void normalizeBorder(String[] stringArray, int n) throws ParseException {
        block0: for (int i = stringArray.length - 1; i >= 0; --i) {
            int n2;
            Value value = new Value(stringArray[i], null);
            int n3 = value.getType();
            if (n3 == 1) {
                if (stringArray.length != 1) break;
                this.distributeBorder(this.propertyBorderWidth, value, n);
                this.distributeBorder(this.propertyBorderStyle, value, n);
                this.distributeBorder(this.propertyBorderColor, value, n);
                return;
            }
            for (n2 = 0; n2 < TYPES_BORDER_WIDTH.length; ++n2) {
                if (TYPES_BORDER_WIDTH[n2] != n3) continue;
                this.distributeBorder(this.propertyBorderWidth, value, n);
                continue block0;
            }
            for (n2 = 0; n2 < TYPES_BORDER_STYLE.length; ++n2) {
                if (TYPES_BORDER_STYLE[n2] != n3) continue;
                this.distributeBorder(this.propertyBorderStyle, value, n);
                continue block0;
            }
            for (n2 = 0; n2 < TYPES_COLOR_TRANS.length; ++n2) {
                if (TYPES_COLOR_TRANS[n2] != n3) continue;
                this.distributeBorder(this.propertyBorderColor, value, n);
                continue block0;
            }
            throw new ParseException(stringArray[i], 0);
        }
    }

    private void distributeBorder(Value[] valueArray, Value value, int n) {
        if ((n & 1) != 0) {
            valueArray[0] = value;
        }
        if ((n & 2) != 0) {
            valueArray[1] = value;
        }
        if ((n & 4) != 0) {
            valueArray[2] = value;
        }
        if ((n & 8) != 0) {
            valueArray[3] = value;
        }
    }

    private void normalizeListStyle(String[] stringArray) throws ParseException {
        block0: for (int i = stringArray.length - 1; i >= 0; --i) {
            int n;
            Value value = new Value(stringArray[i], null);
            int n2 = value.getType();
            if (n2 == 1) {
                if (stringArray.length != 1) break;
                this.propertyListStyleType = value;
                this.propertyListStylePosition = value;
                this.propertyListStyleImage = value;
                return;
            }
            for (n = 0; n < TYPES_LIST_STYLE_TYPE.length; ++n) {
                if (TYPES_LIST_STYLE_TYPE[n] != n2) continue;
                this.propertyListStyleType = value;
                continue block0;
            }
            for (n = 0; n < TYPES_LIST_STYLE_POSITION.length; ++n) {
                if (TYPES_LIST_STYLE_POSITION[n] != n2) continue;
                this.propertyListStylePosition = value;
                continue block0;
            }
            for (n = 0; n < TYPES_LIST_STYLE_IMAGE.length; ++n) {
                if (TYPES_LIST_STYLE_IMAGE[n] != n2) continue;
                this.propertyListStyleImage = value;
                continue block0;
            }
            throw new ParseException(stringArray[i], 0);
        }
    }

    private int getOr(Value[] valueArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < valueArray.length; ++i) {
            n2 = valueArray[i].getType();
            if (n2 == 1) {
                return n2;
            }
            n |= n2;
        }
        return n;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public int getMedia() {
        return this.media;
    }

    public static int convertMedia(String[] stringArray) {
        if (stringArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.compareTo("aural") == 0) {
                n |= 2;
                continue;
            }
            if (string.compareTo("braille") == 0) {
                n |= 4;
                continue;
            }
            if (string.compareTo("embossed") == 0) {
                n |= 8;
                continue;
            }
            if (string.compareTo("handheld") == 0) {
                n |= 0x10;
                continue;
            }
            if (string.compareTo("print") == 0) {
                n |= 0x20;
                continue;
            }
            if (string.compareTo("projection") == 0) {
                n |= 0x40;
                continue;
            }
            if (string.compareTo("screen") == 0) {
                n |= 0x80;
                continue;
            }
            if (string.compareTo("tty") == 0) {
                n |= 0x100;
                continue;
            }
            if (string.compareTo("tv") == 0) {
                n |= 0x200;
                continue;
            }
            if (string.compareTo("all") == 0) {
                n |= 0xFFFFFF;
                continue;
            }
            n |= 1;
        }
        return n;
    }

    public boolean isPage() {
        return this.page;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.media != 0 && this.media != 1) {
            stringBuffer.append('<');
            if ((this.media & 2) != 0) {
                stringBuffer.append("aural, ");
            }
            if ((this.media & 4) != 0) {
                stringBuffer.append("braille, ");
            }
            if ((this.media & 8) != 0) {
                stringBuffer.append("embossed, ");
            }
            if ((this.media & 0x10) != 0) {
                stringBuffer.append("handheld, ");
            }
            if ((this.media & 0x20) != 0) {
                stringBuffer.append("print, ");
            }
            if ((this.media & 0x40) != 0) {
                stringBuffer.append("projection, ");
            }
            if ((this.media & 0x80) != 0) {
                stringBuffer.append("screen, ");
            }
            if ((this.media & 0x100) != 0) {
                stringBuffer.append("tty, ");
            }
            if ((this.media & 0x200) != 0) {
                stringBuffer.append("tv, ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append('>');
        }
        if (this.selector != null) {
            stringBuffer.append(this.selector.toString());
        }
        stringBuffer.append('{');
        if (this.properties != null) {
            Enumeration enumeration = this.properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String[] stringArray = (String[])this.properties.get(string);
                stringBuffer.append(string);
                stringBuffer.append(':');
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(' ');
                    stringBuffer.append(stringArray[i]);
                }
                stringBuffer.append("; ");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private void reportMessage(int n, String string, String[] stringArray) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.report(n, Resource.getMessage(string, stringArray), this.lineNumber, this.columnNumber);
    }
}

