/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import net.hizlab.kagetaka.rendering.Box;
import net.hizlab.kagetaka.rendering.ConnectWrapper;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.StopException;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.FormManager;
import net.hizlab.kagetaka.token.StyleManager;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.ContentType;

public class Render {
    private static final int DEFAULT_ALIGN = 31;
    private static final Color DEFAULT_FORE_COLOR = Color.black;
    private static final Color DEFAULT_BACK_COLOR = Color.white;
    private static final Color DEFAULT_LINK_COLOR = Color.blue;
    private static final Color DEFAULT_VLINK_COLOR = new Color(85, 26, 139);
    private static final Color DEFAULT_ALINK_COLOR = Color.red;
    private static final int DEFAULT_TD = 0;
    private HawkContext context;
    private Drawkit drawkit;
    private boolean smCreate = false;
    private StyleManager sm = null;
    private boolean fmCreate = false;
    private FormManager fm = null;
    private int refreshTime = -1;
    private URL refreshUrl = null;
    private Box topBox;
    private Box bottomBox;

    Render(HawkContext hawkContext, Request request) {
        this.context = hawkContext;
        this.drawkit = new Drawkit(hawkContext, request);
    }

    public void drawText(String string) {
        if (this.drawkit.status.isBlackHole) {
            return;
        }
        this.bottomBox.appendString(string);
    }

    public void doBr() {
        if (this.drawkit.status.isBlackHole) {
            return;
        }
        this.bottomBox.appendNewLine();
    }

    public void createNewRow() {
        this.bottomBox.createNewRow();
    }

    public void drawImage(String string, String string2, Value value, Value value2, Integer n, int n2) {
        if (this.drawkit.status.isBlackHole) {
            return;
        }
        if (string == null) {
            return;
        }
        int n3 = 0;
        n3 = n != null ? n : (this.drawkit.status.href != null ? 2 : 0);
        this.bottomBox.appendImage(string, string2, value, value2, n3, n2);
    }

    public void drawForm(FormItem formItem) {
        this.bottomBox.appendForm(formItem);
    }

    public void setTitle(String string) {
        this.drawkit.document.setTitle(string);
    }

    public Status getStatus() {
        return this.drawkit.status;
    }

    public void setBaseHref(String string) {
        if (string == null) {
            return;
        }
        URL uRL = this.drawkit.createURL(string);
        if (uRL != null) {
            this.drawkit.document.setBaseURL(uRL);
        }
    }

    public void setMark(String string) {
        if (string != null) {
            this.drawkit.idQueue.put(string);
        }
    }

    public void setLink(String string) {
        if (string != null) {
            URL uRL = this.drawkit.createURL(string);
            if (uRL == null) {
                return;
            }
            this.drawkit.status.href = uRL;
            this.drawkit.status.foreColor = this.context.haveEverVisited(uRL) ? this.drawkit.status.vlinkColor : this.drawkit.status.linkColor;
        }
    }

    public void setPopup(String string) {
        if (string != null) {
            this.drawkit.status.tip = string;
        }
    }

    public void startRuby() {
        this.bottomBox.setRuby(1);
    }

    public void startRubyRb() {
        this.bottomBox.setRuby(2);
    }

    public void startRubyRp() {
        this.bottomBox.setRuby(3);
    }

    public void startRubyRt() {
        this.bottomBox.setRuby(4);
    }

    public void endRuby() {
        this.bottomBox.setRuby(7);
    }

    public void setListItem() {
        this.bottomBox.setListItem();
    }

    public void setRefresh(int n, String string) {
        this.refreshTime = n;
        if (string == null) {
            this.refreshUrl = this.drawkit.document.getBaseURL();
        } else {
            this.refreshUrl = this.drawkit.createURL(string);
            if (this.refreshUrl == null) {
                this.refreshTime = -1;
            }
        }
    }

    public void setCookie(String string) {
        this.context.setCookie(string, this.drawkit.document.url);
    }

    public void setStyleSheet(String string, String string2) {
        if (string == null) {
            return;
        }
        URL uRL = this.drawkit.createURL(string);
        if (uRL == null) {
            return;
        }
        if (this.sm == null && !this.smCreate) {
            this.sm = StyleManager.createStyleManager(this.context.getReporter());
            this.smCreate = true;
        }
        if (this.sm == null) {
            return;
        }
        try {
            URLConnection uRLConnection = ConnectWrapper.getURLConnection(this.context, new Request(uRL, null, this.drawkit.document.url, null, false, false, 2));
            if (uRLConnection == null) {
                return;
            }
            String string3 = null;
            if (string2 == null) {
                string2 = uRLConnection.getContentType();
            }
            if ((string2 = ContentType.normalize(string2, uRL)) != null) {
                try {
                    ContentType contentType = new ContentType(string2);
                    string2 = (contentType.getType() != null ? contentType.getType() : "") + "/" + (contentType.getSubType() != null ? contentType.getSubType() : "");
                    String string4 = contentType.getParameter("charset");
                    if (string4 != null && (string3 = Charset.toEncoding(string4)) == null) {
                        this.drawkit.reportMessage(7, "charset.warning.invalid", new String[]{string4});
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (string2 == null || string2.compareTo("text/css") != 0) {
                return;
            }
            this.sm.addStyle(uRLConnection.getInputStream(), string3);
        }
        catch (SecurityException securityException) {
            this.drawkit.reportMessage(7, "engine.status.load.error.security", new String[]{string});
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.drawkit.reportMessage(7, "engine.status.load.error.nofile", new String[]{string});
        }
        catch (IOException iOException) {
            String string5 = iOException.getMessage();
            this.drawkit.reportMessage(7, "engine.status.load.error", new Object[]{string, new Integer(string5 != null ? 1 : 0), string5, iOException.getClass().getName()});
        }
        catch (InterruptedException interruptedException) {
            throw new StopException("wait to load style");
        }
    }

    public StyleManager getStyleManager(boolean bl) {
        if (this.sm == null && !this.smCreate && bl) {
            this.sm = StyleManager.createStyleManager(this.context.getReporter());
            this.smCreate = true;
        }
        return this.sm;
    }

    public FormManager getFormManager() {
        if (this.fm == null && !this.fmCreate) {
            this.fm = FormManager.createFormManager(this.context, this.drawkit.document);
            this.fmCreate = true;
        }
        return this.fm;
    }

    void startBlock() {
        this.bottomBox = this.bottomBox.createBox();
    }

    void endBlock() {
        this.bottomBox = this.bottomBox.commitBox();
    }

    void startBody() {
        Status status = this.drawkit.baseStatus;
        if (status.backColor == null) {
            status.backColor = DEFAULT_BACK_COLOR;
        }
        if (status.align == 1) {
            status.align = 31;
        }
        if (status.foreColor == null) {
            status.foreColor = DEFAULT_FORE_COLOR;
        }
        if (status.linkColor == null) {
            status.linkColor = DEFAULT_LINK_COLOR;
        }
        if (status.vlinkColor == null) {
            status.vlinkColor = DEFAULT_VLINK_COLOR;
        }
        if (status.alinkColor == null) {
            status.alinkColor = DEFAULT_ALINK_COLOR;
        }
        if (status.decoration == 1) {
            status.decoration = 0;
        }
        int n = status.fdFontSize.width;
        int n2 = status.fdFontSize.height;
        if (status.lineHeight != null) {
            n = status.lineHeight.getValue(status.fd, status.fdFontSize.width, 1);
        }
        if (status.letterSpacing != null) {
            n2 += status.letterSpacing.getValue(status.fd, status.fdFontSize.height, 2);
        }
        this.drawkit.document.setCharScale(new Dimension(n, n2));
        if (status.backColor != null) {
            this.drawkit.document.setBackColor(status.backColor);
        }
        if (status.backImage != null) {
            this.drawkit.document.setBackImage(status.backImage);
        }
        this.bottomBox = this.topBox = new Box(this.drawkit);
    }

    void endBody() {
        Status status = this.drawkit.baseStatus;
        this.topBox.dispose();
    }

    void save(int n) {
        this.drawkit.saveStatus(n);
    }

    void reset() {
        this.drawkit.resetStatus();
    }

    void statusChanged() {
        this.drawkit.status.checkStatus();
        this.bottomBox.statusChanged();
    }

    void waitImageLoad() {
        this.drawkit.waitImageLoad();
    }

    void stopImageLoad() {
        this.drawkit.stopImageLoad();
    }

    URL getRefreshURL() {
        if (this.refreshTime < 0) {
            return null;
        }
        if (this.refreshTime > 0) {
            try {
                Thread.sleep(this.refreshTime * 1000);
            }
            catch (InterruptedException interruptedException) {
                throw new StopException("wait for refresh");
            }
        }
        return this.refreshUrl;
    }

    void dispose() {
        this.drawkit.dispose();
    }
}

