/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Point;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;

public class ItemMap {
    private Reporter reporter = null;
    private Vector hrefMap = new Vector();
    private Vector imageMap = new Vector();
    private Vector tipMap = new Vector();
    private Vector infoMap = new Vector();
    private Hashtable idMap = new Hashtable();

    ItemMap(Reporter reporter) {
        this.reporter = reporter;
    }

    synchronized void addHref(int n, int n2, int n3, int n4, URL uRL) {
        this.hrefMap.addElement(new InfoRectangle(n, n2, n3, n4, uRL));
    }

    synchronized void addImage(int n, int n2, int n3, int n4, URL uRL) {
        this.imageMap.addElement(new InfoRectangle(n, n2, n3, n4, uRL));
    }

    public synchronized URL getLinkURL(int n, int n2) {
        InfoRectangle infoRectangle = null;
        for (int i = 0; i < this.hrefMap.size(); ++i) {
            infoRectangle = (InfoRectangle)this.hrefMap.elementAt(i);
            if (!infoRectangle.isInner(n, n2)) continue;
            return (URL)infoRectangle.info;
        }
        return null;
    }

    public synchronized URL getImageURL(int n, int n2) {
        InfoRectangle infoRectangle = null;
        for (int i = 0; i < this.imageMap.size(); ++i) {
            infoRectangle = (InfoRectangle)this.imageMap.elementAt(i);
            if (!infoRectangle.isInner(n, n2)) continue;
            return (URL)infoRectangle.info;
        }
        return null;
    }

    synchronized void addTip(int n, int n2, int n3, int n4, String string) {
        this.tipMap.addElement(new InfoRectangle(n, n2, n3, n4, string));
    }

    public synchronized String getTip(int n, int n2) {
        InfoRectangle infoRectangle = null;
        for (int i = 0; i < this.tipMap.size(); ++i) {
            infoRectangle = (InfoRectangle)this.tipMap.elementAt(i);
            if (!infoRectangle.isInner(n, n2)) continue;
            return (String)infoRectangle.info;
        }
        return null;
    }

    synchronized void addInfo(int n, int n2, int n3, int n4, String string) {
        this.infoMap.addElement(new InfoRectangle(n, n2, n3, n4, string));
    }

    public synchronized String getInfo(int n, int n2) {
        InfoRectangle infoRectangle = null;
        for (int i = 0; i < this.infoMap.size(); ++i) {
            infoRectangle = (InfoRectangle)this.infoMap.elementAt(i);
            if (!infoRectangle.isInner(n, n2)) continue;
            return (String)infoRectangle.info;
        }
        return null;
    }

    synchronized void addId(String string, int n, int n2) {
        if (this.idMap.containsKey(string)) {
            this.reporter.report(7, Resource.getMessage("render.warning.id.duplicate", new String[]{string}), 0, 0);
            return;
        }
        this.idMap.put(string, new Point(n, n2));
    }

    public synchronized Point getIdPoint(String string) {
        Point point = (Point)this.idMap.get(string);
        if (point == null) {
            return null;
        }
        return new Point(point.x, point.y);
    }

    private class InfoRectangle {
        private int x1 = 0;
        private int y1 = 0;
        private int x2 = 0;
        private int y2 = 0;
        private Object info = null;

        private InfoRectangle(int n, int n2, int n3, int n4, Object object) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
            this.info = object;
        }

        private boolean isInner(int n, int n2) {
            return this.x1 <= n && n <= this.x2 && this.y1 <= n2 && n2 <= this.y2;
        }
    }
}

