/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.ConnectWrapper;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Request;

class ImageCache {
    private static ImageCache imageCache = new ImageCache();
    private boolean hasOldCache;
    private boolean hasNewCache;
    private Hashtable oldCache = new Hashtable();
    private Hashtable newCache = new Hashtable();
    private Hashtable typeCache = new Hashtable();

    private ImageCache() {
    }

    static ImageCache getInstance() {
        return imageCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Image getImage(HawkContext hawkContext, URL uRL, String string, Request request, boolean bl) throws IOException, InterruptedException {
        String string2 = uRL.toExternalForm();
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Image image = null;
            if (this.hasNewCache && (image = (Image)this.newCache.get(string2)) != null) {
                return image;
            }
            if (this.hasOldCache && (image = (Image)this.oldCache.get(string2)) != null) {
                this.newCache.put(string2, image);
                this.oldCache.remove(string2);
                this.hasNewCache = true;
                this.hasOldCache = this.oldCache.size() > 0;
                return image;
            }
            if (!bl) {
                return null;
            }
            URLConnection uRLConnection = ConnectWrapper.getURLConnection(hawkContext, new Request(uRL, null, request.getDocument().url, null, false, false, 2));
            if (uRLConnection != null) {
                return this.createImage(hawkContext, string2, string, uRLConnection);
            }
        }
        this.reportMessage(hawkContext, 3, "render.info.image.null", new String[]{string});
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createImage(HawkContext hawkContext, String string, String string2, URLConnection uRLConnection) throws IOException {
        Object object = null;
        try {
            hawkContext.setStatus(Resource.getMessage("engine.status.load.start", new String[]{string}));
            object = uRLConnection.getContent();
        }
        catch (Exception exception) {
            this.reportMessage(hawkContext, 7, "render.warning.image.content", new String[]{string2});
            return null;
        }
        if (object instanceof ImageProducer) {
            String string3 = uRLConnection.getContentType();
            if (string3 != null) {
                this.typeCache.put(string, string3.toLowerCase());
            }
            Image image = hawkContext.createImage((ImageProducer)object);
            ImageCache imageCache = this;
            synchronized (imageCache) {
                this.newCache.put(string, image);
                this.hasNewCache = true;
            }
            return image;
        }
        this.reportMessage(hawkContext, 7, "render.warning.image.invalid", new String[]{string2});
        return null;
    }

    String getContentType(URL uRL) {
        return (String)this.typeCache.get(uRL.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            if (this.oldCache.size() > 0) {
                Enumeration enumeration = this.oldCache.elements();
                while (enumeration.hasMoreElements()) {
                    ((Image)enumeration.nextElement()).flush();
                }
                this.oldCache.clear();
                this.hasOldCache = false;
            }
            if (this.hasNewCache) {
                this.oldCache = this.newCache;
                this.newCache = new Hashtable();
                this.hasOldCache = true;
                this.hasNewCache = false;
            }
        }
    }

    private void reportMessage(HawkContext hawkContext, int n, String string, String[] stringArray) {
        Reporter reporter = hawkContext.getReporter();
        if (reporter != null) {
            reporter.report(n, Resource.getMessage(string, stringArray), 0, 0);
        }
    }
}

