/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.rendering.Counter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.ImageCache;
import net.hizlab.kagetaka.rendering.ImageHolder;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.StopException;
import net.hizlab.kagetaka.util.CharList;

class Drawkit {
    private static final int MT_WAIT = 10000;
    private static final int UL_DISC_SIZE = 6;
    private static final int UL_CIRCLE_SIZE = 6;
    private static final int UL_SQUARE_SIZE = 5;
    HawkContext context;
    private Reporter reporter;
    private Option option;
    private ImageCache imageCache;
    Request request;
    Document document;
    Dimension viewSize;
    Dimension size;
    ItemMap itemMap;
    Status baseStatus;
    Status nextStatus;
    Status status;
    CharList charsSpinRight;
    CharList charsSpinLtrb;
    CharList charsKinsokuHead;
    CharList charsKinsokuTail;
    boolean swapDecoration;
    boolean isSetupPanel = false;
    Image panel = null;
    int panelWidth = 0;
    int panelHeight = 0;
    Graphics g = null;
    Counter gCounter = null;
    Queue idQueue = new Queue();
    Vector ids = new Vector();
    Vector images = new Vector();
    Counter imageCounter = new Counter(0);
    SyncObserver imageDrawer = new SyncObserver();
    Vector floats = new Vector();
    Queue floatQueue;
    Vector formItems = new Vector();
    private Stack statusStack = new Stack();
    private int backImageLeft = 0;
    private MediaTracker mt = null;
    private char[] tateCs = new char[1];
    private int tateW;
    private int tateMax;

    Drawkit(HawkContext hawkContext, Request request) {
        this.context = hawkContext;
        this.reporter = hawkContext.getReporter();
        this.option = hawkContext.getOption();
        this.imageCache = ImageCache.getInstance();
        this.request = request;
        this.document = request.getDocument();
        this.viewSize = hawkContext.getViewportSize();
        this.size = new Dimension(0, 0);
        this.mt = hawkContext.getMediaTracker();
        this.itemMap = this.document.itemMap;
        this.charsSpinRight = this.option.getCharsSpinRight();
        this.charsSpinLtrb = this.option.getCharsSpinLtrb();
        this.charsKinsokuHead = this.option.getCharsKinsokuHead();
        this.charsKinsokuTail = this.option.getCharsKinsokuTail();
        this.swapDecoration = this.option.getSwapDecoration();
        this.baseStatus = this.status = new Status(this);
        this.status.type = 3001;
    }

    void saveStatus(int n) {
        this.statusStack.push(this.status);
        if (this.nextStatus == null) {
            this.status = (Status)this.status.clone();
            this.status.type = n;
        } else {
            this.nextStatus.parent = this.status;
            this.status = this.nextStatus;
            this.nextStatus = null;
        }
    }

    void resetStatus() {
        this.status = (Status)this.statusStack.pop();
    }

    void insertStatus(int n) {
        this.nextStatus = this.status;
        Status status = (Status)this.statusStack.peek();
        this.status = (Status)status.clone();
        this.status.type = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitImageLoad() {
        Counter counter = this.imageCounter;
        synchronized (counter) {
            while (this.imageCounter.current() > 0) {
                try {
                    this.imageCounter.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    for (int i = 0; i < this.images.size(); ++i) {
                        ImageHolder imageHolder = (ImageHolder)this.images.elementAt(i);
                        if (imageHolder.complete) continue;
                        this.reportMessage(3, "render.info.image.stop", new String[]{imageHolder.toString()});
                    }
                    throw new StopException("wait to load images");
                }
            }
        }
    }

    void stopImageLoad() {
        if (this.imageCounter.current() <= 0) {
            return;
        }
        for (int i = 0; i < this.images.size(); ++i) {
            ((ImageHolder)this.images.elementAt(i)).dispose();
        }
    }

    void dispose() {
        for (int i = 0; i < this.images.size(); ++i) {
            ((ImageHolder)this.images.elementAt(i)).dispose();
        }
        this.images.removeAllElements();
    }

    void createPanel(int n, int n2, Status status) {
        if (n == 0) {
            return;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (this.panel != null) {
            this.commitPanel();
            this.reportMessage(10, "internal.error", new String[]{"Render.createPanel", "panel not commit", ""});
        }
        this.panel = this.context.createImage(n, n2);
        this.panelWidth = n;
        this.panelHeight = n2;
        this.g = this.panel.getGraphics();
        this.gCounter = new Counter(1);
        if (this.baseStatus.backColor != null) {
            this.g.setColor(this.baseStatus.backColor);
            this.g.fillRect(0, 0, n, n2);
        }
        if (this.baseStatus.backImage != null) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            n3 = n + this.backImageLeft;
            do {
                n5 = n3;
                n7 = Math.min(0, n3 -= this.baseStatus.backImageSize.width);
                this.backImageLeft = this.baseStatus.backImageSize.width + n3;
                if (n3 < 0) {
                    n7 = -n3;
                    n3 = 0;
                }
                n9 = n7 + (n5 - n3);
                n6 = 0;
                n10 = this.baseStatus.backImageSize.height;
                do {
                    if ((n6 = (n4 = n6) + this.baseStatus.backImageSize.height) > n2) {
                        n10 -= n6 - n2;
                        n6 = n2;
                    }
                    this.drawImageSync(this.g, this.baseStatus.backImage, n3, n4, n5, n6, n7, n8, n9, n10);
                } while (n6 < n2);
            } while (n3 > 0);
        }
        this.size.width += n;
        this.size.height = Math.max(this.size.height, n2);
    }

    void commitPanel() {
        if (this.panel != null) {
            if (this.gCounter.decrement() <= 0) {
                this.g.dispose();
            }
            if (!this.isSetupPanel) {
                this.context.setupCanvas(this.request);
                this.isSetupPanel = true;
            }
            this.context.addImage(this.panel, this.panelWidth, this.panelHeight);
            this.panel = null;
            this.g = null;
            this.gCounter = null;
        }
    }

    void reportMessage(int n, String string, Object[] objectArray) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.report(n, Resource.getMessage(string, objectArray), 0, 0);
    }

    URL createURL(String string) {
        try {
            return this.document.createURL(string);
        }
        catch (SecurityException securityException) {
            this.reportMessage(7, "render.warning.security", new String[]{string, securityException.toString()});
        }
        catch (MalformedURLException malformedURLException) {
            this.reportMessage(7, "render.warning.href", new String[]{string, malformedURLException.toString()});
        }
        return null;
    }

    Image getImage(URL uRL, String string) {
        if (uRL == null) {
            return null;
        }
        try {
            return this.imageCache.getImage(this.context, uRL, string, this.request, this.option.getLoadImage());
        }
        catch (SecurityException securityException) {
            this.reportMessage(7, "render.warning.security", new String[]{string, securityException.toString()});
        }
        catch (IOException iOException) {
            this.reportMessage(7, "render.warning.io", new String[]{string, iOException.toString()});
        }
        catch (InterruptedException interruptedException) {
            throw new StopException("wait to load images");
        }
        return null;
    }

    int loadImage(Image image, String string) {
        this.mt.addImage(image, 0);
        try {
            this.mt.waitForID(0, 10000L);
        }
        catch (InterruptedException interruptedException) {
            throw new StopException(string);
        }
        int n = this.mt.statusID(0, true);
        this.mt.removeImage(image, 0);
        return n;
    }

    void drawTextTate(StringBuffer stringBuffer, int n, int n2, int n3, int n4, Status status, double d, int n5) {
        this.tateMax = status.fdFontSize.width;
        for (int i = n; i < n2; ++i) {
            this.tateCs[0] = stringBuffer.charAt(i);
            this.tateW = status.fm.charWidth(this.tateCs[0]);
            this.g.drawChars(this.tateCs, 0, 1, this.tateMax > this.tateW ? n3 + (this.tateMax - this.tateW) / 2 : n3, (n4 += (int)((double)(i * 2 + 1) * d) - (int)((double)(i * 2) * d)) + status.fontBaseFull);
            n4 += status.fdFontSize.height;
            n4 += (int)((double)(i * 2 + 2) * d) - (int)((double)(i * 2 + 1) * d);
            n4 += n5;
        }
    }

    void drawTextWithSpin(StringBuffer stringBuffer, int n, int n2, int n3, int n4, int n5, int n6, Status status, double d, int n7, char c) {
        if (n5 == 0) {
            return;
        }
        Color color = Color.white;
        Color color2 = Color.black;
        Image image = null;
        try {
            image = this.context.createImage(n5, n6);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("e=[" + stringBuffer + "],[" + n + "],[" + n2 + "],[" + n5 + "],[" + n6 + "]");
            return;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            System.out.println("e=[" + stringBuffer + "],[" + n + "],[" + n2 + "],[" + n5 + "],[" + n6 + "]");
            return;
        }
        Graphics graphics = image.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, n5, n6);
        graphics.setColor(color2);
        graphics.setFont(status.font);
        int n8 = 0;
        if (c == '3') {
            n8 = status.fontBaseFull + (status.fdFontSize.height - status.fontBaseFull) / 2;
        }
        int n9 = 0;
        for (int i = n; i < n2; ++i) {
            char c2;
            this.tateCs[0] = c2 = stringBuffer.charAt(i);
            if (c == '2') {
                n8 = c2 <= '\u00ff' || '\uff61' <= c2 && c2 <= '\uff9f' ? status.fontBaseHalf : status.fontBaseFull;
            }
            graphics.drawChars(this.tateCs, 0, 1, n9 += (int)((double)(i * 2 + 1) * d) - (int)((double)(i * 2) * d), n8);
            n9 += status.fm.charWidth(this.tateCs[0]);
            n9 += (int)((double)(i * 2 + 2) * d) - (int)((double)(i * 2 + 1) * d);
            n9 += n7;
        }
        graphics.dispose();
        int[] nArray = new int[n5 * n6];
        int[] nArray2 = new int[n5 * n6];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n5, n6, nArray, 0, n5);
        try {
            pixelGrabber.grabPixels(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        switch (c) {
            case '2': {
                int n10;
                for (n9 = 0; n9 < n5; ++n9) {
                    for (n10 = 0; n10 < n6; ++n10) {
                        nArray2[n9 * n6 + n10] = nArray[n9 + (n6 - n10 - 1) * n5];
                    }
                }
                break;
            }
            case '3': {
                int n10;
                for (n9 = 0; n9 < n5; ++n9) {
                    for (n10 = 0; n10 < n6; ++n10) {
                        nArray2[n9 * n6 + n10] = nArray[n9 + n10 * n5];
                    }
                }
                break;
            }
        }
        int n11 = color.getRGB();
        int n12 = status.foreColor.getRGB() | 0xFF000000;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == n11) {
                int n13 = i;
                nArray2[n13] = nArray2[n13] & 0xFFFFFF;
                continue;
            }
            nArray2[i] = n12;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n6, n5, nArray2, 0, n6);
        memoryImageSource.setAnimated(false);
        Image image2 = this.context.createImage(memoryImageSource);
        this.drawImageSync(this.g, image2, n3, n4, n6, n5);
        image.flush();
        image2.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawImageSync(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        SyncObserver syncObserver = this.imageDrawer;
        synchronized (syncObserver) {
            this.imageDrawer.init(graphics, n, n2, n3, n4);
            if (!graphics.drawImage(image, n, n2, n3, n4, this.imageDrawer)) {
                try {
                    this.imageDrawer.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new StopException("wait to draw a image");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawImageSync(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        SyncObserver syncObserver = this.imageDrawer;
        synchronized (syncObserver) {
            this.imageDrawer.init(graphics, n, n2, n3 - n, n4 - n2);
            if (!graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, this.imageDrawer)) {
                try {
                    this.imageDrawer.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new StopException("wait to draw a image");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void drawListItem(int n, int n2, Status status) {
        this.g.setColor(status.foreColor);
        block0 : switch (status.listType) {
            case 3: {
                break;
            }
            case 81: {
                this.g.fillOval(n + (status.fdFontSize.width - 6) / 2, n2 - (status.fdFontSize.height + 6) / 2, 6, 6);
                break;
            }
            case 82: {
                this.g.drawOval(n + (status.fdFontSize.width - 6) / 2, n2 - (status.fdFontSize.height + 6) / 2, 6, 6);
                break;
            }
            case 83: {
                this.g.fillRect(n + (status.fdFontSize.width - 5) / 2, n2 - (status.fdFontSize.height + 5) / 2, 5, 5);
                break;
            }
            default: {
                char c;
                char c3;
                StringBuffer stringBuffer = new StringBuffer();
                switch (status.listType) {
                    case 85: {
                        if (status.counterStatus.counterNo < 10) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(status.counterStatus.counterNo);
                        break;
                    }
                    case 86: 
                    case 87: {
                        char c2;
                        if (status.counterStatus.counterNo >= 5000) {
                            stringBuffer.append(status.counterStatus.counterNo);
                            break;
                        }
                        int n3 = status.counterStatus.counterNo;
                        int n4 = 0;
                        char[] cArray = null;
                        cArray = status.listType == 86 ? new char[]{'i', 'v', 'x', 'l', 'c', 'd', 'm', '?', '?'} : new char[]{'I', 'V', 'X', 'L', 'C', 'D', 'M', '?', '?'};
                        if (n3 <= 0) {
                            n3 = 1;
                        }
                        while (n3 > 0 && n4 < 7) {
                            c3 = cArray[n4];
                            char c22 = cArray[n4 + 1];
                            c2 = cArray[n4 + 2];
                            switch (n3 % 10) {
                                case 1: {
                                    stringBuffer.append(c3);
                                    break;
                                }
                                case 2: {
                                    stringBuffer.append(c3);
                                    stringBuffer.append(c3);
                                    break;
                                }
                                case 3: {
                                    stringBuffer.append(c3);
                                    stringBuffer.append(c3);
                                    stringBuffer.append(c3);
                                    break;
                                }
                                case 4: {
                                    stringBuffer.append(c22);
                                    stringBuffer.append(c3);
                                    break;
                                }
                                case 5: {
                                    stringBuffer.append(c22);
                                    break;
                                }
                                case 6: {
                                    stringBuffer.append(c3);
                                    stringBuffer.append(c22);
                                    break;
                                }
                                case 7: {
                                    stringBuffer.append(c3);
                                    stringBuffer.append(c3);
                                    stringBuffer.append(c22);
                                    break;
                                }
                                case 8: {
                                    stringBuffer.append(c3);
                                    stringBuffer.append(c3);
                                    stringBuffer.append(c3);
                                    stringBuffer.append(c22);
                                    break;
                                }
                                case 9: {
                                    stringBuffer.append(c2);
                                    stringBuffer.append(c3);
                                }
                            }
                            n3 /= 10;
                            n4 += 2;
                        }
                        stringBuffer.reverse();
                        break;
                    }
                    case 91: {
                        String string = Resource.getMessage("chars.list.cjk.ideographic", null);
                        int n5 = status.counterStatus.counterNo;
                        if (n5 <= 0) {
                            n5 = 1;
                        }
                        c3 = '\u0001';
                        boolean bl = false;
                        char c2 = '\u0000';
                        while (true) {
                            void var9_22;
                            int n6;
                            if ((n6 = n5 % 10) > 0) {
                                if (var9_22 > 0 && c2 == '\u0000') {
                                    stringBuffer.append(string.charAt((int)(var9_22 + 11)));
                                    c2 = '\u0001';
                                }
                                if (c3 > '\u0001') {
                                    stringBuffer.append(string.charAt(c3 + 7));
                                }
                                stringBuffer.append(string.charAt(n6 - 1));
                            }
                            if ((n5 /= 10) == 0) break;
                            if (++c3 != 5) continue;
                            c3 = '\u0001';
                            ++var9_22;
                            c2 = '\u0000';
                        }
                        stringBuffer.reverse();
                        break;
                    }
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 100: {
                        String string = null;
                        switch (status.listType) {
                            case 92: {
                                string = "chars.list.hiragana";
                                break;
                            }
                            case 93: {
                                string = "chars.list.katakana";
                                break;
                            }
                            case 94: {
                                string = "chars.list.hiragana.iroha";
                                break;
                            }
                            case 95: {
                                string = "chars.list.katakana.iroha";
                                break;
                            }
                            case 100: {
                                string = "chars.list.lower.greek";
                            }
                        }
                        String string2 = Resource.getMessage(string, null);
                        int n7 = status.counterStatus.counterNo - 1;
                        if (n7 < 0) {
                            n7 = 0;
                        }
                        if (n7 < string2.length()) {
                            stringBuffer.append(string2.charAt(n7));
                            break;
                        }
                        stringBuffer.append(status.counterStatus.counterNo);
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: {
                        boolean bl;
                        int n8 = status.counterStatus.counterNo;
                        if (n8 <= 0) {
                            n8 = 1;
                        }
                        boolean bl2 = bl = status.listType == 96 || status.listType == 98;
                        while (n8 > 0) {
                            stringBuffer.append((char)(n8 % 26 - 1 + (bl ? 97 : 65)));
                            n8 /= 26;
                        }
                        stringBuffer.reverse();
                        break;
                    }
                    default: {
                        stringBuffer.append(status.counterStatus.counterNo);
                    }
                }
                int n9 = 0;
                if (status.letterSpacing != null) {
                    n9 = status.letterSpacing.getValue(status.fd, status.fdFontSize.width, 2);
                }
                char c5 = '\u0000';
                int n10 = 0;
                if (stringBuffer.length() > 0) {
                    c5 = stringBuffer.charAt(0);
                    n10 = c5 <= '\u00ff' || '\uff61' <= c5 && c5 <= '\uff9f' || this.charsSpinRight.contains(c5) ? 49 : 50;
                    stringBuffer.append(Resource.getMessage("chars.value.list." + (char)n10, null));
                }
                c3 = '\u0000';
                char c4 = stringBuffer.length();
                StringBuffer stringBuffer2 = new StringBuffer();
                for (c = '\u0000'; c < c4; ++c) {
                    c5 = stringBuffer.charAt(c);
                    n10 = c5 <= '\u00ff' || '\uff61' <= c5 && c5 <= '\uff9f' || this.charsSpinRight.contains(c5) ? 50 : (this.charsSpinLtrb.contains(c5) ? 51 : 49);
                    stringBuffer2.append((char)n10);
                    c3 = n10 == 49 ? (c3 += status.fdFontSize.height) : (c3 += status.fm.charWidth(c5));
                    c3 += n9;
                }
                this.g.setColor(status.foreColor);
                this.g.setFont(status.font);
                n2 -= c3 + 2;
                c3 = '\u0000';
                c = '\u0000';
                char c6 = '\u0000';
                char c7 = '\u0000';
                for (char c8 = '\u0000'; c8 <= c4; ++c8) {
                    c6 = c8 < c4 ? stringBuffer2.charAt(c8) : (char)'\u0000';
                    if (c != c6) {
                        if (c == '1') {
                            this.drawTextTate(stringBuffer, c7, c8, n, n2, status, 0.0, n9);
                        } else {
                            this.drawTextWithSpin(stringBuffer, c7, c8, n, n2, c3, status.fdFontSize.height, status, 0.0, n9, c);
                        }
                        n2 += c3;
                        c3 = '\u0000';
                        c = c6;
                        c7 = c8;
                    }
                    if (c8 == c4) break block0;
                    c3 = c6 == '1' ? (c3 += status.fdFontSize.height) : (c3 += status.fm.charWidth(stringBuffer.charAt(c8)));
                    c3 += n9;
                }
            }
        }
        ++status.counterStatus.counterNo;
    }
}

