/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.InnerToolTip;
import net.hizlab.kagetaka.awt.image.OffscreenObserver;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.token.FormItem;

class Canvas
extends Container {
    private static final int TIP_BOTTOM = 22;
    private HawkContext hawkContext;
    private Object offscreenLock = new Object();
    private Image offscreen = null;
    private Dimension offscreenSize = null;
    private Graphics offscreenGraphics = null;
    private int offscreenPointer = 0;
    private int offscreenIndex = 0;
    private Object tilesLock = new Object();
    private Tile[] tiles = new Tile[10];
    private int tilesCount = 0;
    private int tilesWidth = 0;
    private Point position = new Point(0, 0);
    private Vector formItems = new Vector();
    private boolean hasFormItems = false;
    private ToolTip toolTip;
    private Color backColor = null;
    private Image backImage = null;
    private Dimension backImageSize = null;

    Canvas(HawkContext hawkContext) {
        this.hawkContext = hawkContext;
        this.setLayout(null);
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentResized(ComponentEvent componentEvent) {
                Object object = Canvas.this.offscreenLock;
                synchronized (object) {
                    if (Canvas.this.offscreen != null) {
                        if (Canvas.this.offscreenSize.equals(Canvas.this.getSize())) {
                            return;
                        }
                        Canvas.this.clearOffscreen();
                        Canvas.this.repaint();
                    }
                }
            }

            public void componentHidden(ComponentEvent componentEvent) {
                Canvas.this.clearOffscreen();
            }
        });
        this.backColor = Document.DEFAULT_BACKGROUND_COLOR;
        this.setBackground(this.backColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addImage(Image image, int n, int n2) {
        Object object = this.tilesLock;
        synchronized (object) {
            Tile tile;
            if (this.tilesCount == this.tiles.length) {
                int n3 = (int)((double)this.tilesCount * (this.tilesCount > 300 ? 1.5 : 2.0));
                Tile[] tileArray = new Tile[n3];
                System.arraycopy(this.tiles, 0, tileArray, 0, this.tilesCount);
                this.tiles = tileArray;
            }
            if ((tile = this.tiles[this.tilesCount]) == null) {
                this.tiles[this.tilesCount] = tile = new Tile(image, n, n2);
                if (this.tilesCount > 0) {
                    this.tiles[this.tilesCount - 1].next = tile;
                }
            } else {
                tile.reset(image, n, n2);
            }
            this.tilesWidth += n;
            ++this.tilesCount;
        }
        object = this.offscreenLock;
        synchronized (object) {
            if (this.isShowing() && (this.offscreen == null || this.offscreenPointer > 0)) {
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFormItem(FormItem formItem) {
        int n;
        int n2;
        this.hasFormItems = true;
        this.formItems.addElement(formItem);
        Object object = this.position;
        synchronized (object) {
            n2 = this.position.x;
            n = this.position.y;
        }
        object = this.tilesLock;
        synchronized (object) {
            if (this.offscreen == null) {
                return;
            }
            Point point = formItem.getPosition();
            Dimension dimension = formItem.getSize();
            if (n2 <= point.x + dimension.width && n <= point.y + dimension.height && n2 + this.offscreenSize.width >= point.x && n + this.offscreenSize.height >= point.y) {
                Component component = formItem.getComponent();
                this.add(component);
                component.setBounds(this.offscreenSize.width - point.x + n2 - dimension.width, point.y - n, dimension.width, dimension.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaintImage(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        Tile[] tileArray;
        Object object = this.tilesLock;
        synchronized (object) {
            tileArray = this.tiles;
            n7 = this.tilesCount;
        }
        Object object2 = this.position;
        synchronized (object2) {
            n6 = this.position.x;
            n5 = this.position.y;
        }
        object2 = this.offscreenLock;
        synchronized (object2) {
            int n8;
            if (this.offscreen == null) {
                this.repaint();
                return;
            }
            int n9 = this.offscreenSize.width + n6;
            int n10 = n9 - n;
            int n11 = n10 - n3;
            int n12 = n2 - n5;
            int n13 = n12 + n4;
            if (n10 < 0 || this.offscreenSize.width <= n11 || n13 < 0 || this.offscreenSize.height <= n12 || (n8 = this.getTileIndex(tileArray, n7, n, 0)) == -1) {
                return;
            }
            int n14 = n2 + n4;
            Tile tile = tileArray[n8];
            boolean bl = true;
            OffscreenObserver offscreenObserver = null;
            boolean bl2 = false;
            if (n12 < 0) {
                n2 -= n12;
                n12 = 0;
            }
            if (this.offscreenSize.height < n13) {
                int n15 = n13 - this.offscreenSize.height;
                n14 -= n15;
                n13 -= n15;
            }
            do {
                int n16;
                int n17;
                if (!bl2) {
                    offscreenObserver = new OffscreenObserver(this, this.offscreenGraphics);
                    offscreenObserver.y = n12;
                }
                if ((n17 = n9 - tile.left) <= n11) {
                    offscreenObserver.x = n11;
                    n17 = n11 - n17;
                    n16 = bl ? n17 + n3 : tile.width;
                    bl2 = this.offscreenGraphics.drawImage(tile.image, offscreenObserver.x, n12, n10, n13, n17, n2, n16, n14, offscreenObserver);
                    break;
                }
                offscreenObserver.x = n17;
                if (bl) {
                    n16 = n10 - n17;
                    bl = false;
                } else {
                    n16 = tile.width;
                }
                bl2 = this.offscreenGraphics.drawImage(tile.image, offscreenObserver.x, n12, n10, n13, 0, n2, n16, n14, offscreenObserver);
                n10 = n17;
                tile = tile.next;
            } while (++n8 < n7);
            this.paintItem();
            if (this.isShowing()) {
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    try {
                        graphics.drawImage(this.offscreen, 0, 0, this);
                    }
                    finally {
                        graphics.dispose();
                    }
                } else {
                    this.repaint();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupScreen(Color color, Image image) {
        Object object = this.position;
        synchronized (object) {
            this.position.x = 0;
            this.position.y = 0;
        }
        object = this.offscreenLock;
        synchronized (object) {
            if (this.offscreen != null) {
                this.offscreenPointer = this.offscreenSize.width;
            }
            this.offscreenIndex = 0;
        }
        object = this.tilesLock;
        synchronized (object) {
            for (int i = 0; i < this.tilesCount; ++i) {
                this.tiles[i].image.flush();
                this.tiles[i].next = null;
                this.tiles[i] = null;
            }
            this.tilesCount = 0;
            this.tilesWidth = 0;
            this.formItems.removeAllElements();
            this.hasFormItems = false;
            this.removeAll();
        }
        this.backColor = color;
        this.backImage = image;
        super.setBackground(color);
        if (image != null) {
            this.backImageSize = new Dimension(image.getWidth(this), image.getHeight(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void movePosition(int n, int n2) {
        Object object = this.position;
        synchronized (object) {
            this.position.x = n;
            this.position.y = n2;
        }
        object = this.offscreenLock;
        synchronized (object) {
            if (this.offscreen == null) {
                return;
            }
            this.offscreenPointer = this.offscreenSize.width;
            this.offscreenIndex = 0;
            if (this.hasFormItems) {
                this.allocateFormItems(n, n2);
            }
        }
        if (this.isShowing()) {
            object = this.getGraphics();
            if (object != null) {
                try {
                    this.paint((Graphics)object);
                }
                finally {
                    ((Graphics)object).dispose();
                }
            } else {
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showToolTip(String string, int n, int n2, long l, long l2) {
        int n3;
        int n4;
        Dimension dimension = this.offscreenSize;
        Point point = this.position;
        synchronized (point) {
            n4 = this.position.x;
            n3 = this.position.y;
            if (this.toolTip == null) {
                this.toolTip = new ToolTip(this.hawkContext, l, l2, new Insets(0, 0, 44, 0));
            } else {
                this.toolTip.setDelay(l);
                this.toolTip.setTerm(l2);
            }
        }
        this.toolTip.showTip(string, n, n2 + 22, dimension.width, dimension.height, n4, n3);
    }

    void clearToolTip() {
        if (this.toolTip != null) {
            this.toolTip.cancel();
        }
    }

    void cleanup() {
        if (this.toolTip != null) {
            this.toolTip.dispose();
            this.toolTip = null;
        }
        this.setupScreen(null, null);
        this.clearOffscreen();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Tile[] tileArray = this.position;
        synchronized (this.position) {
            int n;
            int n2 = this.position.x;
            int n3 = this.position.y;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            Object object = this.tilesLock;
            synchronized (object) {
                tileArray = this.tiles;
                n = this.tilesCount;
            }
            object = this.offscreenLock;
            synchronized (object) {
                if (this.offscreen == null) {
                    Dimension dimension = this.getSize();
                    this.offscreen = this.createImage(dimension.width, dimension.height);
                    this.offscreenSize = dimension;
                    this.offscreenGraphics = this.offscreen.getGraphics();
                    this.offscreenPointer = dimension.width;
                    this.offscreenIndex = 0;
                    if (this.hasFormItems) {
                        this.allocateFormItems(n2, n3);
                    }
                }
                int n4 = this.offscreenIndex;
                if (this.offscreenPointer > 0 && this.offscreenIndex < n && (tileArray[n4].left > n2 || (n4 = this.getTileIndex(tileArray, n, n2, this.offscreenIndex)) >= 0)) {
                    Tile tile = tileArray[n4];
                    int n5 = this.offscreenSize.height;
                    OffscreenObserver offscreenObserver = null;
                    boolean bl = false;
                    this.offscreenPointer = this.offscreenSize.width - (tile.right - n2);
                    do {
                        if (!bl) {
                            offscreenObserver = new OffscreenObserver(this, this.offscreenGraphics);
                        }
                        int n6 = this.offscreenPointer;
                        int n7 = Math.min(tile.height - n3, n5);
                        offscreenObserver.x = this.offscreenPointer -= tile.width;
                        bl = this.offscreenGraphics.drawImage(tile.image, offscreenObserver.x, 0, n6, n7, 0, n3, tile.width, Math.min(tile.height, n5 + n3), offscreenObserver);
                        if (n7 < n5) {
                            this.drawBackground(offscreenObserver.x, n7, n6, n5, n2, n3);
                        }
                        tile = tile.next;
                    } while (++n4 < n && this.offscreenPointer > 0);
                    this.offscreenIndex = n4;
                    if (this.offscreenPointer > 0) {
                        this.drawBackground(0, 0, this.offscreenPointer, this.offscreenSize.height, n2, n3);
                    }
                }
                this.paintItem();
                graphics.drawImage(this.offscreen, 0, 0, this);
            }
            return;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected String paramString() {
        String string = super.paramString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOffscreen() {
        Object object = this.offscreenLock;
        synchronized (object) {
            if (this.offscreen != null) {
                this.offscreenGraphics.dispose();
                this.offscreen.flush();
            }
            this.offscreen = null;
            this.offscreenSize = null;
            this.offscreenGraphics = null;
            this.offscreenPointer = 0;
            this.offscreenIndex = 0;
        }
    }

    private int getTileIndex(Tile[] tileArray, int n, int n2, int n3) {
        if (tileArray[n - 1].left <= n2) {
            return -1;
        }
        int n4 = n - 1;
        while (n3 + 1 < n4) {
            int n5 = (n4 - n3) / 2 + n3;
            int n6 = tileArray[n5].right;
            if (n6 == n2) {
                return n5;
            }
            if (n6 < n2) {
                n3 = n5;
                continue;
            }
            n4 = n5;
        }
        return n3;
    }

    private void drawBackground(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.backImage == null) {
            this.offscreenGraphics.setColor(this.backColor);
            this.offscreenGraphics.fillRect(n, n2, n3 - n, n4 - n2);
        } else {
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            n11 = (n5 + (this.offscreenSize.width - n3)) % this.backImageSize.width + n3;
            int n15 = (n6 + n2) % this.backImageSize.width;
            do {
                n7 = 0;
                n9 = this.backImageSize.width;
                n13 = n11;
                n11 -= this.backImageSize.width;
                if (n13 > n3) {
                    n9 -= n13 - n3;
                    n13 = n3;
                }
                if (n11 < n) {
                    n7 = n - n11;
                    n11 = n;
                }
                n10 = this.backImageSize.height;
                n14 = n2 - n15;
                do {
                    n8 = 0;
                    n12 = n14;
                    n14 += this.backImageSize.height;
                    if (n12 < n2) {
                        n8 = n2 - n12;
                        n12 = n2;
                    }
                    if (n14 > n4) {
                        n10 -= n14 - n4;
                        n14 = n4;
                    }
                    this.offscreenGraphics.drawImage(this.backImage, n11, n12, n13, n14, n7, n8, n9, n10, this);
                } while (n14 < n4);
            } while (n11 > n);
        }
    }

    private void allocateFormItems(int n, int n2) {
        for (int i = this.formItems.size() - 1; i >= 0; --i) {
            this.allocateFormItem((FormItem)this.formItems.elementAt(i), n, n2);
        }
    }

    private void allocateFormItem(FormItem formItem, int n, int n2) {
        Point point = formItem.getPosition();
        Dimension dimension = formItem.getSize();
        Component component = formItem.getComponent();
        if (n <= point.x + dimension.width && n2 <= point.y + dimension.height && n + this.offscreenSize.width >= point.x && n2 + this.offscreenSize.height >= point.y) {
            if (component.getParent() == null) {
                this.add(component);
            }
            component.setBounds(this.offscreenSize.width - point.x + n - dimension.width, point.y - n2, dimension.width, dimension.height);
        } else if (component.getParent() != null) {
            this.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintItem() {
        Object object;
        if (this.hasFormItems) {
            object = this.getComponents();
            for (int i = ((Component[])object).length - 1; i >= 0; --i) {
                Object object2 = object[i];
                if (object2 == null) continue;
                Rectangle rectangle = ((Component)object2).getBounds();
                Graphics graphics = this.offscreenGraphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                try {
                    ((Component)object2).paintAll(graphics);
                    continue;
                }
                finally {
                    graphics.dispose();
                }
            }
        }
        if ((object = this.toolTip) != null) {
            ((InnerToolTip)object).paint(this.offscreenGraphics);
        }
    }

    private class ToolTip
    extends InnerToolTip {
        private int left;
        private int top;

        private ToolTip(ImageCreator imageCreator, long l, long l2, Insets insets) {
            super(imageCreator, l, l2, insets);
        }

        public void showTip(String string, int n, int n2, int n3, int n4, int n5, int n6) {
            super.showTip(string, n, n2, n3, n4);
            this.left = n3 + n5;
            this.top = n6;
        }

        public void repaint(int n, int n2, int n3, int n4) {
            Canvas.this.repaintImage(this.left - n - n3, this.top + n2, n3, n4);
        }
    }

    private class Tile {
        private Image image;
        private int width;
        private int height;
        private int right;
        private int left;
        private Tile next;

        private Tile(Image image, int n, int n2) {
            this.reset(image, n, n2);
        }

        private void reset(Image image, int n, int n2) {
            this.image = image;
            this.width = n;
            this.height = n2;
            this.right = Canvas.this.tilesWidth;
            this.left = this.right + n;
        }
    }
}

