/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.hizlab.kagetaka.io.CounterListener;

public class CounterInputStream
extends FilterInputStream {
    private CounterListener listener;
    private boolean marked = false;
    private long length = 0L;
    private long temporary = 0L;
    int i;
    long l;

    public CounterInputStream(InputStream inputStream, CounterListener counterListener) {
        super(inputStream);
        this.listener = counterListener;
    }

    public int read() throws IOException {
        this.i = super.read();
        if (this.i != -1) {
            this.append(1L);
        }
        return this.i;
    }

    public int read(byte[] byArray) throws IOException {
        this.i = super.read(byArray);
        if (this.i > 0) {
            this.append(this.i);
        }
        return this.i;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.i = super.read(byArray, n, n2);
        if (this.i > 0) {
            this.append(this.i);
        }
        return this.i;
    }

    public long skip(long l) throws IOException {
        this.l = super.skip(l);
        if (this.l > 0L) {
            this.append(this.l);
        }
        return this.l;
    }

    public synchronized void mark(int n) {
        super.mark(n);
        this.marked = n > 0;
        this.length += this.temporary;
        this.temporary = 0L;
    }

    public synchronized void reset() throws IOException {
        try {
            super.reset();
        }
        catch (IOException iOException) {
            this.marked = false;
            this.length += this.temporary;
            this.temporary = 0L;
            throw iOException;
        }
        if (this.listener != null && this.temporary > 0L) {
            this.listener.changeLength(this.length);
        }
        this.temporary = 0L;
    }

    private void append(long l) {
        if (this.marked) {
            this.temporary += l;
        } else {
            this.length += l;
        }
        if (this.listener != null) {
            this.listener.changeLength(this.temporary + this.length);
        }
    }
}

