/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.io.BufferedReader;
import java.io.IOException;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.ParseException;
import net.hizlab.kagetaka.build.Tag;

public class TagReader {
    private BufferedReader br = null;
    private Reporter reporter = null;
    private String line = "";
    private int offset = 0;
    private int length = 0;
    private int lineNumber = 0;
    private int columnNumber = 1;
    private Tag nextTag = null;

    public TagReader(BufferedReader bufferedReader, Reporter reporter) {
        this.br = bufferedReader;
        this.reporter = reporter;
    }

    public Tag readTag() throws ParseException, IOException {
        String string;
        String string2;
        if (this.nextTag != null) {
            Tag tag = this.nextTag;
            this.nextTag = null;
            return tag;
        }
        if (this.line == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        String string3 = null;
        int n = this.lineNumber;
        int n2 = this.columnNumber;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.startsWith("<![CDATA[")) {
            n3 = 2;
            string2 = "<![CDATA[";
            string = "]]>";
            n5 = 3;
        } else if (this.startsWith("<!--")) {
            n3 = 4;
            string2 = "<!--";
            string = "-->";
            n4 = 3;
        } else if (this.startsWith("<?")) {
            n3 = 5;
            string2 = "<?";
            string = "?>";
            n4 = 2;
        } else if (this.startsWith("<!")) {
            n3 = 3;
            string2 = "<!";
            string = ">";
            n4 = 1;
        } else if (this.startsWith("<")) {
            n3 = 1;
            string2 = "<";
            string = ">";
            n4 = 1;
        } else {
            n3 = 2;
            string2 = null;
            string = "<";
        }
        do {
            int n6;
            if (this.offset < this.length && (n6 = this.line.indexOf(string, this.offset)) != -1) {
                n6 += n4;
                if (stringBuffer == null) {
                    string3 = this.line.substring(this.offset, n6);
                } else {
                    stringBuffer.append(this.line.substring(this.offset, n6));
                    string3 = stringBuffer.toString();
                }
                this.calculateColumnNumber(n6 + n5);
                this.offset = n6 + n5;
                break;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (this.offset < this.length) {
                stringBuffer.append(this.line.substring(this.offset));
            }
            stringBuffer.append('\n');
        } while (this.readLine());
        if (string3 == null) {
            string3 = stringBuffer.toString();
            if (string2 != null && this.reporter != null) {
                this.reporter.report(7, Resource.getMessage("tagreader.warning.bracket.notclose", new String[]{string2, string}), n, n2);
            }
        }
        return new Tag(this.reporter, n, n2, n3, string3);
    }

    public String readContent(String string, boolean bl) throws ParseException, IOException {
        if (this.line == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        String string2 = null;
        do {
            if (this.offset < this.length) {
                int n3 = bl ? this.line.indexOf("</", this.offset) : this.line.indexOf(60, this.offset);
                if (n3 != -1) {
                    this.calculateColumnNumber(n3);
                    n = this.lineNumber;
                    n2 = this.columnNumber;
                    stringBuffer.append(this.line.substring(this.offset, n3));
                    if (!bl) {
                        this.offset = n3;
                        return stringBuffer.toString();
                    }
                    this.columnNumber += 2;
                    this.offset = n3 + 2;
                    n3 = this.line.indexOf(">", this.offset);
                    if (n3 != -1) {
                        string2 = this.line.substring(this.offset, n3);
                        this.calculateColumnNumber(n3 + 1);
                        this.offset = n3 + 1;
                    } else {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        stringBuffer2.append(this.line.substring(this.offset));
                        stringBuffer2.append('\n');
                        while (this.readLine()) {
                            n3 = this.line.indexOf(">");
                            if (n3 != -1) {
                                stringBuffer2.append(this.line.substring(0, n3));
                                this.calculateColumnNumber(n3 + 1);
                                this.offset = n3 + 1;
                                break;
                            }
                            stringBuffer2.append(this.line);
                            stringBuffer2.append('\n');
                        }
                        string2 = stringBuffer2.toString();
                    }
                    if (string2.trim().toLowerCase().compareTo(string) == 0) {
                        this.nextTag = new Tag(this.reporter, n, n2, 1, "</" + string2 + ">");
                        return stringBuffer.toString();
                    }
                    stringBuffer.append("</");
                    stringBuffer.append(string2);
                    stringBuffer.append('>');
                }
                stringBuffer.append(this.line.substring(this.offset));
            }
            stringBuffer.append('\n');
        } while (this.readLine());
        return stringBuffer.toString();
    }

    private boolean readLine() throws IOException {
        this.line = this.br.readLine();
        if (this.line == null) {
            this.offset = 0;
            this.length = 0;
            return false;
        }
        ++this.lineNumber;
        this.columnNumber = 1;
        this.offset = 0;
        this.length = this.line.length();
        return true;
    }

    private void calculateColumnNumber(int n) {
        for (int i = this.offset; i < n; ++i) {
            char c = this.line.charAt(i);
            if (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f') {
                ++this.columnNumber;
                continue;
            }
            this.columnNumber += 2;
        }
    }

    private boolean startsWith(String string) {
        return this.offset < this.length && this.line.startsWith(string, this.offset);
    }

    public void close() throws IOException {
        this.br.close();
    }
}

