/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.CacheReporter;
import net.hizlab.kagetaka.build.InputStreamParser;
import net.hizlab.kagetaka.build.ParseException;
import net.hizlab.kagetaka.build.Tag;
import net.hizlab.kagetaka.build.TagReader;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.MetaAttribute;
import net.hizlab.kagetaka.token.MiscToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TextToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenManager;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.ContentType;

public class TagParser
implements InputStreamParser {
    private static final int INPUT_BUFFER = 8192;
    private Document document = null;
    private InputStream is = null;
    private BufferedInputStream bis = null;
    private TagReader tagReader = null;
    private String encoding = null;
    private Reporter reporter = null;
    private CacheReporter cacheReporter = null;
    private String lastElementName = "html";
    private boolean commitEncoding = false;
    private Queue tokenQueue = null;

    public void setInputStream(Document document, InputStream inputStream, Reporter reporter) {
        if (this.is != null) {
            throw new RuntimeException("Already set InputStream");
        }
        this.document = document;
        this.is = inputStream;
        this.encoding = document.getEncoding();
        this.reporter = reporter;
        BufferedReader bufferedReader = null;
        if (this.encoding != null && (bufferedReader = this.createBufferedReader(inputStream, this.encoding)) != null) {
            this.commitEncoding = true;
        } else {
            this.bis = new BufferedInputStream(inputStream, 8192);
            this.bis.mark(32768);
            bufferedReader = this.createBufferedReader(this.bis, Charset.getDefaultEncoding());
            this.tokenQueue = new Queue(20);
            this.cacheReporter = new CacheReporter(reporter);
            this.reporter = this.cacheReporter;
        }
        this.tagReader = new TagReader(bufferedReader, reporter);
    }

    private BufferedReader createBufferedReader(InputStream inputStream, String string) {
        if (string != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string), 8192);
                this.document.setEncoding(string);
                return bufferedReader;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.addWarning("charset.warning.invalid", new String[]{string}, null);
                return null;
            }
        }
        return new BufferedReader(new InputStreamReader(inputStream), 8192);
    }

    public String getParserName() {
        return Resource.getMessage("tagparser.name", null);
    }

    public String getParserDescription() {
        return Resource.getMessage("tagparser.description", null);
    }

    public synchronized Token next() throws ParseException, IOException {
        if (this.is == null) {
            throw new RuntimeException("No InputStream yet");
        }
        Tag tag = null;
        Token token = null;
        if (this.commitEncoding && this.tokenQueue != null) {
            token = (Token)this.tokenQueue.get();
            if (token != null) {
                return token;
            }
            this.tokenQueue = null;
        }
        block4: while (true) {
            if ((tag = this.tagReader.readTag()) == null) {
                if (!this.commitEncoding) {
                    this.commitEncoding = true;
                }
                if (this.tokenQueue != null) {
                    return (Token)this.tokenQueue.get();
                }
                return null;
            }
            switch (tag.getType()) {
                case 1: {
                    if (tag.getElement() == null) {
                        tag.setElement(this.lastElementName);
                    } else {
                        this.lastElementName = tag.getElement();
                    }
                    if (!tag.isEndTag()) {
                        token = this.createStartToken(tag);
                        break;
                    }
                    token = this.createEndToken(tag);
                    break;
                }
                case 2: {
                    token = this.createTextToken(tag);
                    break;
                }
                default: {
                    if (!this.commitEncoding && tag.getType() == 5 && tag.getElement() != null && tag.getElement().compareTo("xml") == 0 && tag.getAttribute() != null) {
                        this.resetEncoding((String)tag.getAttribute().get("encoding"), tag);
                        continue block4;
                    }
                    token = this.createMiscToken(tag);
                }
            }
            if (token == null) continue;
            int n = token.getType();
            int n2 = TokenTypes.isContent(n);
            if (n2 != 0) {
                String string = token.getName();
                String string2 = this.tagReader.readContent(string, n2 == 2);
                ((StartToken)token).setContent(string2);
            }
            if (this.commitEncoding) {
                return token;
            }
            this.tokenQueue.put(token);
            if (n == 2019) {
                this.checkCharSet(token, tag);
                continue;
            }
            if (n != 2002 && !TokenTypes.isBody(n)) continue;
            this.cacheReporter.restart(false);
            this.cacheReporter = null;
            this.commitEncoding = true;
            token = (Token)this.tokenQueue.get();
            if (token != null) break;
        }
        return token;
    }

    private Token createStartToken(Tag tag) throws ParseException {
        String string = tag.getElement().toUpperCase() + "_START";
        int n = TokenTypes.getType(string);
        if (n == -1) {
            this.addWarning("tagparser.warning.tag.unknownstart", new String[]{tag.getElement()}, tag);
            return null;
        }
        StartToken startToken = TokenManager.createStartToken(this.document, this.reporter, tag.getLineNumber(), tag.getColumnNumber(), n, false);
        if (startToken == null) {
            return null;
        }
        startToken.initAttribute(tag.getAttribute());
        if (TokenTypes.isEmpty(n) && !tag.isEmpty()) {
            this.reporter.report(3, Resource.getMessage("tagparser.warning.tag.notempty", new String[]{this.lastElementName}), tag.getLineNumber(), tag.getColumnNumber());
        }
        return startToken;
    }

    private Token createEndToken(Tag tag) throws ParseException {
        String string = tag.getElement().toUpperCase() + "_END";
        int n = TokenTypes.getType(string);
        if (n == -1) {
            string = tag.getElement().toUpperCase() + "_START";
            n = TokenTypes.getType(string);
            if (n != -1) {
                this.addWarning("tagparser.warning.tag.notend", new String[]{tag.getElement()}, tag);
                return null;
            }
            this.addWarning("tagparser.warning.tag.unknownend", new String[]{tag.getElement()}, tag);
            return null;
        }
        return TokenManager.createEndToken(this.document, this.reporter, tag.getLineNumber(), tag.getColumnNumber(), n, false);
    }

    private Token createTextToken(Tag tag) throws ParseException {
        return new TextToken(this.document, this.reporter, tag.getLineNumber(), tag.getColumnNumber(), tag.getText());
    }

    private Token createMiscToken(Tag tag) throws ParseException {
        int n = -1;
        switch (tag.getType()) {
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 0: {
                n = 0;
            }
        }
        return new MiscToken(this.document, this.reporter, tag.getLineNumber(), tag.getColumnNumber(), tag.getInnerText(), n);
    }

    private void checkCharSet(Token token, Tag tag) throws IOException {
        if (token.getType() != 2019) {
            return;
        }
        MetaAttribute metaAttribute = (MetaAttribute)((StartToken)token).getAttribute();
        if (metaAttribute == null) {
            return;
        }
        String string = metaAttribute.getHttpEquiv();
        if (string == null || string.toLowerCase().compareTo("content-type") != 0) {
            return;
        }
        String string2 = metaAttribute.getContent();
        if (string2 == null) {
            return;
        }
        String string3 = null;
        try {
            string3 = new ContentType(string2).getParameter("charset");
        }
        catch (java.text.ParseException parseException) {
            // empty catch block
        }
        if (string3 == null) {
            return;
        }
        this.resetEncoding(string3, tag);
    }

    private void resetEncoding(String string, Tag tag) throws IOException {
        if (string == null) {
            return;
        }
        String string2 = Charset.toEncoding(string);
        if (string2 == null) {
            this.addWarning("charset.warning.invalid", new String[]{string}, null);
            return;
        }
        try {
            this.bis.reset();
            this.tagReader = new TagReader(this.createBufferedReader(this.bis, string2), this.reporter);
        }
        catch (IOException iOException) {
            this.addWarning("charset.warning.reset", new String[]{string}, tag);
        }
        this.tokenQueue.clear();
        this.tokenQueue = null;
        this.cacheReporter.restart(true);
        this.cacheReporter = null;
        this.encoding = string2;
        this.commitEncoding = true;
        this.reporter.report(3, Resource.getMessage("charset.info.encoding", new String[]{string2}), tag.getLineNumber(), tag.getColumnNumber());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() {
        try {
            if (this.bis != null) {
                ((FilterInputStream)this.bis).close();
            }
        }
        catch (IOException iOException) {
            this.addWarning("tagparser.warning.stream.close", new String[]{iOException.toString()}, null);
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException iOException) {
            this.addWarning("tagparser.warning.stream.close", new String[]{iOException.toString()}, null);
        }
    }

    private void addWarning(String string, String[] stringArray, Tag tag) {
        this.reporter.report(7, Resource.getMessage(string, stringArray), tag != null ? tag.getLineNumber() : 0, tag != null ? tag.getColumnNumber() : 0);
    }
}

