/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.util.Hashtable;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.ParseException;
import net.hizlab.kagetaka.util.TextFormat;

public class Tag {
    public static final int TAG = 1;
    public static final int TEXT = 2;
    public static final int DTD = 3;
    public static final int COMMENT = 4;
    public static final int PI = 5;
    public static final int MISC = 0;
    private Reporter reporter = null;
    private int lineNumber = 0;
    private int columnNumber = 0;
    private int type = 0;
    private String rawData = null;
    private int dataStart = 0;
    private int dataEnd = 1;
    private String element = null;
    private boolean isEndTag = false;
    private boolean isEmpty = false;
    private Hashtable attributes = null;

    public Tag(Reporter reporter, int n, int n2, int n3, String string) throws ParseException {
        this.reporter = reporter;
        this.lineNumber = n;
        this.columnNumber = n2;
        this.type = n3;
        this.rawData = string;
        int n4 = 0;
        int n5 = string.length();
        if (n3 == 1) {
            if (string.compareTo("<>") == 0) {
                return;
            }
            if (string.compareTo("</>") == 0) {
                this.isEndTag = true;
                return;
            }
            ++n4;
            if (n5 > 1 && string.charAt(1) == '/') {
                ++n4;
                this.isEndTag = true;
            }
            if (string.charAt(n5 - 1) == '>') {
                --n5;
            } else {
                this.addWarning("tag.warning.bracket.notclose", n5);
            }
        } else if (n3 == 5 && this.startsWordWith(string, "<?xml", 2)) {
            n4 += 2;
            n5 -= 2;
        } else {
            this.dataEnd = string.length();
            switch (n3) {
                case 3: {
                    this.dataStart = 2;
                    --this.dataEnd;
                    break;
                }
                case 4: {
                    this.dataStart = 4;
                    this.dataEnd -= 3;
                    break;
                }
                case 5: {
                    this.dataStart = 2;
                    this.dataEnd -= 2;
                    break;
                }
                case 0: {
                    this.dataStart = 2;
                    this.dataEnd -= 2;
                }
            }
            return;
        }
        this.dataStart = n4;
        this.dataEnd = n5;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = n4;
        block6: while (n6 < n5) {
            block39: {
                while (string.charAt(n6) <= ' ') {
                    if (++n6 < n5) continue;
                    break block6;
                }
                n4 = n6;
                char c = string.charAt(n4);
                if (c == '\"' || c == '\'') {
                    if ((n6 = string.indexOf(c, ++n4)) == -1) {
                        n6 = n5;
                        if (c == '\"') {
                            this.addWarning("tag.warning.doublequotation.notclose", n6);
                        } else {
                            this.addWarning("tag.warning.apostrophe.notclose", n6);
                        }
                    } else {
                        bl3 = true;
                        bl = true;
                    }
                } else {
                    if (c == '=') {
                        if (string2 == null || bl2) {
                            this.addWarning("tag.warning.equals.invalidposition", n6);
                        } else {
                            bl2 = true;
                        }
                        ++n6;
                        continue;
                    }
                    while (++n6 < n5) {
                        c = string.charAt(n6);
                        if (c > ' ' && (bl2 || c != '=')) continue;
                        break block39;
                    }
                    if (n4 + 1 == n6 && string2 == null && string.charAt(n4) == '/') {
                        this.isEmpty = true;
                        break;
                    }
                }
            }
            String string3 = string.substring(n4, n6);
            if (bl) {
                int n7;
                StringBuffer stringBuffer = new StringBuffer();
                int n8 = 0;
                for (n7 = 0; n7 < string3.length(); ++n7) {
                    if (string3.charAt(n7) >= ' ') continue;
                    if (n8 < n7) {
                        stringBuffer.append(string3.substring(n8, n7));
                    }
                    n8 = n7 + 1;
                }
                if (n8 < n7) {
                    stringBuffer.append(string3.substring(n8, n7));
                }
                string3 = stringBuffer.toString();
                bl = false;
            }
            String string4 = TextFormat.convertXhtml(reporter, this.lineNumber, this.columnNumber, string3, true, true, false, true);
            if (this.element == null) {
                this.element = string4;
            } else if (string2 == null) {
                string2 = string4;
            } else {
                if (bl2) {
                    this.addAttribute(string2, string4);
                    string2 = null;
                } else {
                    this.addAttribute(string2, string2);
                    string2 = string4;
                }
                bl2 = false;
            }
            if (!bl3) continue;
            ++n6;
            bl3 = false;
        }
        if (string2 != null) {
            this.addAttribute(string2, string2);
        }
    }

    private boolean startsWordWith(String string, String string2, int n) {
        if (!string.startsWith(string2)) {
            return false;
        }
        int n2 = string2.length();
        if (string.length() <= n2 + n) {
            return true;
        }
        char c = string.charAt(string2.length());
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u200b': {
                return true;
            }
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        return this.rawData;
    }

    public String getInnerText() {
        return this.rawData.substring(this.dataStart, this.dataEnd);
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String string) {
        this.element = string;
    }

    public boolean isEndTag() {
        return this.isEndTag;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private void addAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, string2);
    }

    public Hashtable getAttribute() {
        return this.attributes;
    }

    public String toString() {
        return this.rawData;
    }

    private void addWarning(String string, int n) {
        if (this.reporter == null) {
            return;
        }
        int n2 = this.lineNumber;
        int n3 = this.columnNumber;
        int n4 = this.rawData.length();
        for (int i = 0; i < n; ++i) {
            char c = this.rawData.charAt(i);
            if (c == '\n') {
                ++n2;
                n3 = 1;
                continue;
            }
            if (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f') {
                ++n3;
                continue;
            }
            n3 += 2;
        }
        this.reporter.report(7, Resource.getMessage(string, null), n2, n3);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

