/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import net.hizlab.kagetaka.awt.ImageCreator;

public class FontData {
    private static final char[] SAMPLE_JP = new char[]{'\u8a9e', '\u99c5', '\u253c', '\u254b'};
    private static final char[] SAMPLE_EN = new char[]{'A', 'B', 'C', 'D', 'j', 'y', 'p', '_'};
    private static final char[] SAMPLE_X = new char[]{'x'};
    private static final Color backColor = Color.white;
    private static final Color foreColor = Color.black;
    private static Hashtable cache = new Hashtable();
    private Font font = null;
    private FontMetrics fm = null;
    private int baseFull = 0;
    private int baseHalf = 0;
    private Dimension sizeFull = null;
    private int heightMax = 0;
    private int heightHalf = 0;
    private int heightX = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontData getInstance(ImageCreator imageCreator, Font font) {
        String string = font.toString();
        Hashtable hashtable = cache;
        synchronized (hashtable) {
            if (cache.containsKey(string)) {
                return (FontData)cache.get(string);
            }
            FontData fontData = new FontData(imageCreator, font);
            cache.put(string, fontData);
            return fontData;
        }
    }

    private FontData(ImageCreator imageCreator, Font font) {
        this.font = font;
        this.fm = imageCreator.getToolkit().getFontMetrics(font);
        Dimension dimension = new Dimension(0, 0);
        this.sizeFull = new Dimension(0, 0);
        this.baseFull = this.calculate(imageCreator, SAMPLE_JP, true, this.sizeFull);
        this.baseHalf = this.calculate(imageCreator, SAMPLE_EN, false, dimension);
        this.heightHalf = dimension.height;
        this.calculate(imageCreator, SAMPLE_X, false, dimension);
        this.heightX = dimension.height;
        if (this.sizeFull.height > this.heightHalf) {
            this.baseHalf += this.sizeFull.height - this.heightHalf;
            this.heightHalf = this.sizeFull.height;
            this.heightMax = this.sizeFull.height;
        } else {
            this.heightMax = this.heightHalf;
        }
    }

    private int calculate(ImageCreator imageCreator, char[] cArray, boolean bl, Dimension dimension) {
        int n;
        int n2 = this.fm.getHeight();
        Image image = imageCreator.createImage(n2, n2);
        if (image == null) {
            throw new IllegalStateException("doesn't prepare for AWT");
        }
        Graphics graphics = image.getGraphics();
        graphics.setColor(backColor);
        graphics.fillRect(0, 0, n2, n2);
        graphics.setColor(foreColor);
        graphics.setFont(this.font);
        int n3 = this.fm.getDescent();
        int n4 = n2 - n3;
        for (int i = 0; i < cArray.length; ++i) {
            graphics.drawChars(cArray, i, 1, 0, n4);
        }
        graphics.dispose();
        int[] nArray = new int[n2 * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n2, n2, nArray, 0, n2);
        try {
            pixelGrabber.grabPixels(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n5 = foreColor.getRGB();
        int n6 = 0;
        int n7 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != n5) continue;
            n6 = n / n2;
            break;
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            if (nArray[n] != n5) continue;
            n7 = n2 - n / n2 - 1;
            break;
        }
        dimension.height = n2 - n6 - n7;
        if (bl) {
            n = n2;
            block5: for (int i = n2 - 1; i >= 0; --i) {
                for (int j = 0; j < n2; ++j) {
                    if (nArray[j * n2 + i] != n5) continue;
                    n = i + 1;
                    break block5;
                }
            }
            dimension.width = n;
        }
        return n2 - n3 - n6;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public Dimension getFullSize() {
        return new Dimension(this.sizeFull);
    }

    public int getMaxHeight() {
        return this.heightMax;
    }

    public int getHalfHeight() {
        return this.heightHalf;
    }

    public int getXHeight() {
        return this.heightX;
    }

    public int getFullBase() {
        return this.baseFull;
    }

    public int getHalfBase() {
        return this.baseHalf;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("font=");
        int n = this.font.getStyle();
        stringBuffer.append(this.font.getName());
        if ((n & 1) != 0 && (n & 2) != 0) {
            stringBuffer.append("-bolditalic-");
        } else if ((n & 1) != 0) {
            stringBuffer.append("-bold-");
        } else if ((n & 2) != 0) {
            stringBuffer.append("-italic-");
        } else {
            stringBuffer.append("-plain-");
        }
        stringBuffer.append(this.font.getSize());
        stringBuffer.append(",fullheight=");
        stringBuffer.append(this.sizeFull.height);
        stringBuffer.append(",fullwidth=");
        stringBuffer.append(this.sizeFull.width);
        stringBuffer.append(",maxheight=");
        stringBuffer.append(this.heightMax);
        stringBuffer.append(",halfheight=");
        stringBuffer.append(this.heightHalf);
        stringBuffer.append(",xheight=");
        stringBuffer.append(this.heightX);
        stringBuffer.append(",basefull=");
        stringBuffer.append(this.baseFull);
        stringBuffer.append(",basehalf=");
        stringBuffer.append(this.baseHalf);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

