/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import net.hizlab.kagetaka.awt.ColorConverter;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.Transparent;
import net.hizlab.kagetaka.token.Value;

public class Border {
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;
    public static final int ALL = 15;
    public Line top;
    public Line right;
    public Line bottom;
    public Line left;
    private FontData fd;
    private Insets widths = new Insets(0, 0, 0, 0);

    public void setBaseSize(FontData fontData) {
        this.fd = fontData;
        this.resize(15);
    }

    public Insets getWidths() {
        return (Insets)this.widths.clone();
    }

    public void setStyle(int n, Value value) {
        this.initialize(n);
        int n2 = value.getType();
        if ((n & 1) != 0) {
            this.top.style = n2;
        }
        if ((n & 2) != 0) {
            this.right.style = n2;
        }
        if ((n & 4) != 0) {
            this.bottom.style = n2;
        }
        if ((n & 8) != 0) {
            this.left.style = n2;
        }
        this.resize(n);
    }

    public void setWidth(int n, Value value) {
        this.initialize(n);
        if ((n & 1) != 0) {
            this.top.width = value;
        }
        if ((n & 2) != 0) {
            this.right.width = value;
        }
        if ((n & 4) != 0) {
            this.bottom.width = value;
        }
        if ((n & 8) != 0) {
            this.left.width = value;
        }
        this.resize(n);
    }

    public void setColor(int n, Color color) {
        this.initialize(n);
        if ((n & 1) != 0) {
            this.top.color = color;
        }
        if ((n & 2) != 0) {
            this.right.color = color;
        }
        if ((n & 4) != 0) {
            this.bottom.color = color;
        }
        if ((n & 8) != 0) {
            this.left.color = color;
        }
    }

    private void initialize(int n) {
        if ((n & 1) != 0 && this.top == null) {
            this.top = new Line();
        }
        if ((n & 2) != 0 && this.right == null) {
            this.right = new Line();
        }
        if ((n & 4) != 0 && this.bottom == null) {
            this.bottom = new Line();
        }
        if ((n & 8) != 0 && this.left == null) {
            this.left = new Line();
        }
    }

    private void resize(int n) {
        if (this.fd == null) {
            return;
        }
        if ((n & 1) != 0 && this.top != null && this.top.width != null) {
            int n2 = this.widths.top = this.top.style != 3 ? this.top.width.getValue(this.fd, 0, 2) : 0;
        }
        if ((n & 2) != 0 && this.right != null && this.right.width != null) {
            int n3 = this.widths.right = this.right.style != 3 ? this.right.width.getValue(this.fd, 0, 1) : 0;
        }
        if ((n & 4) != 0 && this.bottom != null && this.bottom.width != null) {
            int n4 = this.widths.bottom = this.bottom.style != 3 ? this.bottom.width.getValue(this.fd, 0, 2) : 0;
        }
        if ((n & 8) != 0 && this.left != null && this.left.width != null) {
            this.widths.left = this.left.style != 3 ? this.left.width.getValue(this.fd, 0, 1) : 0;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        if (this.top != null) {
            stringBuffer.append(this.top.toString());
        }
        stringBuffer.append(", ");
        if (this.right != null) {
            stringBuffer.append(this.right.toString());
        }
        stringBuffer.append(", ");
        if (this.bottom != null) {
            stringBuffer.append(this.bottom.toString());
        }
        stringBuffer.append(", ");
        if (this.left != null) {
            stringBuffer.append(this.left.toString());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        if (!(this.widths.top <= 0 || this.top.color != null && this.top.color instanceof Transparent)) {
            this.fillRectangle(graphics, n, n2, n3, n2, n3 - this.widths.right, n2 + this.widths.top, n + this.widths.left, n2 + this.widths.top, this.top.style, this.top.color != null ? this.top.color : color, 1);
        }
        if (!(this.widths.right <= 0 || this.right.color != null && this.right.color instanceof Transparent)) {
            this.fillRectangle(graphics, n3 - this.widths.right, n2 + this.widths.top, n3, n2, n3, n4, n3 - this.widths.right, n4 - this.widths.bottom, this.right.style, this.right.color != null ? this.right.color : color, 2);
        }
        if (!(this.widths.bottom <= 0 || this.bottom.color != null && this.bottom.color instanceof Transparent)) {
            this.fillRectangle(graphics, n + this.widths.left, n4 - this.widths.bottom, n3 - this.widths.right, n4 - this.widths.bottom, n3, n4, n, n4, this.bottom.style, this.bottom.color != null ? this.bottom.color : color, 4);
        }
        if (!(this.widths.left <= 0 || this.left.color != null && this.left.color instanceof Transparent)) {
            this.fillRectangle(graphics, n, n2, n + this.widths.left, n2 + this.widths.top, n + this.widths.left, n4 - this.widths.bottom, n, n4, this.left.style, this.left.color != null ? this.left.color : color, 8);
        }
    }

    private void fillRectangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, int n10) {
        switch (n9) {
            case 12: 
            case 13: {
                graphics.setColor(color);
                int n11 = 0;
                switch (n10) {
                    case 1: {
                        n11 = n8 - n2;
                        GraphicsUtils.drawDashed(graphics, n, n2, n3 - n, n11, n9 == 12 ? n11 : n11 * 3, n9 == 12 ? n11 : n11 * 2, 1);
                        break;
                    }
                    case 2: {
                        n11 = n3 - n;
                        GraphicsUtils.drawDashed(graphics, n, n4, n11, n6 - n4, n9 == 12 ? n11 : n11 * 3, n9 == 12 ? n11 : n11 * 2, 2);
                        break;
                    }
                    case 4: {
                        n11 = n8 - n2;
                        GraphicsUtils.drawDashed(graphics, n7, n2, n5 - n7, n11, n9 == 12 ? n11 : n11 * 3, n9 == 12 ? n11 : n11 * 2, 1);
                        break;
                    }
                    case 8: {
                        n11 = n3 - n;
                        GraphicsUtils.drawDashed(graphics, n, n2, n11, n8 - n2, n9 == 12 ? n11 : n11 * 3, n9 == 12 ? n11 : n11 * 2, 2);
                    }
                }
                break;
            }
            case 14: {
                graphics.setColor(color);
                this.fillRectanglePart(graphics, n, n2, n3, n4, n5, n6, n7, n8);
                break;
            }
            case 15: {
                graphics.setColor(color);
                int n12 = 0;
                n12 = n10 == 1 || n10 == 4 ? n8 - n2 : n3 - n;
                if (n12 < 3) {
                    this.fillRectanglePart(graphics, n, n2, n3, n4, n5, n6, n7, n8);
                    break;
                }
                int n13 = n12 / 3 + (n12 % 3 == 2 ? 1 : 0);
                double d = (double)n13 / (double)n12;
                switch (n10) {
                    case 1: {
                        this.fillRectanglePart(graphics, n, n2, n3, n4, (int)((double)n3 - (double)(n3 - n5) * d), n4 + n13, (int)((double)n + (double)(n7 - n) * d), n2 + n13);
                        this.fillRectanglePart(graphics, (int)((double)n7 - (double)(n7 - n) * d), n8 - n13, (int)((double)n5 + (double)(n3 - n5) * d), n6 - n13, n5, n6, n7, n8);
                        break;
                    }
                    case 2: {
                        this.fillRectanglePart(graphics, n, n2, n + n13, (int)((double)n2 - (double)(n2 - n4) * d), n7 + n13, (int)((double)n8 + (double)(n6 - n8) * d), n7, n8);
                        this.fillRectanglePart(graphics, n3 - n13, (int)((double)n4 + (double)(n2 - n4) * d), n3, n4, n5, n6, n5 - n13, (int)((double)n6 - (double)(n6 - n8) * d));
                        break;
                    }
                    case 4: {
                        this.fillRectanglePart(graphics, n, n2, n3, n4, (int)((double)n3 + (double)(n5 - n3) * d), n4 + n13, (int)((double)n - (double)(n - n7) * d), n2 + n13);
                        this.fillRectanglePart(graphics, (int)((double)n7 + (double)(n - n7) * d), n8 - n13, (int)((double)n5 - (double)(n5 - n3) * d), n6 - n13, n5, n6, n7, n8);
                        break;
                    }
                    case 8: {
                        this.fillRectanglePart(graphics, n, n2, n + n13, (int)((double)n2 + (double)(n4 - n2) * d), n7 + n13, (int)((double)n8 - (double)(n8 - n6) * d), n7, n8);
                        this.fillRectanglePart(graphics, n3 - n13, (int)((double)n4 - (double)(n4 - n2) * d), n3, n4, n5, n6, n5 - n13, (int)((double)n6 + (double)(n8 - n6) * d));
                    }
                }
                break;
            }
            case 16: 
            case 17: {
                int n14 = 0;
                n14 = n10 == 1 || n10 == 4 ? n8 - n2 : n3 - n;
                if (n14 < 2) {
                    graphics.setColor(color);
                    this.fillRectanglePart(graphics, n, n2, n3, n4, n5, n6, n7, n8);
                    break;
                }
                int n15 = n14 / 2;
                double d = (double)n15 / (double)n14;
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                if (n9 == 16) {
                    graphics.setColor(ColorConverter.getDarker(color));
                } else {
                    graphics.setColor(ColorConverter.getBrighter(color));
                }
                switch (n10) {
                    case 1: {
                        n16 = (int)((double)n3 - (double)(n3 - n5) * d);
                        n17 = n4 + n15;
                        n18 = (int)((double)n + (double)(n7 - n) * d);
                        n19 = n2 + n15;
                        this.fillRectanglePart(graphics, n, n2, n3, n4, n16, n17, n18, n19);
                        break;
                    }
                    case 2: {
                        n16 = n3 - n15;
                        n17 = (int)((double)n4 + (double)(n2 - n4) * d);
                        n18 = n5 - n15;
                        n19 = (int)((double)n6 - (double)(n6 - n8) * d);
                        this.fillRectanglePart(graphics, n, n2, n16, n17, n18, n19, n7, n8);
                        break;
                    }
                    case 4: {
                        n16 = (int)((double)n5 - (double)(n5 - n3) * d);
                        n17 = n6 - n15;
                        n18 = (int)((double)n7 + (double)(n - n7) * d);
                        n19 = n8 - n15;
                        this.fillRectanglePart(graphics, n, n2, n3, n4, n16, n17, n18, n19);
                        break;
                    }
                    case 8: {
                        n16 = n + n15;
                        n17 = (int)((double)n2 + (double)(n4 - n2) * d);
                        n18 = n7 + n15;
                        n19 = (int)((double)n8 - (double)(n8 - n6) * d);
                        this.fillRectanglePart(graphics, n, n2, n16, n17, n18, n19, n7, n8);
                    }
                }
                if (n9 == 16) {
                    graphics.setColor(ColorConverter.getBrighter(color));
                } else {
                    graphics.setColor(ColorConverter.getDarker(color));
                }
                switch (n10) {
                    case 1: {
                        this.fillRectanglePart(graphics, n18, n19, n16, n17, n5, n6, n7, n8);
                        break;
                    }
                    case 2: {
                        this.fillRectanglePart(graphics, n16, n17, n3, n4, n5, n6, n18, n19);
                        break;
                    }
                    case 4: {
                        this.fillRectanglePart(graphics, n18, n19, n16, n17, n5, n6, n7, n8);
                        break;
                    }
                    case 8: {
                        this.fillRectanglePart(graphics, n16, n17, n3, n4, n5, n6, n18, n19);
                    }
                }
                break;
            }
            case 18: {
                if (n10 == 1 || n10 == 8) {
                    graphics.setColor(ColorConverter.getDarker(color));
                } else {
                    graphics.setColor(ColorConverter.getBrighter(color));
                }
                this.fillRectanglePart(graphics, n, n2, n3, n4, n5, n6, n7, n8);
                break;
            }
            case 19: {
                if (n10 == 1 || n10 == 8) {
                    graphics.setColor(ColorConverter.getBrighter(color));
                } else {
                    graphics.setColor(ColorConverter.getDarker(color));
                }
                this.fillRectanglePart(graphics, n, n2, n3, n4, n5, n6, n7, n8);
            }
        }
    }

    private void fillRectanglePart(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n2 != n4 || n3 != n5 || n6 != n8 || n7 != n) {
            Polygon polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n3, n4);
            polygon.addPoint(n5, n6);
            polygon.addPoint(n7, n8);
            graphics.fillPolygon(polygon);
        } else {
            graphics.fillRect(n, n2, n5 - n, n6 - n2);
        }
    }

    public class Line {
        public int style = 14;
        public Value width;
        public Color color;

        private Line() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append('[');
            stringBuffer.append(this.style);
            if (this.width != null) {
                stringBuffer.append(' ');
                stringBuffer.append(this.width.toString());
            }
            if (this.color != null) {
                stringBuffer.append(' ');
                stringBuffer.append(this.color.toString());
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

