/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.applet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Scrollbar;
import net.hizlab.kagetaka.rendering.PanelScrollbar;

class BasicScrollbar
extends Scrollbar
implements PanelScrollbar {
    private boolean isHorizontal;
    private int fixOperator;
    private int value;
    private int maximum;
    private int visible;

    BasicScrollbar(int n) {
        super(n, 0, 1, 0, 1);
        this.setEnabled(false);
        this.isHorizontal = n == 0;
        this.setUnitIncrement(1);
        this.setBlockIncrement(1);
    }

    public Component getComponent() {
        return this;
    }

    public synchronized void setValue(int n) {
        if (this.value == n) {
            return;
        }
        super.setValue(n);
        this.value = n;
    }

    public synchronized void setMaximum(int n) {
        if (this.maximum == n) {
            return;
        }
        super.setMaximum(n);
        if (this.isHorizontal) {
            this.value += n - this.maximum;
            if (this.value < 0) {
                this.value = 0;
            }
            super.setValue(this.value);
        } else {
            this.value = this.getValue();
        }
        this.maximum = n;
        this.fixValue();
    }

    public synchronized void setVisibleAmount(int n) {
        if (n == this.visible) {
            return;
        }
        super.setVisibleAmount(n);
        if (this.isHorizontal) {
            this.value -= n - this.visible;
            if (this.value < 0) {
                this.value = 0;
            }
            super.setValue(this.value);
        }
        this.visible = n;
        this.fixValue();
    }

    private void fixValue() {
        boolean bl = this.isEnabled();
        if (bl != this.maximum > this.visible) {
            bl = !bl;
            this.setEnabled(bl);
        }
    }

    public Dimension getPreferredSize() {
        if (this.isHorizontal) {
            return new Dimension(0, 16);
        }
        return new Dimension(16, 0);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

