/*
 * Decompiled with CFR 0.152.
 */
package net.fclabs.util;

public class Queue {
    private static final int DEFAULT_BLOCK_NUM = 1;
    private static final int DEFAULT_BLOCK_SIZE = 8;
    private static final int BLOCK_BUFFER_NUM = 1;
    private int minBlockNum = 0;
    private int blockSize = 0;
    private Block firstBlock = null;
    private Block lastBlock = null;
    private int firstBlockIndex = 0;
    private int lastBlockIndex = 0;
    private int total = 0;
    private int usedBlockNum = 0;
    private int totalBlockNum = 0;

    public Queue() {
        this(8, 1);
    }

    public Queue(int n) {
        this(n, 1);
    }

    public Queue(int n, int n2) {
        this.blockSize = n > 0 ? n : 8;
        this.minBlockNum = n2 > 0 ? n2 : 1;
        this.init();
    }

    private synchronized void init() {
        this.firstBlock = null;
        this.lastBlock = null;
        this.firstBlockIndex = 0;
        this.lastBlockIndex = 0;
        this.total = 0;
        this.usedBlockNum = 0;
        this.totalBlockNum = 0;
        this.lastBlock = this.firstBlock = new Block(this.blockSize);
        ++this.totalBlockNum;
        for (int i = 1; i < this.minBlockNum; ++i) {
            this.lastBlock.next = new Block(this.blockSize);
            this.lastBlock.next.prev = this.lastBlock;
            this.lastBlock = this.lastBlock.next;
            ++this.totalBlockNum;
        }
        this.lastBlock.next = this.firstBlock;
        this.firstBlock.prev = this.lastBlock;
        this.lastBlock = this.firstBlock;
        this.usedBlockNum = 1;
        this.lastBlockIndex = -1;
    }

    public synchronized void put(Object object) {
        ++this.lastBlockIndex;
        if (this.lastBlockIndex == this.blockSize) {
            if (this.usedBlockNum == this.totalBlockNum) {
                Block block = new Block(this.blockSize);
                block.next = this.lastBlock.next;
                block.prev = this.lastBlock;
                block.next.prev = block;
                this.lastBlock.next = block;
                ++this.totalBlockNum;
            }
            this.lastBlockIndex = 0;
            this.lastBlock = this.lastBlock.next;
            ++this.usedBlockNum;
        }
        this.lastBlock.items[this.lastBlockIndex] = object;
        ++this.total;
        this.notify();
    }

    public synchronized Object get() {
        if (this.isEmpty()) {
            return null;
        }
        Object object = this.firstBlock.items[this.firstBlockIndex];
        ++this.firstBlockIndex;
        if (this.firstBlockIndex == this.blockSize) {
            if (this.totalBlockNum > this.minBlockNum && this.totalBlockNum - this.usedBlockNum >= 1) {
                this.firstBlock.prev.next = this.firstBlock.next;
                this.firstBlock.next.prev = this.firstBlock.prev;
                --this.totalBlockNum;
            }
            this.firstBlock = this.firstBlock.next;
            this.firstBlockIndex = 0;
            --this.usedBlockNum;
        }
        --this.total;
        return object;
    }

    public synchronized Object peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.firstBlock.items[this.firstBlockIndex];
    }

    public synchronized Object waitObject() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
        return this.get();
    }

    public synchronized boolean isEmpty() {
        return this.total == 0;
    }

    public synchronized int size() {
        return this.total;
    }

    public synchronized void clear() {
        this.init();
    }

    public synchronized String toString() {
        Block block = this.firstBlock;
        int n = this.firstBlockIndex;
        StringBuffer stringBuffer = new StringBuffer("Queue[");
        for (int i = 0; i < this.total; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(block.items[n++]);
            if (n != this.blockSize) continue;
            n = 0;
            block = block.next;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static class Block {
        Block next;
        Block prev;
        Object[] items;

        Block(int n) {
            this.items = new Object[n];
        }
    }
}

