/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.util;

import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.util.ContentHeaderParser;

public class ContentType {
    private String type = null;
    private String subtype = null;
    private Hashtable parameters = new Hashtable();

    public ContentType(String string) throws ParseException {
        ContentHeaderParser.Data data = ContentHeaderParser.parse(string);
        this.parseMedia(data.type);
        this.parameters = data.parameters;
    }

    public ContentType(String string, String string2) {
        this.type = string;
        this.subtype = string2;
    }

    private void parseMedia(String string) throws ParseException {
        int n = string.indexOf(47);
        if (n == -1) {
            throw new ParseException(Resource.getMessage("contenttype.error.media", new String[]{string}), 0);
        }
        this.type = string.substring(0, n).toLowerCase();
        this.subtype = string.substring(n + 1).toLowerCase();
        if (this.type.length() == 0 || this.subtype.length() == 0) {
            throw new ParseException(Resource.getMessage("contenttype.error.media", new String[]{string}), 0);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subtype;
    }

    public String getParameter(String string) {
        return (String)this.parameters.get(string.toLowerCase());
    }

    public Enumeration getParameterKeys() {
        return this.parameters.keys();
    }

    public String putParameter(String string, String string2) {
        return this.parameters.put(string, string2);
    }

    public void clearParameter() {
        this.parameters.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type);
        stringBuffer.append('/');
        stringBuffer.append(this.subtype);
        if (this.parameters.size() > 0) {
            boolean bl = false;
            StringBuffer stringBuffer2 = new StringBuffer();
            Enumeration enumeration = this.parameters.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.parameters.get(string);
                stringBuffer.append("; ");
                stringBuffer.append(string);
                stringBuffer.append('=');
                stringBuffer2.setLength(0);
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (bl) {
                        if (c == '\"' || c == '\\') {
                            stringBuffer2.append('\\');
                        }
                    } else {
                        switch (c) {
                            case '(': 
                            case ')': 
                            case ',': 
                            case '/': 
                            case ':': 
                            case ';': 
                            case '<': 
                            case '=': 
                            case '>': 
                            case '?': 
                            case '@': 
                            case '[': 
                            case ']': 
                            case '{': 
                            case '}': {
                                bl = true;
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                bl = true;
                                stringBuffer2.append('\\');
                                break;
                            }
                            default: {
                                if (c > ' ') break;
                                bl = true;
                            }
                        }
                    }
                    stringBuffer2.append(c);
                }
                if (bl) {
                    stringBuffer.append('\"');
                }
                stringBuffer.append(stringBuffer2.toString());
                if (!bl) continue;
                stringBuffer.append('\"');
            }
        }
        return stringBuffer.toString();
    }

    public static String normalize(String string, URL uRL) {
        if (string != null && string.compareTo("content/unknown") != 0) {
            return string;
        }
        String string2 = null;
        string2 = uRL.getFile();
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        if ((string2 = string2.substring(n + 1).toLowerCase()).compareTo("css") == 0) {
            return "text/css";
        }
        return null;
    }
}

