/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import java.awt.Color;
import java.text.DecimalFormat;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.util.Environment;

public class Value {
    private static final double CM_P_IN = 2.54;
    private static final double PT_P_IN = 72.0;
    private static final double PC_P_IN = 6.0;
    private static final double PT_P_PC = 12.0;
    public static final int DATA_HORIZONTAL = 1;
    public static final int DATA_VERTICAL = 2;
    public static final int DATA_NONE = 0;
    public static final int UNIT_NONE = 0;
    public static final int UNIT_EM = 1;
    public static final int UNIT_EX = 2;
    public static final int UNIT_PX = 3;
    public static final int UNIT_IN = 4;
    public static final int UNIT_CM = 5;
    public static final int UNIT_MM = 6;
    public static final int UNIT_PT = 7;
    public static final int UNIT_PC = 8;
    public static final int UNIT_PERCENT = 9;
    public static final int TYPE_INTEGER = -1;
    public static final int TYPE_LENGTH = -2;
    public static final int TYPE_PERCENTAGE = -3;
    public static final int TYPE_STRING = -4;
    public static final int TYPE_COLOR = -5;
    public static final int TYPE_URL = -6;
    public static final int TYPE_KEY_INHERIT = 1;
    public static final int TYPE_KEY_NORMAL = 2;
    public static final int TYPE_KEY_NONE = 3;
    public static final int TYPE_KEY_HIDDEN = 11;
    public static final int TYPE_KEY_DOTTED = 12;
    public static final int TYPE_KEY_DASHED = 13;
    public static final int TYPE_KEY_SOLID = 14;
    public static final int TYPE_KEY_DOUBLE = 15;
    public static final int TYPE_KEY_GROOVE = 16;
    public static final int TYPE_KEY_RIDGE = 17;
    public static final int TYPE_KEY_INSET = 18;
    public static final int TYPE_KEY_OUTSET = 19;
    public static final int TYPE_KEY_THIN = 21;
    public static final int TYPE_KEY_MEDIUM = 22;
    public static final int TYPE_KEY_THICK = 23;
    public static final int TYPE_KEY_LEFT = 31;
    public static final int TYPE_KEY_RIGHT = 32;
    public static final int TYPE_KEY_CENTER = 33;
    public static final int TYPE_KEY_JUSTIFY = 34;
    public static final int TYPE_KEY_BOTH = 35;
    public static final int TYPE_KEY_BASELINE = 41;
    public static final int TYPE_KEY_SUB = 42;
    public static final int TYPE_KEY_SUPER = 43;
    public static final int TYPE_KEY_TOP = 44;
    public static final int TYPE_KEY_TEXT_TOP = 45;
    public static final int TYPE_KEY_MIDDLE = 46;
    public static final int TYPE_KEY_BOTTOM = 47;
    public static final int TYPE_KEY_TEXT_BOTTOM = 48;
    public static final int TYPE_KEY_PRE = 51;
    public static final int TYPE_KEY_NOWRAP = 52;
    public static final int TYPE_KEY_XX_SMALL = 61;
    public static final int TYPE_KEY_X_SMALL = 62;
    public static final int TYPE_KEY_SMALL = 63;
    public static final int TYPE_KEY_LARGE = 65;
    public static final int TYPE_KEY_X_LARGE = 66;
    public static final int TYPE_KEY_XX_LARGE = 67;
    public static final int TYPE_KEY_SMALLER = 68;
    public static final int TYPE_KEY_LARGER = 69;
    public static final int TYPE_KEY_OBLIQUE = 71;
    public static final int TYPE_KEY_ITALIC = 72;
    public static final int TYPE_KEY_BOLD = 75;
    public static final int TYPE_KEY_BOLDER = 76;
    public static final int TYPE_KEY_LIGHTER = 77;
    public static final int TYPE_KEY_DISC = 81;
    public static final int TYPE_KEY_CIRCLE = 82;
    public static final int TYPE_KEY_SQUARE = 83;
    public static final int TYPE_KEY_DECIMAL = 84;
    public static final int TYPE_KEY_DECIMAL_LEADING_ZERO = 85;
    public static final int TYPE_KEY_LOWER_ROMAN = 86;
    public static final int TYPE_KEY_UPPER_ROMAN = 87;
    public static final int TYPE_KEY_HEBREW = 88;
    public static final int TYPE_KEY_GEORGIAN = 89;
    public static final int TYPE_KEY_ARMENIAN = 90;
    public static final int TYPE_KEY_CJK_IDEOGRAPHIC = 91;
    public static final int TYPE_KEY_HIRAGANA = 92;
    public static final int TYPE_KEY_KATAKANA = 93;
    public static final int TYPE_KEY_HIRAGANA_IROHA = 94;
    public static final int TYPE_KEY_KATAKANA_IROHA = 95;
    public static final int TYPE_KEY_LOWER_LATIN = 96;
    public static final int TYPE_KEY_UPPER_LATIN = 97;
    public static final int TYPE_KEY_LOWER_ALPHA = 98;
    public static final int TYPE_KEY_UPPER_ALPHA = 99;
    public static final int TYPE_KEY_LOWER_GREEK = 100;
    public static final int TYPE_KEY_INSIDE = 101;
    public static final int TYPE_KEY_OUTSIDE = 102;
    public static final int TYPE_KEY_UNDERLINE = 4096;
    public static final int TYPE_KEY_OVERLINE = 8192;
    public static final int TYPE_KEY_LINE_THROUGH = 16384;
    public static final int TYPE_KEY_BLINK = 32768;
    public static final int TYPE_KEY_TRANSPARENT = 901;
    public static final int INHERIT = 1;
    public static final int NONE = 3;
    public static final int BORDER_NONE = 3;
    public static final int BORDER_HIDDEN = 11;
    public static final int BORDER_DOTTED = 12;
    public static final int BORDER_DASHED = 13;
    public static final int BORDER_SOLID = 14;
    public static final int BORDER_DOUBLE = 15;
    public static final int BORDER_GROOVE = 16;
    public static final int BORDER_RIDGE = 17;
    public static final int BORDER_INSET = 18;
    public static final int BORDER_OUTSET = 19;
    public static final int TD_UNDERLINE = 4096;
    public static final int TD_OVERLINE = 8192;
    public static final int TD_STRIKE = 16384;
    public static final int TD_BLINK = 32768;
    public static final int ALIGN_LEFT = 31;
    public static final int ALIGN_CENTER = 33;
    public static final int ALIGN_RIGHT = 32;
    public static final int ALIGN_JUSTIFY = 34;
    public static final int VALIGN_BASELINE = 41;
    public static final int VALIGN_SUB = 42;
    public static final int VALIGN_SUPER = 43;
    public static final int VALIGN_TOP = 44;
    public static final int VALIGN_TEXT_TOP = 45;
    public static final int VALIGN_MIDDLE = 46;
    public static final int VALIGN_BOTTOM = 47;
    public static final int VALIGN_TEXT_BOTTOM = 48;
    public static final int WHITESPACE_NORMAL = 3;
    public static final int WHITESPACE_PRE = 51;
    public static final int WHITESPACE_NOWRAP = 52;
    public static final int FLOAT_NONE = 3;
    public static final int FLOAT_LEFT = 31;
    public static final int FLOAT_RIGHT = 32;
    public static final int CLEAR_NONE = 3;
    public static final int CLEAR_LEFT = 31;
    public static final int CLEAR_RIGHT = 32;
    public static final int CLEAR_BOTH = 35;
    public static final int LIST_NONE = 3;
    public static final int LIST_CUSTOM = 911;
    public static final int LIST_MIX = 912;
    public static final int LIST_DISC = 81;
    public static final int LIST_CIRCLE = 82;
    public static final int LIST_SQUARE = 83;
    public static final int LIST_DECIMAL = 84;
    public static final int LIST_DECIMAL_LEADING_ZERO = 85;
    public static final int LIST_LOWER_ROMAN = 86;
    public static final int LIST_UPPER_ROMAN = 87;
    public static final int LIST_HEBREW = 88;
    public static final int LIST_GEORGIAN = 89;
    public static final int LIST_ARMENIAN = 90;
    public static final int LIST_CJK_IDEOGRAPHIC = 91;
    public static final int LIST_HIRAGANA = 92;
    public static final int LIST_KATAKANA = 93;
    public static final int LIST_HIRAGANA_IROHA = 94;
    public static final int LIST_KATAKANA_IROHA = 95;
    public static final int LIST_LOWER_LATIN = 96;
    public static final int LIST_UPPER_LATIN = 97;
    public static final int LIST_LOWER_ALPHA = 98;
    public static final int LIST_UPPER_ALPHA = 99;
    public static final int LIST_LOWER_GREEK = 100;
    protected int type = 0;
    protected boolean important = false;
    protected Number number = null;
    protected String string = null;
    protected Color color = null;
    protected String url = null;
    protected int unit = 0;

    protected Value() {
    }

    public Value(int n) {
        this.type = n;
    }

    public Value(int n, String string) {
        this.type = n;
        this.string = string;
    }

    public Value(Number number, int n) {
        if (!(number instanceof Long) && !(number instanceof Double)) {
            throw new IllegalArgumentException("invalid value type");
        }
        switch (n) {
            case 0: {
                this.type = -1;
                break;
            }
            case 9: {
                this.type = -3;
                break;
            }
            default: {
                this.type = -2;
            }
        }
        this.number = number;
        this.unit = n;
    }

    public Value(long l, int n) {
        switch (n) {
            case 0: {
                this.type = -1;
                break;
            }
            case 9: {
                this.type = -3;
                break;
            }
            default: {
                this.type = -2;
            }
        }
        this.number = new Long(l);
        this.unit = n;
    }

    public Value(double d, int n) {
        switch (n) {
            case 0: {
                this.type = -1;
                break;
            }
            case 9: {
                this.type = -3;
                break;
            }
            default: {
                this.type = -2;
            }
        }
        this.number = new Double(d);
        this.unit = n;
    }

    public Value(String string) {
        this.type = -4;
        this.string = string;
    }

    public Value(Color color) {
        this.type = -5;
        this.color = color;
    }

    public Value(String string, int n) {
        this.type = -6;
        this.url = string;
    }

    public boolean isKeyword() {
        return this.type > 0;
    }

    public int getType() {
        return this.type;
    }

    public Number getNumber() {
        return this.number;
    }

    public int intValue() {
        if (this.number == null) {
            return 0;
        }
        return this.number.intValue();
    }

    public String getString() {
        return this.string;
    }

    public Color getColor() {
        return this.color;
    }

    public String getURL() {
        return this.url;
    }

    public int getUnit() {
        return this.unit;
    }

    public boolean getImportant() {
        return this.important;
    }

    public int getValue(FontData fontData, int n, int n2) {
        if (this.number == null) {
            return 0;
        }
        int n3 = Environment.screenResolution;
        switch (this.unit) {
            case 0: {
                return this.number.intValue();
            }
            case 1: {
                return (int)Math.round(this.number.doubleValue() * (double)(n2 == 1 ? fontData.getFullSize().width : fontData.getFullSize().height));
            }
            case 2: {
                return (int)Math.round(this.number.doubleValue() * (double)fontData.getXHeight());
            }
            case 3: {
                return this.number.intValue();
            }
            case 4: {
                return (int)Math.round(this.number.doubleValue() * (double)n3);
            }
            case 5: {
                return (int)Math.round(this.number.doubleValue() * (double)n3 / 2.54);
            }
            case 6: {
                return (int)Math.round(this.number.doubleValue() * (double)n3 / 2.54 / 10.0);
            }
            case 7: {
                return (int)Math.round(this.number.doubleValue() * (double)n3 / 72.0);
            }
            case 8: {
                return (int)Math.round(this.number.doubleValue() * (double)n3 / 6.0);
            }
            case 9: {
                return (int)Math.round(this.number.doubleValue() * (double)n / 100.0);
            }
        }
        return 0;
    }

    public int getBorderWidth(FontData fontData, int n, int n2) {
        switch (this.type) {
            case 21: {
                return 1;
            }
            case 22: {
                return 2;
            }
            case 23: {
                return 3;
            }
        }
        return this.getValue(fontData, n, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case -3: 
            case -2: 
            case -1: {
                DecimalFormat decimalFormat = new DecimalFormat("0.#");
                if (this.number instanceof Long) {
                    stringBuffer.append(decimalFormat.format(this.number.longValue()));
                } else {
                    stringBuffer.append(decimalFormat.format(this.number.doubleValue()));
                }
                switch (this.unit) {
                    case 1: {
                        stringBuffer.append("em");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("ex");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("px");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("in");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("cm");
                        break;
                    }
                    case 6: {
                        stringBuffer.append("mm");
                        break;
                    }
                    case 7: {
                        stringBuffer.append("pt");
                        break;
                    }
                    case 8: {
                        stringBuffer.append("pc");
                        break;
                    }
                    case 9: {
                        stringBuffer.append("%");
                    }
                }
                break;
            }
            case -4: {
                stringBuffer.append(this.string);
                break;
            }
            case -5: {
                stringBuffer.append(this.color.toString());
                break;
            }
            case -6: {
                stringBuffer.append(this.url);
                break;
            }
            default: {
                if (this.string == null) {
                    this.string = String.valueOf(this.type);
                }
                stringBuffer.append(this.string);
            }
        }
        if (this.important) {
            stringBuffer.append(" !important");
        }
        return stringBuffer.toString();
    }
}

