/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.AAttribute;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.BaseAttribute;
import net.hizlab.kagetaka.token.BodyAttribute;
import net.hizlab.kagetaka.token.DivAttribute;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.FontAttribute;
import net.hizlab.kagetaka.token.FrameAttribute;
import net.hizlab.kagetaka.token.HAttribute;
import net.hizlab.kagetaka.token.HrAttribute;
import net.hizlab.kagetaka.token.ImgAttribute;
import net.hizlab.kagetaka.token.LAttribute;
import net.hizlab.kagetaka.token.LinkAttribute;
import net.hizlab.kagetaka.token.MetaAttribute;
import net.hizlab.kagetaka.token.PAttribute;
import net.hizlab.kagetaka.token.Style;
import net.hizlab.kagetaka.token.StyleManager;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.TextFormat;

public class StartToken
extends Token {
    protected Vector contents = new Vector();
    protected final int type;
    protected Attribute attribute = null;
    protected String content = null;
    private boolean htmlHasHead = false;
    private boolean htmlHasBody = false;

    public StartToken(Document document, Reporter reporter, int n, int n2, int n3, boolean bl) {
        super(document, reporter, n, n2);
        this.type = n3;
        this.completeToken = bl;
    }

    public final void initAttribute(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                String string3 = string.toLowerCase();
                try {
                    if (this.setAttributeImple(string3, string2)) continue;
                    this.reportMessage(7, "element._.error.attribute.unknown", new String[]{this.getName(), string});
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.reportMessage(7, "element._.error.attribute.invalid", new String[]{this.getName(), string, string2});
                }
            }
        }
    }

    protected boolean setAttributeImple(String string, String string2) throws IllegalArgumentException {
        if (this.attribute == null) {
            switch (this.type) {
                case 2013: {
                    this.attribute = new BaseAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 2015: {
                    return true;
                }
                case 2019: {
                    this.attribute = new MetaAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 2021: {
                    this.attribute = new LinkAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3001: {
                    this.attribute = new BodyAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3101: {
                    this.attribute = new PAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3103: 
                case 3105: 
                case 3107: 
                case 3109: 
                case 3111: 
                case 3113: {
                    this.attribute = new HAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3115: {
                    this.attribute = new LAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber, 0);
                    break;
                }
                case 3117: {
                    this.attribute = new LAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber, 1);
                    break;
                }
                case 3119: {
                    this.attribute = new LAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber, 2);
                    break;
                }
                case 3121: {
                    this.attribute = new LAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber, 3);
                    break;
                }
                case 3133: {
                    this.attribute = new DivAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3139: {
                    this.attribute = new HrAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 2043: {
                    this.attribute = new FrameAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3201: {
                    this.attribute = new AAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3203: {
                    this.attribute = new ImgAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3277: {
                    this.attribute = new FontAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                default: {
                    if (TokenTypes.isBody(this.type)) {
                        this.attribute = new Attribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                        break;
                    }
                    return false;
                }
            }
        }
        return this.attribute.setAttribute(string, string2);
    }

    public String getName() {
        return TokenTypes.getName(this.type);
    }

    public int getType() {
        return this.type;
    }

    public final StartToken getDefaultParentToken() {
        StartToken startToken = this.getDefaultParentTokenImple();
        if (startToken != null) {
            return startToken;
        }
        if (this.type == 1001) {
            return null;
        }
        this.reportMessage(10, "internal.error", new String[]{"StartToken.getDefaultParentToken", "undefine token type", this.getName()});
        return null;
    }

    protected StartToken getDefaultParentTokenImple() {
        int n = -1;
        switch (this.type) {
            case 1001: {
                return null;
            }
            case 2001: {
                n = 1001;
                break;
            }
            case 2011: {
                n = 2001;
                break;
            }
            case 2013: {
                n = 2001;
                break;
            }
            case 2015: {
                n = 2001;
                break;
            }
            case 2019: {
                n = 2001;
                break;
            }
            case 2021: {
                n = 2001;
                break;
            }
            case 2041: {
                n = 1001;
                break;
            }
            case 2043: {
                n = 2041;
                break;
            }
            case 2045: {
                n = 1001;
                break;
            }
            case 3001: {
                n = 1001;
                break;
            }
            case 3101: {
                n = 3001;
                break;
            }
            case 3103: {
                n = 3001;
                break;
            }
            case 3105: {
                n = 3001;
                break;
            }
            case 3107: {
                n = 3001;
                break;
            }
            case 3109: {
                n = 3001;
                break;
            }
            case 3111: {
                n = 3001;
                break;
            }
            case 3113: {
                n = 3001;
                break;
            }
            case 3115: {
                n = 3001;
                break;
            }
            case 3117: {
                n = 3001;
                break;
            }
            case 3119: {
                n = 3001;
                break;
            }
            case 3121: {
                n = 3001;
                break;
            }
            case 3123: {
                n = 3191;
                break;
            }
            case 3125: {
                n = 3001;
                break;
            }
            case 3127: {
                n = 3191;
                break;
            }
            case 3129: {
                n = 3191;
                break;
            }
            case 3131: {
                n = 3001;
                break;
            }
            case 3133: {
                n = 3001;
                break;
            }
            case 3291: {
                n = 3001;
                break;
            }
            case 3137: {
                n = 3001;
                break;
            }
            case 3139: {
                n = 3001;
                break;
            }
            case 3141: {
                n = 3001;
                break;
            }
            case 3143: {
                n = 3001;
                break;
            }
            case 3191: {
                n = 3001;
                break;
            }
            case 3201: {
                n = 3191;
                break;
            }
            case 3203: {
                n = 3191;
                break;
            }
            case 3205: {
                n = 3191;
                break;
            }
            case 3207: {
                n = 3191;
                break;
            }
            case 3221: {
                n = 3191;
                break;
            }
            case 3223: {
                n = 3191;
                break;
            }
            case 3225: {
                n = 3191;
                break;
            }
            case 3227: {
                n = 3191;
                break;
            }
            case 3229: {
                n = 3191;
                break;
            }
            case 3231: {
                n = 3191;
                break;
            }
            case 3233: {
                n = 3191;
                break;
            }
            case 3235: {
                n = 3191;
                break;
            }
            case 3237: {
                n = 3191;
                break;
            }
            case 3239: {
                n = 3191;
                break;
            }
            case 3241: {
                n = 3191;
                break;
            }
            case 3243: {
                n = 3191;
                break;
            }
            case 3245: {
                n = 3191;
                break;
            }
            case 3261: {
                n = 3191;
                break;
            }
            case 3263: {
                n = 3191;
                break;
            }
            case 3265: {
                n = 3191;
                break;
            }
            case 3267: {
                n = 3191;
                break;
            }
            case 3269: {
                n = 3191;
                break;
            }
            case 3271: {
                n = 3191;
                break;
            }
            case 3273: {
                n = 3191;
                break;
            }
            case 3275: {
                n = 3191;
                break;
            }
            case 3277: {
                n = 3191;
                break;
            }
            default: {
                return null;
            }
        }
        return new StartToken(this.document, this.reporter, this.lineNumber, this.columnNumber, n, true);
    }

    public EndToken getEndToken(Token token) {
        if (TokenTypes.isEmpty(this.type)) {
            return null;
        }
        if (token == null) {
            return new EndToken(this.document, this.reporter, this.lineNumber, this.columnNumber, this.getType() + 1, true);
        }
        return new EndToken(this.document, this.reporter, token.lineNumber, token.columnNumber, this.getType() + 1, true);
    }

    public int getEndTokenType() {
        if (TokenTypes.isEmpty(this.type)) {
            return -1;
        }
        return this.getType() + 1;
    }

    public final boolean isContents(StartToken startToken) {
        int n = startToken.getType();
        switch (n) {
            case 2015: 
            case 2019: {
                return true;
            }
        }
        if (TokenTypes.isForm(n) && n != 3507 && n != 3509) {
            return true;
        }
        return this.isContentsImple(n);
    }

    protected boolean isContentsImple(int n) {
        switch (this.type) {
            case 1001: {
                switch (n) {
                    case 2001: {
                        if (this.htmlHasHead) {
                            return false;
                        }
                        this.htmlHasHead = true;
                        return true;
                    }
                    case 3001: {
                        if (this.htmlHasBody) {
                            return false;
                        }
                        this.htmlHasHead = true;
                        this.htmlHasBody = true;
                        return true;
                    }
                    case 2041: {
                        return true;
                    }
                    case 2045: {
                        return true;
                    }
                }
                return false;
            }
            case 2001: {
                switch (n) {
                    case 2011: 
                    case 2013: 
                    case 2015: 
                    case 2017: 
                    case 2019: 
                    case 2021: {
                        return true;
                    }
                }
                return false;
            }
            case 2011: 
            case 2013: {
                return false;
            }
            case 2015: {
                return true;
            }
            case 2019: 
            case 2021: {
                return false;
            }
            case 2041: {
                return n == 2041 || n == 2043;
            }
            case 2043: {
                return false;
            }
            case 2045: {
                return true;
            }
            case 3001: {
                switch (n) {
                    case 3123: 
                    case 3127: 
                    case 3129: {
                        return false;
                    }
                }
                return TokenTypes.isBlock(n);
            }
            case 3101: 
            case 3103: 
            case 3105: 
            case 3107: 
            case 3109: 
            case 3111: 
            case 3113: 
            case 3131: 
            case 3141: {
                return TokenTypes.isInline(n);
            }
            case 3115: 
            case 3117: 
            case 3119: 
            case 3121: {
                return n == 3123;
            }
            case 3123: {
                return TokenTypes.isBlock(n) && n != 3123 || TokenTypes.isInline(n);
            }
            case 3125: {
                return n == 3127 || n == 3129;
            }
            case 3127: {
                return TokenTypes.isInline(n);
            }
            case 3129: {
                return TokenTypes.isBlock(n) && n != 3127 && n != 3129 || TokenTypes.isInline(n);
            }
            case 3133: 
            case 3137: 
            case 3143: 
            case 3291: {
                return TokenTypes.isBlock(n) || TokenTypes.isInline(n);
            }
            case 3139: {
                return false;
            }
            case 3191: {
                return TokenTypes.isInline(n) || n == 3123 || n == 3127 || n == 3129;
            }
            case 3201: {
                return TokenTypes.isInline(n) && n != 3201;
            }
            case 3207: 
            case 3221: 
            case 3223: 
            case 3225: 
            case 3227: 
            case 3229: 
            case 3231: 
            case 3233: 
            case 3235: 
            case 3237: 
            case 3239: 
            case 3241: 
            case 3243: 
            case 3245: 
            case 3261: 
            case 3263: 
            case 3265: 
            case 3267: 
            case 3269: 
            case 3271: 
            case 3273: 
            case 3275: 
            case 3277: {
                return TokenTypes.isInline(n);
            }
            case 3203: 
            case 3205: {
                return false;
            }
        }
        this.reportMessage(10, "internal.error", new String[]{"StartToken.isContents", "undefine token type", this.getName()});
        return false;
    }

    protected final boolean isContentsParent(int n) {
        StartToken startToken = this.getParent();
        if (startToken != null) {
            return startToken.isContentsImple(n);
        }
        return false;
    }

    public final void includeToken(Token token) {
        this.contents.addElement(token);
        token.setParent(this);
        this.includeTokenImple(token);
    }

    protected void includeTokenImple(Token token) {
    }

    protected final void includeTokenParent(Token token) {
        StartToken startToken = this.getParent();
        if (startToken != null) {
            startToken.includeTokenImple(token);
        }
    }

    public StartToken getBeforeStartToken() {
        StartToken startToken = this.getParent();
        if (startToken == null) {
            return null;
        }
        int n = startToken.contents.indexOf(this);
        if (n <= 0) {
            return null;
        }
        while (--n >= 0) {
            Object e = startToken.contents.elementAt(n);
            if (!(e instanceof StartToken)) continue;
            return (StartToken)e;
        }
        return null;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getName());
        if (TokenTypes.isEmpty(this.type)) {
            stringBuffer.append(" /");
        }
        stringBuffer.append(':');
        stringBuffer.append(this.lineNumber);
        stringBuffer.append(':');
        stringBuffer.append(this.columnNumber);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public final void render(Render render) {
        Style style;
        Object object;
        Status status = render.getStatus();
        this.renderImple(render);
        if (this.attribute != null && (object = this.attribute.getBaseId()) != null) {
            render.setMark((String)object);
        }
        if ((object = render.getStyleManager(false)) != null) {
            ((StyleManager)object).changeStatus(this.document, this, status);
        }
        if (this.attribute != null && (style = this.attribute.getStyle()) != null) {
            style.changeStatus(this.document, TokenTypes.isBlockEx(this.type), status);
        }
    }

    protected void renderImple(Render render) {
        Status status = render.getStatus();
        switch (this.type) {
            case 1001: {
                break;
            }
            case 2001: {
                break;
            }
            case 2011: {
                render.setTitle(TextFormat.convertXhtml(this.content, true, true, true, true));
                break;
            }
            case 2013: {
                if (this.attribute == null) break;
                render.setBaseHref(((BaseAttribute)this.attribute).getHref());
                break;
            }
            case 2015: {
                break;
            }
            case 2019: {
                if (this.attribute == null) break;
                MetaAttribute metaAttribute = (MetaAttribute)this.attribute;
                String string = metaAttribute.getHttpEquiv();
                String string2 = metaAttribute.getContent();
                if (string == null || string2 == null) break;
                if ((string = string.trim().toLowerCase()).compareTo("refresh") == 0) {
                    int n = string2.indexOf(59);
                    String string3 = string2;
                    String string4 = null;
                    if (n != -1) {
                        string3 = string2.substring(0, n);
                        string4 = string2.substring(n + 1).trim();
                        if (string4.toLowerCase().startsWith("url=")) {
                            string4 = string4.substring(4).trim();
                        }
                    }
                    render.setRefresh(Integer.parseInt("0" + string3), string4);
                    break;
                }
                if (string.compareTo("set-cookie") != 0) break;
                render.setCookie(string2);
                break;
            }
            case 2021: {
                LinkAttribute linkAttribute;
                String string;
                if (this.attribute == null || (string = (linkAttribute = (LinkAttribute)this.attribute).getRel()) == null || string.toLowerCase().compareTo("stylesheet") != 0) break;
                render.setStyleSheet(linkAttribute.getHref(), linkAttribute.getType());
                break;
            }
            case 2041: {
                status.setList(912);
                status.setMargin(1, new Value(10L, 3));
                status.setMargin(10, new Value(5L, 3));
                break;
            }
            case 2043: {
                FrameAttribute frameAttribute;
                String string;
                if (this.attribute == null || (string = (frameAttribute = (FrameAttribute)this.attribute).getSrc()) == null) break;
                render.setListItem();
                render.setLink(string);
                status.setTextDecoration(4096);
                render.drawText(string);
                render.doBr();
                break;
            }
            case 2045: {
                break;
            }
            case 3001: {
                if (this.attribute != null) {
                    BodyAttribute bodyAttribute = (BodyAttribute)this.attribute;
                    status.setBackImage(bodyAttribute.getBackground());
                    if (bodyAttribute.getText() != null) {
                        status.foreColor = bodyAttribute.getText();
                    }
                    if (bodyAttribute.getBgcolor() != null) {
                        status.backColor = bodyAttribute.getBgcolor();
                    }
                    if (bodyAttribute.getLink() != null) {
                        status.linkColor = bodyAttribute.getLink();
                    }
                    if (bodyAttribute.getVLink() != null) {
                        status.vlinkColor = bodyAttribute.getVLink();
                    }
                    if (bodyAttribute.getALink() != null) {
                        status.alinkColor = bodyAttribute.getALink();
                    }
                }
                status.setMargin(15, new Value(5L, 3));
                status.lineHeight = new Value(1.2, 1);
                break;
            }
            case 3101: {
                if (this.attribute != null) {
                    status.align = ((PAttribute)this.attribute).getAlign();
                }
                status.setMargin(10, new Value(1L, 1));
                status.whiteSpace = 3;
                break;
            }
            case 3103: 
            case 3105: 
            case 3107: 
            case 3109: 
            case 3111: 
            case 3113: {
                switch (this.type) {
                    case 3103: {
                        status.setFontWeight(new Value(75));
                        status.setFontSize(new Value(207L, 9), 1);
                        break;
                    }
                    case 3105: {
                        status.setFontWeight(new Value(75));
                        status.setFontSize(new Value(173L, 9), 1);
                        break;
                    }
                    case 3107: {
                        status.setFontWeight(new Value(75));
                        status.setFontSize(new Value(144L, 9), 1);
                        break;
                    }
                    case 3109: {
                        status.setFontWeight(new Value(75));
                        status.setFontSize(new Value(120L, 9), 1);
                        break;
                    }
                    case 3111: {
                        status.setFontWeight(new Value(75));
                        break;
                    }
                    case 3113: {
                        status.setFontStyle(new Value(72));
                    }
                }
                if (this.attribute != null) {
                    status.align = ((HAttribute)this.attribute).getAlign();
                }
                status.setMargin(10, new Value(0.5, 1));
                break;
            }
            case 3115: 
            case 3117: 
            case 3119: 
            case 3121: {
                LAttribute lAttribute = (LAttribute)this.attribute;
                status.setList(lAttribute != null ? lAttribute.getType() : (this.type == 3117 ? 84 : 912));
                if (lAttribute != null && lAttribute.getStart() != null) {
                    status.counterNo = lAttribute.getStart();
                }
                status.setMargin(1, new Value(40L, 3));
                break;
            }
            case 3123: {
                if (!this.completeToken) {
                    render.setListItem();
                }
                status.setMargin(10, new Value(2L, 3));
                break;
            }
            case 3125: {
                break;
            }
            case 3127: {
                status.setFontWeight(new Value(75));
                status.setMargin(10, new Value(2L, 3));
                break;
            }
            case 3129: {
                status.setMargin(1, new Value(40L, 3));
                status.setMargin(10, new Value(2L, 3));
                break;
            }
            case 3131: {
                status.setMargin(10, new Value(1L, 1));
                status.whiteSpace = 51;
                status.setFixedFont();
                break;
            }
            case 3133: {
                if (this.attribute == null) break;
                status.align = ((DivAttribute)this.attribute).getAlign();
                break;
            }
            case 3291: {
                break;
            }
            case 3137: {
                status.setMargin(1, new Value(20L, 3));
                status.setMargin(10, new Value(5L, 3));
                break;
            }
            case 3139: {
                int n = 3;
                boolean bl = true;
                if (status.align == 3) {
                    status.align = 33;
                }
                status.hrHeight = new Value(100L, 9);
                if (this.attribute != null) {
                    HrAttribute hrAttribute = (HrAttribute)this.attribute;
                    n = Math.max(hrAttribute.getSize() != null ? hrAttribute.getSize() : n, 2);
                    boolean bl2 = bl = !hrAttribute.getNoshade();
                    if (hrAttribute.getAlign() != 1) {
                        status.align = hrAttribute.getAlign();
                    }
                    if (hrAttribute.getWidth() != null) {
                        status.hrHeight = hrAttribute.getWidth();
                    }
                }
                int n2 = status.foreColor.getRed();
                int n3 = status.foreColor.getGreen();
                int n4 = status.foreColor.getBlue();
                n2 = n2 < 128 ? (n2 += 128) : (n2 -= 128);
                n3 = n3 < 128 ? (n3 += 128) : (n3 -= 128);
                n4 = n4 < 128 ? (n4 += 128) : (n4 -= 128);
                status.isHorizontalRule = true;
                status.width = new Value((long)(n - 2), 3);
                status.height = new Value(100L, 9);
                if (bl) {
                    status.setBorderStyle(15, new Value(18));
                }
                status.setBorderWidth(15, new Value(1L, 3));
                status.setBorderColor(15, new Color(n2, n3, n4));
                status.setMargin(10, new Value(0.7, 1));
                break;
            }
            case 3141: {
                break;
            }
            case 3143: {
                status.align = 33;
                break;
            }
            case 3191: {
                break;
            }
            case 3201: {
                if (this.attribute == null) break;
                AAttribute aAttribute = (AAttribute)this.attribute;
                render.setLink(aAttribute.getHref());
                render.setMark(aAttribute.getName());
                if (aAttribute.getHref() == null) break;
                status.setTextDecoration(4096);
                break;
            }
            case 3203: {
                if (this.attribute == null) break;
                ImgAttribute imgAttribute = (ImgAttribute)this.attribute;
                int n = 3;
                switch (imgAttribute.getAlign()) {
                    case 31: {
                        n = 31;
                        break;
                    }
                    case 32: {
                        n = 32;
                    }
                }
                render.drawImage(imgAttribute.getSrc(), imgAttribute.getAlt(), imgAttribute.getWidth(), imgAttribute.getHeight(), imgAttribute.getBorder(), n);
                break;
            }
            case 3205: {
                render.doBr();
                break;
            }
            case 3207: {
                break;
            }
            case 3221: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3223: {
                status.setFontWeight(new Value(75));
                break;
            }
            case 3225: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3227: {
                status.setFixedFont();
                break;
            }
            case 3229: {
                render.drawText("\"");
                break;
            }
            case 3231: {
                status.setFontSize(new Value(70L, 9), 1);
                status.offsetX = -((int)((double)status.getFontData().getFullSize().width * 0.5));
                break;
            }
            case 3233: {
                status.setFontSize(new Value(70L, 9), 1);
                status.offsetX = (int)((double)status.getFontData().getFullSize().width * 0.5);
                break;
            }
            case 3235: {
                status.setFixedFont();
                break;
            }
            case 3237: {
                break;
            }
            case 3239: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3241: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3243: 
            case 3245: {
                if (this.attribute == null || this.attribute.getBaseTitle() == null) break;
                render.setPopup(this.attribute.getBaseTitle());
                status.setTextDecoration(4096);
                break;
            }
            case 3261: {
                status.setFixedFont();
                break;
            }
            case 3263: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3265: {
                status.setFontWeight(new Value(75));
                break;
            }
            case 3267: {
                status.setFontSize(new Value(69), 1);
                break;
            }
            case 3269: {
                status.setFontSize(new Value(68), 1);
                break;
            }
            case 3271: {
                status.setTextDecoration(4096);
                break;
            }
            case 3273: 
            case 3275: {
                status.setTextDecoration(16384);
                break;
            }
            case 3277: {
                String string;
                Object object;
                int n;
                Integer n5;
                if (this.attribute == null) break;
                FontAttribute fontAttribute = (FontAttribute)this.attribute;
                if (fontAttribute.getColor() != null) {
                    status.foreColor = fontAttribute.getColor();
                }
                if ((n5 = fontAttribute.getSize(3)) != null && (n = n5.intValue()) != 3) {
                    int n6;
                    status.setFontSize(new Value(22), 1);
                    if (n5 < 3) {
                        object = new Value(68);
                        for (n6 = n5.intValue(); n6 < 3; ++n6) {
                            status.setFontSize((Value)object, 1);
                        }
                    } else if (n5 > 3) {
                        object = new Value(69);
                        for (n6 = n5.intValue(); n6 > 3; --n6) {
                            status.setFontSize((Value)object, 1);
                        }
                    }
                }
                if ((string = fontAttribute.getFace()) == null || string.length() <= 0) break;
                object = new StringTokenizer(string, ",");
                Value[] valueArray = new Value[((StringTokenizer)object).countTokens()];
                int n7 = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    valueArray[n7++] = new Value(((StringTokenizer)object).nextToken().trim());
                }
                status.setFontFamily(valueArray);
            }
        }
    }
}

