/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.token.FormCreater;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.StartToken;

public abstract class FormManager {
    private static FormCreater formCreater;

    protected FormManager() {
    }

    public static FormManager createFormManager(HawkContext hawkContext, Document document) {
        if (formCreater != null) {
            return formCreater.createFormManager(hawkContext, document);
        }
        FormManager.reportMessage(hawkContext.getReporter());
        return null;
    }

    private static void reportMessage(Reporter reporter) {
        if (reporter != null) {
            reporter.report(7, Resource.getMessage("formmanager.warning.notsupport", null), 0, 0);
        }
    }

    public abstract void beginForm(StartToken var1);

    public abstract void endForm();

    public abstract FormItem addFormItem(StartToken var1);

    public abstract void beginSelect(StartToken var1);

    public abstract FormItem endSelect();

    public abstract void addOption(StartToken var1);

    public abstract FormItem addTextarea(StartToken var1);

    static {
        try {
            formCreater = (FormCreater)Class.forName(Resource.getMessage("formmanager.creater", null)).newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

