/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.net.URL;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.java2.AWTWrapper;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.token.Value;

public class Status
implements Cloneable {
    private static final char FONT_CHECK_CHAR = '\u4e9c';
    public static final int TARGET_TOP = 1;
    public static final int TARGET_RIGHT = 2;
    public static final int TARGET_BOTTOM = 4;
    public static final int TARGET_LEFT = 8;
    public static final int TARGET_ALL = 15;
    public static final int TOKEN = 1;
    public static final int STYLE = 2;
    private static AWTWrapper awtWrapper = AWTWrapper.getInstance();
    private HawkContext context;
    private Drawkit drawkit;
    private double baseFontSize = 12.0;
    Status firstChild = null;
    Status link = null;
    Status visited = null;
    Status hover = null;
    Status active = null;
    Status focus = null;
    Status firstLine = null;
    Status firstLetter = null;
    Status before = null;
    Status after = null;
    Box margin = null;
    Border border = null;
    Box padding = null;
    Image backImage = null;
    Dimension backImageSize = null;
    FontData fd = null;
    Font font = null;
    FontMetrics fm = null;
    Dimension fdFontSize = null;
    int fontHeightMax = 0;
    int fontHeightHalf = 0;
    int fontBaseFull = 0;
    int fontBaseHalf = 0;
    URL href = null;
    String tip = null;
    int listLevel = 0;
    int listType = 3;
    Status counterStatus = this;
    boolean reference = true;
    public boolean isBlackHole = false;
    public boolean isHorizontalRule = false;
    public Value hrHeight = null;
    public boolean isTable = false;
    public boolean isVertical = false;
    public int colSpan = 1;
    public int rowSpan = 1;
    public Value borderVerticalSpacing = null;
    public Value borderHorizontalSpacing = null;
    public int type = -1;
    public Status parent = null;
    private double fontPerPixel = 0.0;
    private boolean fontChanged = false;
    private Value[] fontFamilies = null;
    private String fontFamily = null;
    private boolean fontStyle = false;
    private int fontWeight = 0;
    private double fontSize = 0.0;
    private boolean fontSizeStyle = false;
    public Value width = null;
    public Value height = null;
    public Value textIndent = null;
    public Value lineHeight = null;
    public Value letterSpacing = null;
    public int align = 3;
    public int valign = 41;
    public Color foreColor = null;
    public Color backColor = null;
    public Color linkColor = null;
    public Color vlinkColor = null;
    public Color alinkColor = null;
    public int decoration = 1;
    public int whiteSpace = 3;
    public int counterNo = 1;
    public int offsetX = 0;
    public int floatType = 3;
    public int clearType = 3;

    Status(Drawkit drawkit) {
        this.context = drawkit.context;
        this.drawkit = drawkit;
        this.parent = this;
        Font font = this.context.getOption().getDefaultFont();
        FontMetrics fontMetrics = this.context.getToolkit().getFontMetrics(font);
        this.fontPerPixel = this.context.getOption().getFontPerPixel();
        this.fontChanged = true;
        this.fontFamily = font.getName();
        this.fontStyle = (font.getStyle() & 2) != 0;
        this.fontWeight = (font.getStyle() & 1) != 0 ? 700 : 400;
        this.fontSize = (double)font.getSize() / this.fontPerPixel;
        this.setupFont();
    }

    public Object clone() {
        try {
            Status status = (Status)super.clone();
            status.backImage = null;
            status.backImageSize = null;
            status.margin = null;
            status.border = null;
            status.padding = null;
            status.type = -1;
            status.width = null;
            status.height = null;
            status.valign = 41;
            status.backColor = null;
            status.counterNo = 1;
            status.floatType = 3;
            status.clearType = 3;
            status.isHorizontalRule = false;
            status.hrHeight = null;
            status.isTable = false;
            status.isVertical = false;
            status.colSpan = 1;
            status.rowSpan = 1;
            status.fontSizeStyle = false;
            status.parent = this;
            return status;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Status getParent() {
        return this.parent;
    }

    void checkStatus() {
        this.setupFont();
        if (this.align == 1) {
            this.align = this.parent.align;
        }
        if (this.valign == 1) {
            this.valign = this.parent.valign;
        }
        if (this.foreColor == null) {
            this.foreColor = this.parent.foreColor;
        }
        if (this.linkColor == null) {
            this.linkColor = this.parent.linkColor;
        }
        if (this.vlinkColor == null) {
            this.vlinkColor = this.parent.vlinkColor;
        }
        if (this.alinkColor == null) {
            this.alinkColor = this.parent.alinkColor;
        }
        if (this.decoration == 1) {
            this.decoration = this.parent.decoration;
        }
        if (this.whiteSpace == 1) {
            this.whiteSpace = this.parent.whiteSpace;
        }
    }

    public void setMargin(int n, Value value) {
        if (this.margin == null) {
            this.margin = new Box();
        }
        if ((n & 1) != 0) {
            this.margin.top = value;
        }
        if ((n & 2) != 0) {
            this.margin.right = value;
        }
        if ((n & 4) != 0) {
            this.margin.bottom = value;
        }
        if ((n & 8) != 0) {
            this.margin.left = value;
        }
    }

    public void setBorderStyle(int n, Value value) {
        if (this.border == null) {
            this.border = new Border();
        }
        this.border.setStyle(n, value);
    }

    public void setBorderWidth(int n, Value value) {
        if (this.border == null) {
            this.border = new Border();
        }
        this.border.setWidth(n, value);
    }

    public void setBorderColor(int n, Color color) {
        if (this.border == null) {
            this.border = new Border();
        }
        this.border.setColor(n, color);
    }

    public void setPadding(int n, Value value) {
        if (this.padding == null) {
            this.padding = new Box();
        }
        if ((n & 1) != 0) {
            this.padding.top = value;
        }
        if ((n & 2) != 0) {
            this.padding.right = value;
        }
        if ((n & 4) != 0) {
            this.padding.bottom = value;
        }
        if ((n & 8) != 0) {
            this.padding.left = value;
        }
    }

    public void setBackImage(String string) {
        if (string == null) {
            return;
        }
        Image image = this.drawkit.getImage(this.drawkit.createURL(string), string);
        if (image == null) {
            return;
        }
        if (this.drawkit.loadImage(image, "wait to load a background image") != 8) {
            image.flush();
            return;
        }
        this.backImage = image;
        this.backImageSize = new Dimension(image.getWidth(this.drawkit.imageDrawer), image.getHeight(this.drawkit.imageDrawer));
    }

    public void setFontFamily(Value[] valueArray) {
        this.fontFamilies = valueArray.length == 1 && valueArray[0].getType() == 1 ? this.parent.fontFamilies : valueArray;
        this.fontChanged = true;
    }

    public void setFontStyle(Value value) {
        switch (value.getType()) {
            case 1: {
                this.fontStyle = this.parent.fontStyle;
                break;
            }
            case 2: {
                this.fontStyle = false;
                break;
            }
            case 71: 
            case 72: {
                this.fontStyle = true;
            }
        }
        this.fontChanged = true;
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(Value value) {
        switch (value.getType()) {
            case 1: {
                this.fontWeight = this.parent.fontWeight;
                break;
            }
            case 2: {
                this.fontWeight = 400;
                break;
            }
            case 75: {
                this.fontWeight = 700;
                break;
            }
            case 76: {
                this.fontWeight += 100;
                break;
            }
            case 77: {
                this.fontWeight -= 100;
                break;
            }
            case -1: {
                this.fontWeight = value.intValue();
                break;
            }
            case 3: {
                this.fontWeight = -1;
            }
        }
        this.fontChanged = true;
    }

    public void setFontSize(Value value, int n) {
        if (n == 2 && !this.fontSizeStyle) {
            this.fontSize = this.parent.fontSize;
            this.fontSizeStyle = true;
        }
        switch (value.getType()) {
            case 1: {
                this.fontSize = this.parent.fontSize;
                break;
            }
            case 61: {
                this.fontSize = this.baseFontSize / 1.2 / 1.2 / 1.2;
                break;
            }
            case 62: {
                this.fontSize = this.baseFontSize / 1.2 / 1.2;
                break;
            }
            case 63: {
                this.fontSize = this.baseFontSize / 1.2;
                break;
            }
            case 22: {
                this.fontSize = this.baseFontSize;
                break;
            }
            case 65: {
                this.fontSize = this.baseFontSize * 1.2;
                break;
            }
            case 66: {
                this.fontSize = this.baseFontSize * 1.2 * 1.2;
                break;
            }
            case 67: {
                this.fontSize = this.baseFontSize * 1.2 * 1.2 * 1.2;
                break;
            }
            case 69: {
                this.fontSize *= 1.2;
                break;
            }
            case 68: {
                this.fontSize /= 1.2;
                break;
            }
            case -3: 
            case -2: {
                this.fontSize = value.getValue(this.fd, (int)this.fontSize, 1);
            }
        }
        this.fontChanged = true;
    }

    public void setFixedFont() {
        Font font = this.context.getOption().getDefaultFixedFont();
        if (font != null) {
            this.fontFamily = font.getName();
        }
        this.fontChanged = true;
    }

    private void setupFont() {
        if (!this.fontChanged) {
            return;
        }
        String string = this.fontFamily;
        int n = (this.fontWeight >= 700 ? 1 : 0) | (this.fontStyle ? 2 : 0);
        int n2 = (int)(this.fontSize * this.fontPerPixel);
        Font font = null;
        if (this.fontFamilies != null) {
            for (int i = 0; i < this.fontFamilies.length; ++i) {
                string = this.fontFamilies[i].getString();
                font = new Font(string, n, n2);
                if (awtWrapper != null && !awtWrapper.canFontDisplay(font, '\u4e9c')) continue;
                this.fontFamily = string;
                break;
            }
            this.fontFamilies = null;
        }
        if (font == null) {
            font = new Font(string, n, n2);
        }
        if (font.equals(this.font)) {
            return;
        }
        this.font = font;
        this.fd = FontData.getInstance(this.context, font);
        this.fm = this.fd.getFontMetrics();
        this.fdFontSize = this.fd.getFullSize();
        this.fontHeightMax = this.fd.getMaxHeight();
        this.fontHeightHalf = this.fd.getHalfHeight();
        this.fontBaseFull = this.fd.getFullBase();
        this.fontBaseHalf = this.fd.getHalfBase();
        this.fontChanged = false;
    }

    public FontData getFontData() {
        return this.fd;
    }

    public void setTextDecoration(int n) {
        this.decoration |= n;
    }

    public boolean getTextDecoration(int n) {
        return (this.decoration & n) != 0;
    }

    public void setList(int n) {
        ++this.listLevel;
        if (n == 912) {
            switch (this.listLevel) {
                case 1: {
                    this.listType = 81;
                    break;
                }
                case 2: {
                    this.listType = 82;
                    break;
                }
                default: {
                    this.listType = 83;
                    break;
                }
            }
        } else {
            this.listType = n;
        }
        this.counterStatus = this;
    }

    class Box {
        Value top;
        Value right;
        Value bottom;
        Value left;

        private Box() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append('[');
            if (this.top != null) {
                stringBuffer.append(this.top.toString());
            }
            stringBuffer.append(", ");
            if (this.right != null) {
                stringBuffer.append(this.right.toString());
            }
            stringBuffer.append(", ");
            if (this.bottom != null) {
                stringBuffer.append(this.bottom.toString());
            }
            stringBuffer.append(", ");
            if (this.left != null) {
                stringBuffer.append(this.left.toString());
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

