/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class RotateFilter
extends ImageFilter {
    private static ColorModel defaultColorModel = ColorModel.getRGBdefault();
    private int[] raster;
    private int srcWidth;
    private int srcHeight;

    public void setDimensions(int n, int n2) {
        this.raster = new int[n * n2];
        this.srcWidth = n;
        this.srcHeight = n2;
        this.consumer.setDimensions(n2, n);
    }

    public void setColorModel(ColorModel colorModel) {
        this.consumer.setColorModel(defaultColorModel);
    }

    public void setHints(int n) {
        this.consumer.setHints(0xE | n & 0x10);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n5;
        int n8 = n2 * this.srcWidth + n;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.raster[n8++] = colorModel.getRGB(byArray[n7++] & 0xFF);
            }
            n7 += n6 - n3;
            n8 += this.srcWidth - n3;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n5;
        int n8 = n2 * this.srcWidth + n;
        if (colorModel == defaultColorModel) {
            for (int i = 0; i < n4; ++i) {
                System.arraycopy(nArray, n7, this.raster, n8, n3);
                n7 += n6;
                n8 += this.srcWidth;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.raster[n8++] = colorModel.getRGB(nArray[n7++]);
                }
                n7 += n6 - n3;
                n8 += this.srcWidth - n3;
            }
        }
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int[] nArray = new int[this.srcWidth * this.srcHeight];
        int n2 = 0;
        for (int i = 0; i < this.srcWidth; ++i) {
            int n3 = this.srcWidth * (this.srcHeight - 1) + i;
            for (int j = 0; j < this.srcHeight; ++j) {
                nArray[n2++] = this.raster[n3];
                n3 -= this.srcWidth;
            }
        }
        this.consumer.setPixels(0, 0, this.srcHeight, this.srcWidth, defaultColorModel, nArray, 0, this.srcHeight);
        this.consumer.imageComplete(n);
    }
}

