/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreator;

public abstract class InnerToolTip {
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private static final int INNER_MARGIN = 3;
    private static final int OUTER_MARGIN = 3;
    private static int threadCount = 0;
    private ImageCreator creator = null;
    private volatile long delay = 0L;
    private volatile long term = 0L;
    private Insets fix = null;
    private Font font = null;
    private Color colorFore = null;
    private Color colorBack = null;
    private Color colorEdge = null;
    private Tip tip;
    private ToolTipThread timer;

    public InnerToolTip(ImageCreator imageCreator, long l, long l2, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        this.creator = imageCreator;
        this.delay = l;
        this.term = l2;
        this.fix = insets;
        this.timer = new ToolTipThread("Kankana-InnerToolTip-" + ++threadCount);
        this.timer.start();
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.infoText);
        this.setBackground(SystemColor.info);
        this.setEdgeColor(SystemColor.windowBorder);
    }

    public synchronized void showTip(String string, int n, int n2, int n3, int n4) {
        this.timer.reset(new Tip(string, n, n2, n3, n4));
    }

    public void cancel() {
        this.timer.cancel();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getForeground() {
        return this.colorFore;
    }

    public void setForeground(Color color) {
        this.colorFore = color;
    }

    public Color getBackground() {
        return this.colorBack;
    }

    public void setBackground(Color color) {
        this.colorBack = color;
    }

    public Color getEdgeColor() {
        return this.colorEdge;
    }

    public void setEdgeColor(Color color) {
        this.colorEdge = color;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    public long getTerm() {
        return this.term;
    }

    public void setTerm(long l) {
        this.term = l;
    }

    public void paint(Graphics graphics) {
        Tip tip = this.tip;
        if (tip != null) {
            tip.paint(graphics);
        }
    }

    public void dispose() {
        this.timer.interrupt();
    }

    public abstract void repaint(int var1, int var2, int var3, int var4);

    private class Tip
    implements Cloneable {
        private String value;
        private int baseX;
        private int baseY;
        private int baseWidth;
        private int baseHeight;
        private char[] chars;
        private Font font;
        private FontMetrics fm;
        private int baseFull;
        private int baseHalf;
        private int x;
        private int y;
        private int width;
        private int height;

        private Tip(String string, int n, int n2, int n3, int n4) {
            this.value = string;
            this.baseX = n;
            this.baseY = n2;
            this.baseWidth = n3;
            this.baseHeight = n4;
        }

        private void initialize() {
            Font font = InnerToolTip.this.font;
            if (font == this.font) {
                return;
            }
            FontData fontData = FontData.getInstance(InnerToolTip.this.creator, font);
            this.chars = this.value.toCharArray();
            this.font = font;
            this.fm = fontData.getFontMetrics();
            this.baseFull = fontData.getFullBase();
            this.baseHalf = fontData.getHalfBase();
            int n = this.baseX;
            int n2 = this.baseY;
            int n3 = this.fm.stringWidth(this.value) + 6 + 2;
            int n4 = Math.max(fontData.getFullSize().height, fontData.getHalfHeight()) + 6 + 2;
            if (this.baseWidth < n + n3 + 3) {
                n = this.baseWidth - n3 - 3;
            }
            if (n < 3) {
                n = 3;
            }
            if (this.baseHeight < n2 + n4 + 3) {
                n2 = this.baseHeight - n4 - 3;
            }
            if (n2 < 3) {
                n2 = 3;
            }
            this.x = n;
            this.y = n2;
            this.width = n3 - 1;
            this.height = n4 - 1;
        }

        private void paint(Graphics graphics) {
            graphics.setColor(InnerToolTip.this.colorBack);
            graphics.fillRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2);
            graphics.setColor(InnerToolTip.this.colorEdge);
            graphics.drawRect(this.x, this.y, this.width - 1, this.height - 1);
            graphics.setColor(InnerToolTip.this.colorFore);
            int n = this.x + 3 + 1;
            int n2 = this.y + 3 + 1;
            graphics.setFont(this.font);
            for (int i = 0; i < this.chars.length; ++i) {
                char c = this.chars[i];
                graphics.drawChars(this.chars, i, 1, n, n2 + (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? this.baseHalf : this.baseFull));
                n += this.fm.charWidth(this.chars[i]);
            }
        }
    }

    private class ToolTipThread
    extends Thread {
        private Tip tip;
        private boolean reset;

        private ToolTipThread(String string) {
            super(string);
        }

        public void run() {
            try {
                ToolTipThread toolTipThread = this;
                synchronized (toolTipThread) {
                    block5: while (true) {
                        this.wait();
                        while (true) {
                            if (this.tip == null || !this.reset) continue block5;
                            this.reset = false;
                            this.wait(InnerToolTip.this.delay);
                            if (this.reset || this.tip == null) continue;
                            this.tip.initialize();
                            Tip tip = this.tip;
                            InnerToolTip.this.tip = tip;
                            InnerToolTip.this.repaint(tip.x, tip.y, tip.width, tip.height);
                            this.wait(InnerToolTip.this.term);
                            InnerToolTip.this.tip = null;
                            InnerToolTip.this.repaint(tip.x, tip.y, tip.width, tip.height);
                        }
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private synchronized void cancel() {
            this.reset = true;
            this.tip = null;
            InnerToolTip.this.tip = null;
            this.notify();
        }

        private synchronized void reset(Tip tip) {
            this.reset = true;
            this.tip = tip;
            this.notify();
        }
    }
}

