/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.applet.BasicScrollbar;
import net.hizlab.kagetaka.build.ParserManager;
import net.hizlab.kagetaka.cookie.CookieStore;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.EngineListener;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.HawkEngine;
import net.hizlab.kagetaka.rendering.HawkPanel;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.PanelListener;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.RequestList;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.util.Environment;
import net.hizlab.kagetaka.util.StringUtils;

public class HawkApplet
extends Applet {
    private static final String RESOURCE = "net.hizlab.kagetaka.applet.Resource";
    private static final String BUILD_RESOURCE = "net.hizlab.kagetaka.Build";
    private Hashtable supportProtocol = new Hashtable();
    private HawkAppletContext hawkContext;
    private TextField addressBar;
    private String statusText;
    private Option option;
    private int logLevel;
    private Hashtable visitedUrl;
    private CookieStore cookieManager;

    public HawkApplet() {
        StringTokenizer stringTokenizer = new StringTokenizer(Resource.getMessage("config.support.protocol", null), ",; ");
        while (stringTokenizer.hasMoreTokens()) {
            this.supportProtocol.put(stringTokenizer.nextToken(), "");
        }
        this.option = new Option();
        this.logLevel = 10;
        this.visitedUrl = new Hashtable();
    }

    public void init() {
        Serializable serializable;
        this.addressBar = new TextField();
        this.addressBar.setEditable(false);
        String string = null;
        boolean bl = true;
        string = this.getParameter("font");
        if (string != null) {
            serializable = Font.decode(string);
            if (serializable != null) {
                this.option.setDefaultFont((Font)serializable);
            } else {
                this.showStatus(this.getMessage("parameter.nofont", new String[]{string}));
            }
        }
        if ((string = this.getParameter("parser")) != null) {
            if (ParserManager.getParser(string) != null) {
                this.option.setInputStreamParser(string);
            } else {
                this.showStatus(this.getMessage("parameter.noparser", new String[]{string}));
            }
        }
        if ((string = this.getParameter("addressbar")) != null) {
            bl = Boolean.valueOf(string);
        }
        if ((string = this.getParameter("scrollbar")) != null) {
            this.option.setShowScrollbar(Boolean.valueOf(string));
        }
        if ((string = this.getParameter("spingif")) != null) {
            this.option.setSpinGifImage(Boolean.valueOf(string));
        }
        if ((string = this.getParameter("spinjpeg")) != null) {
            this.option.setSpinJpegImage(Boolean.valueOf(string));
        }
        if ((string = this.getParameter("swapdecoration")) != null) {
            this.option.setSwapDecoration(Boolean.valueOf(string));
        }
        if ((string = this.getParameter("loglevel")) != null) {
            this.logLevel = Integer.parseInt(string);
        }
        if ((string = this.getParameter("url")) == null) {
            this.showStatus(this.getMessage("parameter.nourl", null));
            return;
        }
        serializable = null;
        try {
            serializable = new URL(this.getCodeBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            this.showStatus(this.getMessage("error.url.unknown", new String[]{string, malformedURLException.toString()}));
            return;
        }
        this.cookieManager = CookieStore.getInstance();
        this.hawkContext = new HawkAppletContext();
        this.setLayout(new BorderLayout());
        if (bl) {
            this.add((Component)this.addressBar, "North");
        }
        this.add((Component)this.hawkContext.hawkPanel, "Center");
        this.open((URL)serializable);
    }

    public void destroy() {
        super.destroy();
        this.removeAll();
        this.hawkContext.dispose();
    }

    public void start() {
        super.start();
        this.hawkContext.hawkPanel.requestFocus();
    }

    public String getAppletInfo() {
        return Resource.getMessage("kagetaka.copyright", null);
    }

    public String[][] getParameterInfo() {
        return new String[][]{{"url", "URL", "read file url."}, {"font", "string", "java's font string(fontname-style-size)."}, {"parser", "class", "parser class."}, {"addressbar", "boolean", "use addressbar."}, {"scrollbar", "boolean", "use scrllbar."}, {"spingif", "boolean", "spin gif image."}, {"spinjpeg", "boolean", "spin jpeg image."}, {"loglevel", "int", "log level."}};
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void open(URL uRL) {
        this.hawkContext.load(new Request(uRL, null, this.getDocumentBase(), null, false, false, 2));
    }

    private String getMessage(String string, String[] stringArray) {
        return Resource.getMessage(RESOURCE, string, stringArray);
    }

    static {
        Environment.isApplet = true;
    }

    private class MenuActionListener
    implements ActionListener {
        private static final int MAIN = 0;
        private static final int LINK = 1;
        private static final int STATUS = 2;
        private int type;

        private MenuActionListener(int n) {
            this.type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.type) {
                case 0: 
                case 1: {
                    URL uRL;
                    URL uRL2 = this.type == 0 ? (HawkApplet.this.hawkContext.viewRequest != null ? ((HawkAppletContext)((HawkApplet)HawkApplet.this).hawkContext).viewRequest.url : null) : (uRL = HawkApplet.this.hawkContext.hawkPanel.getSelectedLink());
                    if (uRL == null) {
                        return;
                    }
                    HawkApplet.this.getAppletContext().showDocument(uRL);
                    break;
                }
                case 2: {
                    System.out.println(Resource.getMessage("kagetaka.name.en", null) + " " + Resource.getMessage("kagetaka.version", null) + " " + "(Build: " + Resource.getMessage(HawkApplet.BUILD_RESOURCE, "build.number", null) + " " + Resource.getMessage(HawkApplet.BUILD_RESOURCE, "build.date", null) + ")");
                    System.out.println(Resource.getMessage("kagetaka.copyright", null) + " " + Resource.getMessage("kagetaka.vender.en", null));
                }
            }
        }
    }

    private class AppletReporter
    implements Reporter {
        private AppletReporter() {
        }

        public void report(int n, String string, int n2, int n3) {
            if (n < HawkApplet.this.logLevel) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("#");
            switch (n) {
                case 10: {
                    stringBuffer.append("ERROR");
                    break;
                }
                case 7: {
                    stringBuffer.append("WARNING");
                    break;
                }
                default: {
                    stringBuffer.append("MESSAGE");
                }
            }
            stringBuffer.append(":");
            stringBuffer.append(n2);
            stringBuffer.append(":");
            stringBuffer.append(n3);
            stringBuffer.append(":");
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }

        public int getLevel() {
            return HawkApplet.this.logLevel;
        }
    }

    private class HawkAppletContext
    implements HawkContext,
    PanelListener,
    EngineListener {
        private AppletReporter reporter;
        private HawkEngine hawkEngine;
        private HawkPanel hawkPanel;
        private RequestList requestList;
        private boolean active;
        private Request viewRequest;
        private Request nextRequest;

        private HawkAppletContext() {
            this.reporter = new AppletReporter();
            this.hawkEngine = new HawkEngine(this);
            this.hawkPanel = new HawkPanel(this, new BasicScrollbar(0), new BasicScrollbar(1));
            this.requestList = new RequestList();
            this.hawkEngine.setEngineListener(this);
            this.hawkPanel.setPanelListener(this);
            this.initContextMenu();
            this.active = true;
        }

        private void initContextMenu() {
            String string = HawkApplet.this.getMessage("contextmenu.openbrowser", null);
            Vector vector = null;
            MenuItem menuItem = null;
            menuItem = new MenuItem(string);
            menuItem.addActionListener(new MenuActionListener(0));
            vector = this.hawkPanel.getMainMenuItems();
            vector.addElement(new MenuItem("-"));
            vector.addElement(menuItem);
            menuItem = new MenuItem(HawkApplet.this.getMessage("contextmenu.dumpstatus", null));
            menuItem.addActionListener(new MenuActionListener(2));
            vector = this.hawkPanel.getMainMenuItems();
            vector.addElement(new MenuItem("-"));
            vector.addElement(menuItem);
            menuItem = new MenuItem(string);
            menuItem.addActionListener(new MenuActionListener(1));
            vector = this.hawkPanel.getLinkMenuItems();
            vector.addElement(new MenuItem("-"));
            vector.addElement(menuItem);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void load(Request request) {
            this.hawkEngine.stop();
            if (request.getDocument() != null && request.postData != null) {
                HawkAppletContext hawkAppletContext = this;
                synchronized (hawkAppletContext) {
                    this.changeHistory(request);
                }
                this.setupCanvas(request);
                this.setStatus(HawkApplet.this.getMessage("error.dorepost.stop", null));
                return;
            }
            request.setMoved(false);
            HawkAppletContext hawkAppletContext = this;
            synchronized (hawkAppletContext) {
                if (this.viewRequest != null && this.viewRequest != request && request.useCache >= 2 && request.postData == null && StringUtils.sameFile(this.viewRequest.getDocument().url, request.url)) {
                    request.copyFrom(this.viewRequest);
                    this.changeHistory(request);
                    this.movePosition(true);
                    this.setStatus(null);
                    return;
                }
                this.nextRequest = request;
            }
            this.hawkPanel.setCursor(3);
            this.hawkEngine.load(request);
        }

        void dispose() {
            this.hawkEngine.dispose();
        }

        public Reporter getReporter() {
            return this.reporter;
        }

        public Toolkit getToolkit() {
            return this.hawkPanel.getToolkit();
        }

        public void openHawk(Request request) {
            if (HawkApplet.this.supportProtocol.containsKey(request.url.getProtocol())) {
                this.load(request);
            } else if (request.isNewWindow) {
                HawkApplet.this.getAppletContext().showDocument(request.url, "_blank");
            } else {
                HawkApplet.this.getAppletContext().showDocument(request.url);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URLConnection getURLConnection(Request request) throws IOException, InterruptedException {
            String string;
            URLConnection uRLConnection = request.url.openConnection();
            if (HawkApplet.this.cookieManager != null && (string = HawkApplet.this.cookieManager.getCookie(request.url)) != null) {
                uRLConnection.setRequestProperty("Cookie", string);
            }
            if (request.postData != null && uRLConnection instanceof HttpURLConnection) {
                request.postData.send((HttpURLConnection)uRLConnection);
            }
            try {
                uRLConnection.connect();
            }
            finally {
                if (Thread.interrupted()) {
                    throw new InterruptedException("connect");
                }
            }
            if (HawkApplet.this.cookieManager != null) {
                int n = 1;
                while ((string = uRLConnection.getHeaderFieldKey(n)) != null) {
                    if ((string = string.toLowerCase()).compareTo("set-cookie") == 0) {
                        this.setCookie(uRLConnection.getHeaderField(n), request.url);
                    }
                    ++n;
                }
            }
            return uRLConnection;
        }

        public void download(Document document, URLConnection uRLConnection) {
            HawkApplet.this.getAppletContext().showDocument(document.url);
        }

        public Image createImage(ImageProducer imageProducer) {
            return this.hawkPanel.createImage(imageProducer);
        }

        public Image createImage(int n, int n2) {
            return this.hawkPanel.createImage(n, n2);
        }

        public MediaTracker getMediaTracker() {
            return this.hawkPanel.getMediaTracker();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addImage(Image image, int n, int n2) {
            this.hawkPanel.addImage(image, n, n2);
            HawkAppletContext hawkAppletContext = this;
            synchronized (hawkAppletContext) {
                this.movePosition(false);
            }
        }

        public void addFormItem(FormItem formItem) {
            this.hawkPanel.addFormItem(formItem);
        }

        public void setupCanvas(Request request) {
            this.hawkPanel.setupCanvas(request);
        }

        public void repaint(int n, int n2, int n3, int n4) {
            this.hawkPanel.repaintCanvas(n, n2, n3, n4);
        }

        public void setStatus(String string) {
            if (this.active) {
                HawkApplet.this.showStatus(string);
            }
            HawkApplet.this.statusText = string;
        }

        public void setTemporaryStatus(String string) {
            if (this.active) {
                if (string != null) {
                    HawkApplet.this.showStatus(string);
                } else {
                    HawkApplet.this.showStatus(HawkApplet.this.statusText);
                }
            }
        }

        public Dimension getViewportSize() {
            return this.hawkPanel.getViewportSize();
        }

        public Option getOption() {
            return HawkApplet.this.option;
        }

        public boolean haveEverVisited(URL uRL) {
            return HawkApplet.this.visitedUrl.containsKey(uRL.toString());
        }

        public void setCookie(String string, URL uRL) {
            if (HawkApplet.this.cookieManager != null) {
                HawkApplet.this.cookieManager.setCookie(string, uRL);
            }
        }

        public void back() {
            Request request;
            Request request2 = request = this.viewRequest != null ? this.viewRequest.getPrevious() : null;
            if (request != null) {
                this.load(request);
            }
        }

        public boolean canBack() {
            return this.viewRequest != null && this.viewRequest.getPrevious() != null;
        }

        public void forward() {
            Request request;
            Request request2 = request = this.viewRequest != null ? this.viewRequest.getNext() : null;
            if (request != null) {
                this.load(request);
            }
        }

        public boolean canForward() {
            return this.viewRequest != null && this.viewRequest.getNext() != null;
        }

        public void reload(boolean bl) {
            if (this.viewRequest != null) {
                this.load(this.viewRequest);
            }
        }

        public boolean canReload() {
            return this.viewRequest != null;
        }

        public void stop() {
            this.hawkEngine.stop();
        }

        public boolean canStop() {
            return this.hawkEngine.isLoading();
        }

        public void connecting(Request request) {
        }

        public void connected(Request request, boolean bl) {
        }

        public synchronized void renderingSkipped(Request request) {
            if (this.nextRequest != request) {
                return;
            }
            this.nextRequest = null;
            this.hawkPanel.setCursor(0);
        }

        public synchronized void renderingStarted(Request request) {
            if (this.nextRequest != request) {
                return;
            }
            this.changeHistory(request);
            this.hawkPanel.requestFocus();
        }

        public synchronized void renderingStopped(Request request, boolean bl) {
            if (this.nextRequest != request) {
                return;
            }
            this.renderingSkipped(request);
            this.movePosition(true);
        }

        public synchronized void refresh(Request request, Request request2) {
            if (this.viewRequest != request) {
                return;
            }
            this.load(request2);
        }

        private void changeHistory(Request request) {
            if (this.viewRequest != null) {
                this.viewRequest.setPosition(this.hawkPanel.getScrollPosition());
            }
            if (!request.isMember()) {
                this.requestList.append(this.viewRequest, request);
                HawkApplet.this.visitedUrl.put(request.url.toString(), "");
            }
            this.viewRequest = request;
            if (this.active) {
                ((TextComponent)HawkApplet.this.addressBar).setText(request.getDisplayURL());
            }
        }

        private void movePosition(boolean bl) {
            if (this.viewRequest.isMoved()) {
                return;
            }
            Point point = this.viewRequest.getPosition();
            if (point != null) {
                Point point2 = this.hawkPanel.getScrollPosition();
                if ((bl || point2.x == 0 && point2.y == 0) && !this.hawkPanel.setScrollPosition(point.x, point.y, false)) {
                    return;
                }
            } else if (!this.hawkPanel.setScrollPosition(this.viewRequest.url.getRef(), bl)) {
                return;
            }
            this.viewRequest.setMoved(true);
        }
    }
}

