/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.util.Stack;
import java.util.Vector;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.viewer.HawkViewer;
import net.hizlab.kagetaka.viewer.HawkWindow;

public class WindowManager {
    private static WindowManager windowManager = new WindowManager();
    private Vector windows = new Vector();
    private Stack viewerStack = new Stack();

    public static final WindowManager getInstance() {
        return windowManager;
    }

    private WindowManager() {
    }

    public synchronized void addWindow(HawkWindow window) {
        this.windows.addElement(window);
        for (int i = 0; i < this.windows.size(); ++i) {
            ((HawkWindow)this.windows.elementAt(i)).addWindowMenu(window);
        }
    }

    public synchronized void removeWindow(HawkWindow window) {
        int index = this.windows.indexOf(window);
        if (index == -1) {
            return;
        }
        this.windows.removeElement(window);
        this.viewerStack.removeElement(window);
        for (int i = 0; i < this.windows.size(); ++i) {
            ((HawkWindow)this.windows.elementAt(i)).removeWindowMenu(index);
        }
    }

    public synchronized void changeWindow(HawkWindow window) {
        int index = this.windows.indexOf(window);
        if (index == -1) {
            return;
        }
        for (int i = 0; i < this.windows.size(); ++i) {
            ((HawkWindow)this.windows.elementAt(i)).changeWindowMenu(index, window);
        }
    }

    public synchronized HawkWindow[] getWindows() {
        Object[] wins = new HawkWindow[this.windows.size()];
        this.windows.copyInto(wins);
        return wins;
    }

    synchronized void changeActiveViewer(HawkViewer viewer) {
        this.viewerStack.removeElement(viewer);
        this.viewerStack.push(viewer);
    }

    public synchronized HawkViewer getActiveViewer() {
        return (HawkViewer)this.viewerStack.peek();
    }

    public synchronized void exit() {
        HawkWindow[] windows = this.getWindows();
        for (int i = 0; i < windows.length; ++i) {
            windows[i].closeWindow();
        }
    }

    public synchronized void addToBookmark(Bookmark parent, Bookmark bookmark) {
        for (int i = 0; i < this.windows.size(); ++i) {
            ((HawkWindow)this.windows.elementAt(i)).addToBookmark(parent, bookmark);
        }
    }

    public synchronized void bookmarkChanged() {
        for (int i = 0; i < this.windows.size(); ++i) {
            ((HawkWindow)this.windows.elementAt(i)).bookmarkChanged();
        }
    }
}

