/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.viewer.ContextListener;
import net.hizlab.kagetaka.viewer.HawkViewer;
import net.hizlab.kagetaka.viewer.HawkWindow;
import net.hizlab.kagetaka.viewer.ViewerContext;
import net.hizlab.kagetaka.viewer.WindowManager;

class ViewerMenu
implements ContextListener {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resource";
    private static final int MENU_MENU = 0;
    private static final int MENU_POPUP = 1;
    private static final int MENU_ITEM = 2;
    private static final int MENU_CHECK = 3;
    private static final int MENU_SEPARATOR = -1;
    private static final int MENU_FILE = 0;
    private static final int MENU_FILE_NEWWINDOW = 1;
    private static final int MENU_FILE_NEWTAB = 2;
    private static final int MENU_FILE_OPENURL = 3;
    private static final int MENU_FILE_OPENFILE = 4;
    private static final int MENU_FILE_CLOSEWINDOW = 5;
    private static final int MENU_FILE_CLOSETAB = 6;
    private static final int MENU_FILE_SAVEAS = 7;
    private static final int MENU_FILE_PRINTSET = 8;
    private static final int MENU_FILE_PRINTPREVIEW = 9;
    private static final int MENU_FILE_PRINT = 10;
    private static final int MENU_FILE_EXIT = 11;
    private static final int MENU_EDIT = 12;
    private static final int MENU_EDIT_CUT = 13;
    private static final int MENU_EDIT_COPY = 14;
    private static final int MENU_EDIT_PASTE = 15;
    private static final int MENU_EDIT_DELETE = 16;
    private static final int MENU_EDIT_SELECTALL = 17;
    private static final int MENU_EDIT_FIND = 18;
    private static final int MENU_EDIT_FINDNEXT = 19;
    private static final int MENU_EDIT_FINDBEFORE = 20;
    private static final int MENU_VIEW = 21;
    private static final int MENU_VIEW_SHOW = 22;
    private static final int MENU_VIEW_SHOW_NAVIBAR = 23;
    private static final int MENU_VIEW_SHOW_SEARCHBAR = 24;
    private static final int MENU_VIEW_SHOW_LINKBAR = 25;
    private static final int MENU_VIEW_SHOW_STATUSBAR = 26;
    private static final int MENU_VIEW_STOP = 27;
    private static final int MENU_VIEW_RELOAD = 28;
    private static final int MENU_VIEW_SIZE = 29;
    private static final int MENU_VIEW_SIZE_SMALL = 30;
    private static final int MENU_VIEW_SIZE_LARGE = 31;
    private static final int MENU_VIEW_SIZE_M3 = 32;
    private static final int MENU_VIEW_SIZE_M2 = 33;
    private static final int MENU_VIEW_SIZE_M1 = 34;
    private static final int MENU_VIEW_SIZE_0 = 35;
    private static final int MENU_VIEW_SIZE_P1 = 36;
    private static final int MENU_VIEW_SIZE_P2 = 37;
    private static final int MENU_VIEW_SIZE_P3 = 38;
    private static final int MENU_VIEW_SIZE_INPUT = 39;
    private static final int MENU_VIEW_CODE = 40;
    private static final int MENU_VIEW_CODE_JA_AUTO = 41;
    private static final int MENU_VIEW_CODE_SHIFT_JIS = 42;
    private static final int MENU_VIEW_CODE_EUC_JP = 43;
    private static final int MENU_VIEW_CODE_ISO_2022_JP = 44;
    private static final int MENU_VIEW_CODE_ISO_8859_1 = 45;
    private static final int MENU_VIEW_CODE_UTF_8 = 46;
    private static final int MENU_VIEW_SOURCE = 47;
    private static final int MENU_VIEW_INFO = 48;
    private static final int MENU_MOVE = 49;
    private static final int MENU_MOVE_BACK = 50;
    private static final int MENU_MOVE_FORWARD = 51;
    private static final int MENU_MOVE_HOME = 52;
    private static final int MENU_MOVE_HISTORY = 53;
    private static final int MENU_BOOKMARK = 54;
    private static final int MENU_BOOKMARK_ADD = 55;
    private static final int MENU_BOOKMARK_ADDEX = 56;
    private static final int MENU_BOOKMARK_EDITOR = 57;
    private static final int MENU_TOOL = 58;
    private static final int MENU_TOOL_AUTH = 59;
    private static final int MENU_TOOL_COOKIE = 60;
    private static final int MENU_TOOL_WEB = 61;
    private static final int MENU_TOOL_WEB_CONSOLE = 62;
    private static final int MENU_TOOL_OPTION = 63;
    private static final int MENU_WINDOW = 64;
    private static final int MENU_HELP = 65;
    private static final int MENU_HELP_ABOUT = 66;
    private static final int MENU_TAB = 67;
    private static final int MENU_TAB_CLOSE = 68;
    private static final int MENU_TAB_RELOAD = 69;
    private static final int MENU_TAB_CREATE = 70;
    private static final int MENU_TAB_CLOSEOTHER = 71;
    private static final int MENU_TAB_CLOSELEFT = 72;
    private static final int MENU_TAB_CLOSERIGHT = 73;
    private static final int MENU_TAB_LOCK = 74;
    private static final int MENU_SIZE = 76;
    private static final int MENU_SIZE_MOVE_MIN = 6;
    private static final int MENU_SIZE_MOVE_MAX = 20;
    private static final int MENU_SIZE_BOOKMARK = 5;
    private static final int LOAD_BEFORE = 0;
    private static final int LOAD_LOADING = 1;
    private static final int LOAD_LOADED = 2;
    private HawkViewer viewer;
    private ViewerOption option;
    private MenuBar menuBar;
    private MenuItem[] menus;
    private Menu moveMenu;
    private Menu bookmarkMenu;
    private Menu windowMenu;
    private PopupMenu tabPopupMenu;
    private MenuItem activeMenuItem;
    private ViewerContext activeContext;

    ViewerMenu(HawkViewer viewer) {
        this.viewer = viewer;
        this.option = viewer.getOption();
        this.initializeMenu();
    }

    private void initializeMenu() {
        WindowManager windowManager = WindowManager.getInstance();
        this.menuBar = new MenuBar();
        this.menus = new MenuItem[76];
        Menu menu = null;
        Menu sub = null;
        menu = (Menu)this.createMenuItem(0, 0, null, 0);
        this.createMenuItem(1, 2, menu, 78);
        this.createMenuItem(2, 2, menu, 84);
        this.createMenuItem(3, 2, menu, 76);
        this.createMenuItem(4, 2, menu, 79);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(5, 2, menu, 0);
        this.createMenuItem(6, 2, menu, 87);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(7, 2, menu, 83);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(8, 2, menu, 0);
        this.createMenuItem(9, 2, menu, -80);
        this.createMenuItem(10, 2, menu, 80);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(11, 2, menu, 81);
        this.menuBar.add(menu);
        menu = (Menu)this.createMenuItem(12, 0, null, 0);
        this.createMenuItem(13, 2, menu, 88);
        this.createMenuItem(14, 2, menu, 67);
        this.createMenuItem(15, 2, menu, 86);
        this.createMenuItem(16, 2, menu, 0);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(17, 2, menu, 65);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(18, 2, menu, 70);
        this.createMenuItem(19, 2, menu, 71);
        this.createMenuItem(20, 2, menu, -71);
        this.menuBar.add(menu);
        menu = (Menu)this.createMenuItem(21, 0, null, 0);
        sub = (Menu)this.createMenuItem(22, 0, menu, 0);
        this.createMenuItem(23, 3, sub, 0);
        this.createMenuItem(24, 3, sub, 0);
        this.createMenuItem(25, 3, sub, 0);
        this.createMenuItem(26, 3, sub, 0);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(27, 2, menu, 0);
        this.createMenuItem(28, 2, menu, 82);
        this.createMenuItem(-1, 2, menu, 0);
        sub = (Menu)this.createMenuItem(29, 0, menu, 0);
        this.createMenuItem(30, 3, sub, 107);
        this.createMenuItem(31, 3, sub, 109);
        this.createMenuItem(-1, 2, sub, 0);
        this.createMenuItem(32, 3, sub, 0);
        this.createMenuItem(33, 3, sub, 0);
        this.createMenuItem(34, 3, sub, 0);
        this.createMenuItem(35, 3, sub, 0);
        this.createMenuItem(36, 3, sub, 0);
        this.createMenuItem(37, 3, sub, 0);
        this.createMenuItem(38, 3, sub, 0);
        this.createMenuItem(-1, 2, sub, 0);
        this.createMenuItem(39, 3, sub, 0);
        sub = (Menu)this.createMenuItem(40, 0, menu, 0);
        this.createMenuItem(41, 3, sub, 0);
        this.createMenuItem(42, 3, sub, 0);
        this.createMenuItem(43, 3, sub, 0);
        this.createMenuItem(44, 3, sub, 0);
        this.createMenuItem(45, 3, sub, 0);
        this.createMenuItem(46, 3, sub, 0);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(47, 2, menu, 85);
        this.createMenuItem(48, 2, menu, 73);
        this.menuBar.add(menu);
        menu = this.moveMenu = (Menu)this.createMenuItem(49, 0, null, 0);
        this.createMenuItem(50, 2, menu, 0);
        this.createMenuItem(51, 2, menu, 0);
        this.createMenuItem(52, 2, menu, 0);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(53, 2, menu, 72);
        this.createMenuItem(-1, 2, menu, 0);
        this.menuBar.add(menu);
        menu = this.bookmarkMenu = (Menu)this.createMenuItem(54, 0, null, 0);
        this.createMenuItem(55, 2, menu, 68);
        this.createMenuItem(56, 2, menu, -68);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(57, 2, menu, 66);
        this.createMenuItem(-1, 2, menu, 0);
        this.menuBar.add(menu);
        this.bookmarkChanged();
        menu = (Menu)this.createMenuItem(58, 0, null, 0);
        this.createMenuItem(59, 2, menu, 0);
        this.createMenuItem(60, 2, menu, 0);
        this.createMenuItem(-1, 2, menu, 0);
        sub = (Menu)this.createMenuItem(61, 0, menu, 0);
        this.createMenuItem(62, 2, sub, 0);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(63, 2, menu, 0);
        this.menuBar.add(menu);
        menu = this.windowMenu = (Menu)this.createMenuItem(64, 0, null, 0);
        this.menuBar.add(menu);
        HawkWindow[] windows = windowManager.getWindows();
        for (int i = 0; i < windows.length; ++i) {
            this.addWindowMenu(windows[i]);
        }
        menu = (Menu)this.createMenuItem(65, 0, null, 0);
        this.createMenuItem(66, 2, menu, 0);
        this.menuBar.setHelpMenu(menu);
        this.tabPopupMenu = (PopupMenu)this.createMenuItem(67, 1, null, 0);
        menu = this.tabPopupMenu;
        this.createMenuItem(68, 2, menu, 0);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(69, 2, menu, 0);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(70, 2, menu, 0);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(71, 2, menu, 0);
        this.createMenuItem(72, 2, menu, 0);
        this.createMenuItem(73, 2, menu, 0);
        this.createMenuItem(-1, 2, menu, 0);
        this.createMenuItem(74, 3, menu, 0);
        this.viewer.add(this.tabPopupMenu);
        this.menus[7].setEnabled(false);
        this.menus[8].setEnabled(false);
        this.menus[9].setEnabled(false);
        this.menus[10].setEnabled(false);
        this.menus[13].setEnabled(false);
        this.menus[14].setEnabled(false);
        this.menus[15].setEnabled(false);
        this.menus[16].setEnabled(false);
        this.menus[17].setEnabled(false);
        this.menus[18].setEnabled(false);
        this.menus[19].setEnabled(false);
        this.menus[20].setEnabled(false);
        this.menus[24].setEnabled(false);
        this.menus[29].setEnabled(false);
        this.menus[40].setEnabled(false);
        this.menus[47].setEnabled(false);
        this.menus[48].setEnabled(false);
        this.menus[59].setEnabled(false);
        this.menus[60].setEnabled(false);
        this.menus[62].setEnabled(false);
        this.viewer.setMenuBar(this.menuBar);
    }

    private MenuItem createMenuItem(int index, int type, Menu parent, int key) {
        String menuKey = null;
        switch (index) {
            case -1: {
                break;
            }
            case 0: {
                menuKey = "menu.file";
                break;
            }
            case 1: {
                menuKey = "menu.file.newwindow";
                break;
            }
            case 2: {
                menuKey = "menu.file.newtab";
                break;
            }
            case 3: {
                menuKey = "menu.file.openurl";
                break;
            }
            case 4: {
                menuKey = "menu.file.openfile";
                break;
            }
            case 5: {
                menuKey = "menu.file.closewindow";
                break;
            }
            case 6: {
                menuKey = "menu.file.closetab";
                break;
            }
            case 7: {
                menuKey = "menu.file.saveas";
                break;
            }
            case 8: {
                menuKey = "menu.file.printset";
                break;
            }
            case 9: {
                menuKey = "menu.file.printpreview";
                break;
            }
            case 10: {
                menuKey = "menu.file.print";
                break;
            }
            case 11: {
                menuKey = "menu.file.exit";
                break;
            }
            case 12: {
                menuKey = "menu.edit";
                break;
            }
            case 13: {
                menuKey = "menu.edit.cut";
                break;
            }
            case 14: {
                menuKey = "menu.edit.copy";
                break;
            }
            case 15: {
                menuKey = "menu.edit.paste";
                break;
            }
            case 16: {
                menuKey = "menu.edit.delete";
                break;
            }
            case 17: {
                menuKey = "menu.edit.selectall";
                break;
            }
            case 18: {
                menuKey = "menu.edit.find";
                break;
            }
            case 19: {
                menuKey = "menu.edit.findnext";
                break;
            }
            case 20: {
                menuKey = "menu.edit.findbefore";
                break;
            }
            case 21: {
                menuKey = "menu.view";
                break;
            }
            case 22: {
                menuKey = "menu.view.show";
                break;
            }
            case 23: {
                menuKey = "menu.view.show.navibar";
                break;
            }
            case 24: {
                menuKey = "menu.view.show.searchbar";
                break;
            }
            case 25: {
                menuKey = "menu.view.show.linkbar";
                break;
            }
            case 26: {
                menuKey = "menu.view.show.statusbar";
                break;
            }
            case 27: {
                menuKey = "menu.view.stop";
                break;
            }
            case 28: {
                menuKey = "menu.view.reload";
                break;
            }
            case 29: {
                menuKey = "menu.view.size";
                break;
            }
            case 30: {
                menuKey = "menu.view.size.small";
                break;
            }
            case 31: {
                menuKey = "menu.view.size.large";
                break;
            }
            case 32: {
                menuKey = "menu.view.size.-3";
                break;
            }
            case 33: {
                menuKey = "menu.view.size.-2";
                break;
            }
            case 34: {
                menuKey = "menu.view.size.-1";
                break;
            }
            case 35: {
                menuKey = "menu.view.size.0";
                break;
            }
            case 36: {
                menuKey = "menu.view.size.+1";
                break;
            }
            case 37: {
                menuKey = "menu.view.size.+2";
                break;
            }
            case 38: {
                menuKey = "menu.view.size.+3";
                break;
            }
            case 39: {
                menuKey = "menu.view.size.input";
                break;
            }
            case 40: {
                menuKey = "menu.view.code";
                break;
            }
            case 41: {
                menuKey = "menu.view.code.ja_auto";
                break;
            }
            case 42: {
                menuKey = "menu.view.code.shift_jis";
                break;
            }
            case 43: {
                menuKey = "menu.view.code.euc-jp";
                break;
            }
            case 44: {
                menuKey = "menu.view.code.iso-2022-jp";
                break;
            }
            case 45: {
                menuKey = "menu.view.code.iso-8859-1";
                break;
            }
            case 46: {
                menuKey = "menu.view.code.utf-8";
                break;
            }
            case 47: {
                menuKey = "menu.view.source";
                break;
            }
            case 48: {
                menuKey = "menu.view.info";
                break;
            }
            case 49: {
                menuKey = "menu.move";
                break;
            }
            case 50: {
                menuKey = "menu.move.back";
                break;
            }
            case 51: {
                menuKey = "menu.move.forward";
                break;
            }
            case 52: {
                menuKey = "menu.move.home";
                break;
            }
            case 53: {
                menuKey = "menu.move.history";
                break;
            }
            case 54: {
                menuKey = "menu.bookmark";
                break;
            }
            case 55: {
                menuKey = "menu.bookmark.add";
                break;
            }
            case 56: {
                menuKey = "menu.bookmark.addex";
                break;
            }
            case 57: {
                menuKey = "menu.bookmark.editor";
                break;
            }
            case 58: {
                menuKey = "menu.tool";
                break;
            }
            case 59: {
                menuKey = "menu.tool.auth";
                break;
            }
            case 60: {
                menuKey = "menu.tool.cookie";
                break;
            }
            case 61: {
                menuKey = "menu.tool.web";
                break;
            }
            case 62: {
                menuKey = "menu.tool.web.console";
                break;
            }
            case 63: {
                menuKey = "menu.tool.option";
                break;
            }
            case 64: {
                menuKey = "menu.window";
                break;
            }
            case 65: {
                menuKey = "menu.help";
                break;
            }
            case 66: {
                menuKey = "menu.help.about";
                break;
            }
            case 67: {
                menuKey = "menu.tab";
                break;
            }
            case 68: {
                menuKey = "menu.tab.close";
                break;
            }
            case 69: {
                menuKey = "menu.tab.reload";
                break;
            }
            case 70: {
                menuKey = "menu.tab.create";
                break;
            }
            case 71: {
                menuKey = "menu.tab.closeother";
                break;
            }
            case 72: {
                menuKey = "menu.tab.closeleft";
                break;
            }
            case 73: {
                menuKey = "menu.tab.closeright";
                break;
            }
            case 74: {
                menuKey = "menu.tab.lock";
                break;
            }
            default: {
                return null;
            }
        }
        String label = menuKey == null ? "-" : Resource.getMessage(RESOURCE, menuKey, null);
        MenuItem mi = null;
        switch (type) {
            case 0: {
                mi = new Menu(label);
                break;
            }
            case 1: {
                mi = new PopupMenu(label);
                break;
            }
            case 2: {
                mi = new MenuItem(label);
                if (index == -1) break;
                mi.addActionListener(new MenuActionListner(index));
                break;
            }
            case 3: {
                CheckboxMenuItem cmi = new CheckboxMenuItem(label);
                cmi.addItemListener(new MenuActionListner(index));
                mi = cmi;
            }
        }
        if (key != 0) {
            mi.setShortcut(new MenuShortcut(Math.abs(key), key < 0));
        }
        mi.setActionCommand(menuKey != null ? menuKey : "-");
        if (index != -1) {
            this.menus[index] = mi;
        }
        if (parent != null) {
            parent.add(mi);
        }
        return mi;
    }

    void showTabPopupMenu(Component c, int x, int y) {
        this.tabPopupMenu.show(c, x, y);
    }

    void addWindowMenu(HawkWindow window) {
        MenuItem mi;
        if (this.viewer == window) {
            CheckboxMenuItem cmi = new CheckboxMenuItem(window.getTitle(), true);
            cmi.addItemListener(new CheckboxMenuItemListener());
            mi = cmi;
        } else {
            mi = new MenuItem(window.getTitle());
            mi.addActionListener(new WindowActionListener(window));
        }
        this.windowMenu.add(mi);
    }

    void removeWindowMenu(int index) {
        this.windowMenu.remove(index);
    }

    void changeWindowMenu(int index, HawkWindow window) {
        MenuItem mi = this.windowMenu.getItem(index);
        this.windowMenu.remove(index);
        mi.setLabel(window.getTitle());
        this.windowMenu.insert(mi, index);
    }

    void bookmarkChanged() {
        BookmarkManager bm = this.option.getBookmarkManager();
        Vector bookmarks = bm.getBookmarks();
        for (int i = this.bookmarkMenu.getItemCount() - 1; i >= 5; --i) {
            this.bookmarkMenu.remove(i);
        }
        this.createBookmarkMenu(this.bookmarkMenu, bookmarks);
    }

    void addToBookmark(Bookmark parent, Bookmark bookmark) {
        Menu menu = this.bookmarkMenu;
        if (parent != null && parent.getParentFolder() == null) {
            parent = null;
        }
        if (parent != null) {
            Stack<Integer> stack = new Stack<Integer>();
            while (parent.getParentFolder() != null) {
                stack.push(new Integer(parent.getNumber()));
                parent = parent.getParentFolder();
            }
            menu = (Menu)menu.getItem((Integer)stack.pop() + 5);
            while (!stack.empty()) {
                menu = (Menu)menu.getItem((Integer)stack.pop());
            }
        }
        this.createBookmarkMenu(menu, bookmark);
    }

    void createBookmarkMenu(Menu menu, boolean tool) {
        BookmarkManager bm = this.option.getBookmarkManager();
        Vector bookmarks = bm.getBookmarks();
        if (tool) {
            boolean canReload = this.activeContext.canReload();
            this.createMenuItem(54, 0, null, 0);
            MenuItem mi = this.createMenuItem(55, 2, menu, 0);
            if (!canReload) {
                mi.setEnabled(false);
            }
            mi = this.createMenuItem(56, 2, menu, 0);
            if (!canReload) {
                mi.setEnabled(false);
            }
            this.createMenuItem(-1, 2, menu, 0);
            this.createMenuItem(57, 2, menu, 0);
            this.createMenuItem(-1, 2, menu, 0);
        }
        this.createBookmarkMenu(menu, bookmarks);
    }

    void createBookmarkMenu(Menu menu, Vector bookmarks) {
        int size = bookmarks.size();
        Object bookmark = null;
        for (int i = 0; i < size; ++i) {
            this.createBookmarkMenu(menu, (Bookmark)bookmarks.elementAt(i));
        }
    }

    private void createBookmarkMenu(Menu menu, Bookmark bookmark) {
        switch (bookmark.getType()) {
            case 1: {
                Menu sub = new Menu(bookmark.getText());
                this.createBookmarkMenu(sub, bookmark.getBookmarks());
                menu.add(sub);
                break;
            }
            case 2: {
                MenuItem mi = new MenuItem(bookmark.getText());
                mi.addActionListener(new BookmarkActionListener(bookmark));
                menu.add(mi);
                break;
            }
            case 3: {
                menu.addSeparator();
            }
        }
    }

    public void activeChanged(ViewerContext context) {
        this.activeContext = context;
        this.historyChanged(context);
        if (!context.canReload()) {
            this.setLoaded(0);
        } else if (context.isLoading()) {
            this.setLoaded(1);
        } else {
            this.setLoaded(2);
        }
    }

    public void documentLoading(ViewerContext context) {
        if (this.activeContext != context) {
            return;
        }
        this.setSelected(false);
        this.setLoaded(1);
    }

    public void documentLoaded(ViewerContext context) {
        if (this.activeContext != context) {
            return;
        }
        this.setLoaded(2);
    }

    public void addressChanged(ViewerContext context, String address) {
    }

    public void titleChanged(ViewerContext context, String title) {
        MenuItem mi = this.activeMenuItem;
        if (mi != null) {
            mi.setLabel(title != null ? title : "");
        }
    }

    public void statusChanged(ViewerContext context, String status) {
    }

    public void historyChanged(ViewerContext context) {
        int i;
        Request r;
        if (this.activeContext != context) {
            return;
        }
        Request request = context.getRequest();
        if (request == null) {
            this.menus[50].setEnabled(false);
            this.menus[51].setEnabled(false);
            return;
        }
        Request viewRequest = request;
        Vector<Request> next = new Vector<Request>(20);
        Vector<Request> prev = new Vector<Request>(20);
        Vector all = new Vector(20);
        int num = 9;
        while (num-- > 0 && (r = request.getNext()) != null) {
            request = r;
            next.addElement(request);
        }
        num = 20 - next.size();
        request = viewRequest;
        while (num-- > 0 && (r = request.getPrevious()) != null) {
            request = r;
            prev.addElement(request);
        }
        for (i = next.size() - 1; i >= 0; --i) {
            all.addElement(next.elementAt(i));
        }
        all.addElement(viewRequest);
        for (i = 0; i < prev.size(); ++i) {
            all.addElement(prev.elementAt(i));
        }
        for (i = this.moveMenu.getItemCount() - 1; i >= 6; --i) {
            this.moveMenu.remove(i);
        }
        this.menus[50].setEnabled(prev.size() > 0);
        this.menus[51].setEnabled(next.size() > 0);
        num = all.size();
        for (int i2 = 0; i2 < num; ++i2) {
            MenuItem mi;
            request = (Request)all.elementAt(i2);
            String title = request.getDocument().getTitle();
            if (title == null) {
                title = "";
            }
            if (request == viewRequest) {
                CheckboxMenuItem cmi = new CheckboxMenuItem(title, true);
                cmi.addItemListener(new CheckboxMenuItemListener());
                mi = this.activeMenuItem = cmi;
            } else {
                mi = new MenuItem(title);
                mi.addActionListener(new MoveActionListener(context, request));
            }
            this.moveMenu.add(mi);
        }
    }

    void changeVisibleComponent(int target, boolean b) {
        switch (target) {
            case 1: {
                ((CheckboxMenuItem)this.menus[23]).setState(b);
                break;
            }
            case 2: {
                ((CheckboxMenuItem)this.menus[24]).setState(b);
                break;
            }
            case 3: {
                ((CheckboxMenuItem)this.menus[25]).setState(b);
                break;
            }
            case 4: {
                ((CheckboxMenuItem)this.menus[26]).setState(b);
            }
        }
    }

    void changeTabMode(ViewerContext context) {
        long mode = context.getTabMode();
        ((CheckboxMenuItem)this.menus[74]).setState((mode & 1L) != 0L);
    }

    private void setLoaded(int load) {
        this.menus[27].setEnabled(load == 1);
        this.menus[28].setEnabled(load != 0);
        this.menus[55].setEnabled(load != 0);
        this.menus[56].setEnabled(load != 0);
    }

    void setSelected(boolean sel) {
    }

    private void setTabMode(boolean add, long mode) {
        if (add) {
            this.viewer.addTabMode(this.viewer.getTabContextIndex(), mode);
        } else {
            this.viewer.removeTabMode(this.viewer.getTabContextIndex(), mode);
        }
    }

    private class WindowActionListener
    implements ActionListener {
        private HawkWindow window;

        private WindowActionListener(HawkWindow window) {
            this.window = window;
        }

        public void actionPerformed(ActionEvent e) {
            this.window.show();
        }
    }

    private class CheckboxMenuItemListener
    implements ItemListener {
        private CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            CheckboxMenuItem menu = (CheckboxMenuItem)e.getSource();
            menu.setState(true);
        }
    }

    private class BookmarkActionListener
    implements ActionListener {
        private Bookmark bookmark;

        private BookmarkActionListener(Bookmark bookmark) {
            this.bookmark = bookmark;
        }

        public void actionPerformed(ActionEvent e) {
            URL url = this.bookmark.getURL();
            if (url != null) {
                ViewerMenu.this.viewer.open(url);
            }
        }
    }

    private class MoveActionListener
    implements ActionListener {
        private ViewerContext context;
        private Request request;

        private MoveActionListener(ViewerContext context, Request request) {
            this.context = context;
            this.request = request;
        }

        public void actionPerformed(ActionEvent e) {
            this.context.load(this.request);
        }
    }

    private class MenuActionListner
    implements ActionListener,
    ItemListener {
        private int index = 0;

        private MenuActionListner(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            boolean isShift = (e.getModifiers() & 1) != 0;
            switch (this.index) {
                case 1: {
                    ViewerMenu.this.viewer.createWindow();
                    break;
                }
                case 2: {
                    ViewerMenu.this.viewer.createTab(-1, true);
                    break;
                }
                case 3: {
                    ViewerMenu.this.viewer.openURL(-1);
                    break;
                }
                case 4: {
                    ViewerMenu.this.viewer.openFile(-1);
                    break;
                }
                case 5: {
                    ViewerMenu.this.viewer.closeWindow();
                    break;
                }
                case 6: {
                    ViewerMenu.this.viewer.closeTab(-1);
                    break;
                }
                case 11: {
                    ViewerMenu.this.viewer.exitViewer();
                    break;
                }
                case 27: {
                    ViewerMenu.this.viewer.stop(-1);
                    break;
                }
                case 28: {
                    ViewerMenu.this.viewer.reload(-1, isShift);
                    break;
                }
                case 50: {
                    ViewerMenu.this.viewer.moveHistory(-1, -1);
                    break;
                }
                case 51: {
                    ViewerMenu.this.viewer.moveHistory(-1, 1);
                    break;
                }
                case 52: {
                    ViewerMenu.this.viewer.moveHome(-1);
                    break;
                }
                case 53: {
                    ViewerMenu.this.viewer.showHistoryEditor();
                    break;
                }
                case 55: {
                    ViewerMenu.this.viewer.addBookmark(-1);
                    break;
                }
                case 56: {
                    ViewerMenu.this.viewer.addBookmarkAs(-1);
                    break;
                }
                case 57: {
                    ViewerMenu.this.viewer.showBookmarkEditor();
                    break;
                }
                case 63: {
                    ViewerMenu.this.viewer.showOptionManager();
                    break;
                }
                case 66: {
                    ViewerMenu.this.viewer.showAbout();
                    break;
                }
                case 68: {
                    ViewerMenu.this.viewer.closeTab(ViewerMenu.this.viewer.getTabContextIndex());
                    break;
                }
                case 69: {
                    ViewerMenu.this.viewer.reload(ViewerMenu.this.viewer.getTabContextIndex(), isShift);
                    break;
                }
                case 70: {
                    ViewerMenu.this.viewer.createTab(ViewerMenu.this.viewer.getTabContextIndex() + 1, true);
                    break;
                }
                case 71: {
                    ViewerMenu.this.viewer.closeTab(-5);
                    break;
                }
                case 72: {
                    ViewerMenu.this.viewer.closeTab(-3);
                    break;
                }
                case 73: {
                    ViewerMenu.this.viewer.closeTab(-4);
                }
            }
        }

        public void itemStateChanged(ItemEvent e) {
            boolean selected = e.getStateChange() == 1;
            switch (this.index) {
                case 23: {
                    ViewerMenu.this.viewer.setVisibleComponent(1, selected);
                    break;
                }
                case 24: {
                    ViewerMenu.this.viewer.setVisibleComponent(2, selected);
                    break;
                }
                case 25: {
                    ViewerMenu.this.viewer.setVisibleComponent(3, selected);
                    break;
                }
                case 26: {
                    ViewerMenu.this.viewer.setVisibleComponent(4, selected);
                    break;
                }
                case 74: {
                    ViewerMenu.this.setTabMode(selected, 1L);
                }
            }
            if (!selected) {
                return;
            }
        }
    }
}

