/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;

public class OpenDialog
extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resource";
    private static final int MARGIN = 3;
    private static final String URL_FILE_SCHEME = "file:/";
    public static final int RESULT_OPEN = 0;
    private TextField path;

    public OpenDialog(final Frame owner) {
        super(owner, 1);
        this.setTitle(this.getMessage("title"));
        this.setResizable(false);
        this.setModal(true);
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(3, 3, 3, 3);
        this.mainPanel.setLayout(gbl);
        this.addToPanel(new Label(this.getMessage("message")), gbl, 0, 0, 2, 1, 0.0, 0.0, 2, 10, insets);
        this.path = new TextField(30);
        this.addToPanel(this.path, gbl, 0, 1, 1, 1, 1.0, 0.0, 2, 10, insets);
        Button file = new Button(this.getMessage("label.file"));
        this.addToPanel(file, gbl, 1, 1, 1, 1, 0.0, 0.0, 2, 10, insets);
        file.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDialog fd = new FileDialog(owner, Resource.getMessage(OpenDialog.RESOURCE, "dialog.file.open", null), 0);
                fd.show();
                String pathName = fd.getFile();
                if (pathName == null) {
                    fd.dispose();
                    return;
                }
                pathName = (fd.getDirectory() != null ? fd.getDirectory() : "") + pathName;
                fd.dispose();
                pathName = OpenDialog.URL_FILE_SCHEME + pathName;
                try {
                    ((TextComponent)OpenDialog.this.path).setText(new URL(pathName).toString());
                }
                catch (MalformedURLException ex) {
                    ((TextComponent)OpenDialog.this.path).setText(pathName);
                }
            }
        });
        this.setButtonLabel(0, this.getMessage("label.open"));
        this.pack();
    }

    private String getMessage(String key) {
        if (key == null) {
            return "";
        }
        return Resource.getMessage(RESOURCE, "opendialog." + key, null);
    }

    public String getPath() {
        return this.path.getText();
    }

    public void setPath(String value) {
        ((TextComponent)this.path).setText(value);
    }
}

