/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.AdjustmentListener;
import net.hizlab.kagetaka.awt.InnerScrollbar;
import net.hizlab.kagetaka.awt.event.AdjustmentEvent;
import net.hizlab.kagetaka.rendering.PanelScrollbar;

class ExScrollbar
extends Component
implements Adjustable,
PanelScrollbar {
    private Scrollbar scrollbar;
    private int orientation;
    private boolean isHorizontal;
    private boolean enabled = true;
    private int fixOperator;
    private Object stateLock = new Object();
    private boolean repaintForce;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;
    private transient AdjustmentListener adjustmentListener;

    ExScrollbar(int orientation) {
        this.scrollbar = new Scrollbar(orientation);
        this.scrollbar.setValues(0, 1, 0, 1);
        this.scrollbar.setEnabled(false);
        this.orientation = orientation;
        this.isHorizontal = orientation == 0;
        this.setUnitIncrement(1);
        this.setBlockIncrement(1);
    }

    public Dimension getPreferredSize() {
        if (this.isHorizontal) {
            return new Dimension(0, 16);
        }
        return new Dimension(16, 0);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public synchronized void setEnabled(boolean b) {
        if (this.enabled == b) {
            return;
        }
        this.enabled = b;
        super.setEnabled(b);
        this.scrollbar.setEnabled(b);
        this.repaintForce();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        boolean repaint = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.offScreenImage == null || !size.equals(this.offScreenSize)) {
                if (this.offScreenImage != null) {
                    this.offScreenGraphics.dispose();
                    this.offScreenImage.flush();
                }
                if (size.width == 0 || size.height == 0) {
                    this.offScreenImage = null;
                    this.offScreenSize = null;
                    this.offScreenGraphics = null;
                    return;
                }
                this.offScreenImage = this.createImage(size.width, size.height);
                this.offScreenSize = size;
                this.offScreenGraphics = this.offScreenImage.getGraphics();
                this.scrollbar.setBounds(0, 0, size.width, size.height);
                this.repaintForce = true;
            }
            if (this.offScreenGraphics != null && this.repaintForce) {
                repaint = true;
                this.repaintForce = false;
            }
        }
        if (repaint) {
            this.scrollbar.paint(this.offScreenGraphics, true);
        }
        if (this.offScreenImage != null) {
            g.drawImage(this.offScreenImage, 0, 0, size.width, size.height, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.removeNotify();
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (this.offScreenImage != null) {
                    this.offScreenGraphics.dispose();
                    this.offScreenImage.flush();
                    this.offScreenGraphics = null;
                    this.offScreenImage = null;
                }
            }
            this.scrollbar.dispose();
        }
    }

    public Component getComponent() {
        return this;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getValue() {
        return this.scrollbar.getValue();
    }

    public synchronized void setValue(int newValue) {
        if (this.scrollbar.getValue() == newValue) {
            return;
        }
        this.scrollbar.setValue(newValue);
        if (!this.repaintNow()) {
            this.repaintForce();
        }
    }

    public int getMinimum() {
        return this.scrollbar.getMinimum();
    }

    public void setMinimum(int newMinimum) {
        if (this.scrollbar.getMinimum() == newMinimum) {
            return;
        }
        int value = this.scrollbar.getValue();
        if (this.isHorizontal) {
            value -= newMinimum - this.scrollbar.getMinimum();
        }
        this.fixValue(this.scrollbar.setValues(value, this.scrollbar.getVisibleAmount(), newMinimum, this.scrollbar.getMaximum()));
    }

    public int getMaximum() {
        return this.scrollbar.getMaximum();
    }

    public synchronized void setMaximum(int newMaximum) {
        if (this.scrollbar.getMaximum() == newMaximum) {
            return;
        }
        int value = this.scrollbar.getValue();
        if (this.isHorizontal) {
            value += newMaximum - this.scrollbar.getMaximum();
        }
        this.fixValue(this.scrollbar.setValues(value, this.scrollbar.getVisibleAmount(), this.scrollbar.getMinimum(), newMaximum));
    }

    public int getVisibleAmount() {
        return this.scrollbar.getVisibleAmount();
    }

    public synchronized void setVisibleAmount(int newVisible) {
        if (this.scrollbar.getVisibleAmount() == newVisible) {
            return;
        }
        int value = this.scrollbar.getValue();
        if (this.isHorizontal) {
            value -= newVisible - this.scrollbar.getVisibleAmount();
        }
        this.fixValue(this.scrollbar.setValues(value, newVisible, this.scrollbar.getMinimum(), this.scrollbar.getMaximum()));
    }

    public int getUnitIncrement() {
        return this.scrollbar.getUnitIncrement();
    }

    public void setUnitIncrement(int v) {
        this.scrollbar.setUnitIncrement(v);
    }

    public int getBlockIncrement() {
        return this.scrollbar.getBlockIncrement();
    }

    public void setBlockIncrement(int v) {
        this.scrollbar.setBlockIncrement(v);
    }

    public void addAdjustmentListener(AdjustmentListener l) {
        this.enableEvents(256L);
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    public void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processAdjustmentEvent(AdjustmentEvent e) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(e);
        }
    }

    private void postAdjustmentEvent(int value) {
        AdjustmentEvent e = new AdjustmentEvent(this, 3040, 5, value);
        try {
            this.getToolkit().getSystemEventQueue().postEvent(e);
        }
        catch (SecurityException ex) {
            this.processAdjustmentEvent(e);
        }
    }

    private void fixValue(boolean repaint) {
        boolean b;
        boolean bl = b = this.scrollbar.getMaximum() > this.scrollbar.getVisibleAmount();
        if (this.enabled != b) {
            this.setEnabled(b);
            return;
        }
        if (repaint) {
            this.repaintForce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintForce() {
        Object object = this.stateLock;
        synchronized (object) {
            this.repaintForce = true;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean repaintNow() {
        Object object = this.stateLock;
        synchronized (object) {
            Graphics g;
            if (this.offScreenGraphics != null && (g = this.getGraphics()) != null) {
                try {
                    this.scrollbar.paint(this.offScreenGraphics, false);
                    Dimension size = this.getSize();
                    g.drawImage(this.offScreenImage, 0, 0, size.width, size.height, this);
                }
                finally {
                    g.dispose();
                }
                return true;
            }
        }
        return false;
    }

    private class Scrollbar
    extends InnerScrollbar {
        private Scrollbar(int orientation) {
            super(orientation, ExScrollbar.this);
        }

        public void repaint() {
            ExScrollbar.this.repaintForce();
        }

        public void changedValue() {
            ExScrollbar.this.repaintNow();
            ExScrollbar.this.postAdjustmentEvent(ExScrollbar.this.scrollbar.getValue());
        }
    }
}

