/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.MessageBox;
import net.hizlab.kagetaka.cookie.Cookie;
import net.hizlab.kagetaka.cookie.CookieManager;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.protocol.ProxySupported;
import net.hizlab.kagetaka.rendering.PostData;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.viewer.AuthenticationInfo;
import net.hizlab.kagetaka.viewer.AuthorizationDialog;
import net.hizlab.kagetaka.viewer.ViewerContext;

class Connector {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resource";
    private static Hashtable authCache = new Hashtable();
    private static String proxyAuthorization;
    private ViewerContext context;
    private ViewerOption option;
    private Reporter reporter;
    private Frame owner;
    private CookieManager cookieManager;

    Connector(ViewerContext context, ViewerOption option) {
        this.context = context;
        this.reporter = context.getReporter();
        this.option = option;
        this.owner = this.owner;
        this.cookieManager = option.getCookieManager();
    }

    void setOwner(Frame owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URLConnection getURLConnection(Request request) throws IOException, InterruptedException {
        URLConnection connection = null;
        HttpURLConnection httpConnection = null;
        URL url = request.url;
        URL proxyUrl = null;
        boolean debug = this.reporter != null && this.reporter.getLevel() <= -1;
        try {
            if (this.reporter != null) {
                this.reporter.report(3, this.getMessage("report.connect.open", new String[]{url.toString()}), 0, 0);
            }
            URL baseUrl = url;
            URL connectUrl = url;
            PostData pd = request.postData;
            boolean isNewUrl = true;
            boolean isNewProxyAuth = false;
            AuthenticationInfo proxyAuthentication = null;
            boolean isNewServerAuth = false;
            AuthenticationInfo serverAuthentication = null;
            block12: while (true) {
                if (isNewUrl) {
                    serverAuthentication = AuthenticationInfo.get('s', url);
                    URL newProxyUrl = this.option.getProxyURL(url);
                    if (newProxyUrl != proxyUrl) {
                        proxyUrl = newProxyUrl;
                        proxyAuthentication = proxyUrl != null ? AuthenticationInfo.get('p', proxyUrl) : null;
                    }
                    connectUrl = proxyUrl != null ? new URL(url.getProtocol(), proxyUrl.getHost(), proxyUrl.getPort(), url.toString()) : url;
                }
                boolean firstTry = true;
                while (true) {
                    httpConnection = (connection = connectUrl.openConnection()) instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
                    connection.setUseCaches(firstTry);
                    this.setHTTPHeader(url, connection, request, proxyAuthentication, serverAuthentication);
                    if (pd != null && httpConnection != null) {
                        pd.send(httpConnection);
                    }
                    try {
                        connection.connect();
                        if (httpConnection != null) {
                            httpConnection.getResponseCode();
                            break;
                        }
                        connection.getInputStream();
                    }
                    catch (SocketException e) {
                        if (!firstTry || e.getClass().getName().compareTo("java.net.SocketException") != 0) {
                            throw e;
                        }
                        firstTry = false;
                        return firstTry;
                    }
                    finally {
                        if (!Thread.interrupted()) continue;
                        throw new InterruptedException("connect");
                    }
                    break;
                }
                isNewUrl = false;
                this.getHTTPHeader(url, connection);
                if (debug) {
                    this.dumpConnection(connection);
                }
                if (httpConnection == null) break;
                int code = httpConnection.getResponseCode();
                if (code == 401) {
                    serverAuthentication = this.getWWWAuthenticate(url, connection, isNewServerAuth, false);
                    if (serverAuthentication == null) break;
                    isNewServerAuth = true;
                    if (this.reporter != null) {
                        this.reporter.report(3, this.getMessage("report.connect.reopen", new String[]{url.toString()}), 0, 0);
                    }
                } else if (code == 407) {
                    proxyAuthentication = this.getWWWAuthenticate(proxyUrl, connection, isNewProxyAuth, true);
                    if (proxyAuthentication == null) break;
                    isNewProxyAuth = true;
                    if (this.reporter != null) {
                        this.reporter.report(3, this.getMessage("report.connect.reopen", new String[]{url.toString()}), 0, 0);
                    }
                } else {
                    if (isNewProxyAuth) {
                        AuthenticationInfo.put('p', proxyAuthentication, proxyUrl);
                    }
                    if (isNewServerAuth) {
                        AuthenticationInfo.put('s', serverAuthentication, url);
                    }
                    switch (code) {
                        case 300: 
                        case 301: 
                        case 307: {
                            break;
                        }
                        case 302: {
                            if (pd == null || this.option.getPropertyBoolean("http.strict", false)) break;
                            pd = null;
                            break;
                        }
                        case 303: {
                            if (pd == null) break;
                            pd = null;
                            break;
                        }
                        default: {
                            break block12;
                        }
                    }
                    url = this.getRedirectURL(url, connection, pd, baseUrl);
                    if (url == null) break;
                    isNewUrl = true;
                    isNewProxyAuth = false;
                    isNewServerAuth = false;
                    serverAuthentication = null;
                    if (this.reporter != null) {
                        this.reporter.report(3, this.getMessage("report.connect.redirect", new String[]{url.toString()}), 0, 0);
                    }
                }
                httpConnection.disconnect();
            }
            return proxyUrl == null || connection instanceof ProxySupported ? connection : (httpConnection != null ? new HttpURLConnectionWrapper(url, httpConnection) : new URLConnectionWrapper(url, connection));
        }
        catch (IOException e) {
            if (proxyUrl != null && (e instanceof UnknownHostException || e instanceof ConnectException || e instanceof SocketException)) {
                String option = e instanceof UnknownHostException ? "notfound" : "notconnect";
                MessageBox.show(this.owner, this.getMessage("message.proxy." + option + ".text", new String[]{proxyUrl.getHost()}), this.getMessage("message.proxy." + option + ".title", null), 65536);
                return null;
            }
            throw e;
        }
    }

    void setCookie(String value, URL url) {
        Cookie cookie = this.cookieManager.createCookie(value, url);
        if (cookie == null) {
            return;
        }
        boolean strage = cookie.getExpires() >= 0L;
        String accept = strage ? this.option.getPropertyString("cookie.accept.strage") : this.option.getPropertyString("cookie.accept.session");
        if (accept == null || accept.compareTo("asc") == 0) {
            accept = MessageBox.show(this.owner, this.getMessage("message.cookie.text", new Object[]{cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), new Integer(strage ? 1 : 0), strage ? new Date(cookie.getExpires()) : null}), this.getMessage("message.cookie.title", null), 131075) == 2 ? "yes" : "no";
        }
        if (accept.compareTo("yes") == 0) {
            this.cookieManager.setCookie(cookie);
        }
    }

    private void setHTTPHeader(URL url, URLConnection connection, Request request, AuthenticationInfo proxyAuthentication, AuthenticationInfo serverAuthentication) throws IOException {
        String cookie;
        connection.setRequestProperty("Host", url.getHost() + (url.getPort() > 0 ? ":" + url.getPort() : ""));
        connection.setRequestProperty("User-Agent", this.option.getPropertyString("http.useragent"));
        connection.setRequestProperty("Accept", this.option.getPropertyString("http.accept"));
        connection.setRequestProperty("Accept-Language", this.option.getPropertyString("http.acceptlanguage"));
        connection.setRequestProperty("Accept-Encoding", this.option.getPropertyString("http.acceptencoding"));
        connection.setRequestProperty("Accept-Charset", this.option.getPropertyString("http.acceptcharset"));
        int referer = this.option.getPropertyInteger("http.referer", 0);
        if (request.referer != null && referer != -1 && (referer == -2 || this.isSamePath(request.referer, url, referer))) {
            connection.setRequestProperty("Referer", request.referer.toExternalForm());
        }
        if ((cookie = this.cookieManager.getCookie(url)) != null) {
            connection.setRequestProperty("Cookie", cookie);
        }
        if (proxyAuthentication != null) {
            connection.setRequestProperty("Proxy-Authorization", proxyAuthentication.getValue());
        }
        if (serverAuthentication != null) {
            connection.setRequestProperty("Authorization", serverAuthentication.getValue());
        }
        if (request.useCache == 0) {
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setRequestProperty("Pragma", "no-cache");
        }
    }

    private void getHTTPHeader(URL url, URLConnection connection) throws IOException {
        String key;
        int index = 1;
        while ((key = connection.getHeaderFieldKey(index)) != null) {
            if ((key = key.toLowerCase()).compareTo("set-cookie") == 0) {
                this.setCookie(connection.getHeaderField(index), url);
            }
            ++index;
        }
    }

    private AuthenticationInfo getWWWAuthenticate(URL url, URLConnection connection, boolean retry, boolean proxy) {
        AuthenticationInfo auth;
        String realm = proxy ? connection.getHeaderField("Proxy-Authenticate") : connection.getHeaderField("WWW-Authenticate");
        if (realm == null) {
            return null;
        }
        String type = realm;
        int p = realm.indexOf(32);
        if (p != -1) {
            type = realm.substring(0, p);
            if ((realm = realm.substring(p + 1)).toLowerCase().startsWith("realm")) {
                for (p = 5; p < realm.length(); ++p) {
                    if (realm.charAt(p) == ' ') continue;
                    if (realm.charAt(p) == '=') {
                        realm = realm.substring(p + 1).trim();
                    }
                    break;
                }
            }
        } else {
            realm = null;
        }
        if (type.toLowerCase().compareTo("basic") != 0) {
            MessageBox.show(this.owner, this.getMessage("message.unknown_authtype.text", new String[]{type, url.toString()}), this.getMessage("message.unknown_authtype.title", null), 65536);
            return null;
        }
        char atype = 'b';
        if (!retry && (auth = AuthenticationInfo.get(proxy ? (char)'p' : 's', url, realm, atype)) != null) {
            return auth;
        }
        return AuthorizationDialog.show(this.owner, url.getHost(), realm, atype, proxy ? 1 : 0);
    }

    private URL getRedirectURL(URL url, URLConnection connection, PostData pd, URL baseUrl) throws IOException {
        String location = connection.getHeaderField("Location");
        if (location == null) {
            return null;
        }
        try {
            url = new URL(url, location);
            if (pd != null && MessageBox.show(this.owner, this.getMessage("message.redirect.text", new String[]{baseUrl.toString(), location}), this.getMessage("message.redirect.title", null), 131073) != 0) {
                return null;
            }
        }
        catch (MalformedURLException e) {
            MessageBox.show(this.owner, this.getMessage("message.invalidurl.text", new String[]{location, e.toString()}), this.getMessage("message.invalidurl.title", null), 65536);
            return null;
        }
        return url;
    }

    private boolean isSamePath(URL url1, URL url2, int path) {
        if (url1.getHost().compareTo(url2.getHost()) != 0) {
            return false;
        }
        if (url1.getPort() != url2.getPort()) {
            return false;
        }
        String s1 = url1.getFile();
        String s2 = url2.getFile();
        int p = s1.indexOf(47);
        if (p == -1) {
            return true;
        }
        while (path-- > 0 && (p = s1.indexOf(47, p + 1)) != -1) {
        }
        if (p == -1) {
            p = s1.lastIndexOf(47);
        }
        if (s2.length() <= p) {
            return false;
        }
        for (int i = 0; i <= p; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private String getMessage(String key, Object[] args) {
        return Resource.getMessage(RESOURCE, key, args);
    }

    private void dumpConnection(URLConnection connection) throws IOException {
        String key;
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            this.reporter.report(-1, "HTTP Response: " + httpConnection.getResponseCode() + " " + httpConnection.getResponseMessage(), 0, 0);
        }
        int index = 0;
        while ((key = connection.getHeaderFieldKey(++index)) != null) {
            this.reporter.report(-1, "HTTP Response: [" + key + "]:[" + connection.getHeaderField(index) + "]", 0, 0);
        }
    }

    private class HttpURLConnectionWrapper
    extends HttpURLConnection {
        private HttpURLConnection connection;

        private HttpURLConnectionWrapper(URL url, HttpURLConnection connection) {
            super(url);
            this.connection = connection;
        }

        public void connect() throws IOException {
            this.connection.connect();
        }

        public URL getURL() {
            return this.url;
        }

        public int getContentLength() {
            return this.connection.getContentLength();
        }

        public String getContentType() {
            return this.connection.getContentType();
        }

        public String getContentEncoding() {
            return this.connection.getContentEncoding();
        }

        public long getExpiration() {
            return this.connection.getExpiration();
        }

        public long getDate() {
            return this.connection.getDate();
        }

        public long getLastModified() {
            return this.connection.getLastModified();
        }

        public String getHeaderField(String name) {
            return this.connection.getHeaderField(name);
        }

        public int getHeaderFieldInt(String name, int Default) {
            return this.connection.getHeaderFieldInt(name, Default);
        }

        public long getHeaderFieldDate(String name, long Default) {
            return ((URLConnection)this.connection).getHeaderFieldDate(name, Default);
        }

        public String getHeaderFieldKey(int n) {
            return ((URLConnection)this.connection).getHeaderFieldKey(n);
        }

        public String getHeaderField(int n) {
            return ((URLConnection)this.connection).getHeaderField(n);
        }

        public Object getContent() throws IOException {
            return this.connection.getContent();
        }

        public InputStream getInputStream() throws IOException {
            return this.connection.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.connection.getOutputStream();
        }

        public String toString() {
            return this.connection.toString();
        }

        public void setDoInput(boolean doinput) {
            this.connection.setDoInput(doinput);
        }

        public boolean getDoInput() {
            return this.connection.getDoInput();
        }

        public void setDoOutput(boolean dooutput) {
            this.connection.setDoOutput(dooutput);
        }

        public boolean getDoOutput() {
            return this.connection.getDoOutput();
        }

        public void setAllowUserInteraction(boolean allowuserinteraction) {
            this.connection.setAllowUserInteraction(allowuserinteraction);
        }

        public boolean getAllowUserInteraction() {
            return this.connection.getAllowUserInteraction();
        }

        public void setUseCaches(boolean usecaches) {
            this.connection.setUseCaches(usecaches);
        }

        public boolean getUseCaches() {
            return this.connection.getUseCaches();
        }

        public void setIfModifiedSince(long ifmodifiedsince) {
            this.connection.setIfModifiedSince(ifmodifiedsince);
        }

        public long getIfModifiedSince() {
            return this.connection.getIfModifiedSince();
        }

        public boolean getDefaultUseCaches() {
            return this.connection.getDefaultUseCaches();
        }

        public void setDefaultUseCaches(boolean defaultusecaches) {
            this.connection.setDefaultUseCaches(defaultusecaches);
        }

        public void setRequestProperty(String key, String value) {
            this.connection.setRequestProperty(key, value);
        }

        public String getRequestProperty(String key) {
            return this.connection.getRequestProperty(key);
        }

        public void setRequestMethod(String method) throws ProtocolException {
            this.connection.setRequestMethod(method);
        }

        public String getRequestMethod() {
            return this.connection.getRequestMethod();
        }

        public int getResponseCode() throws IOException {
            return this.connection.getResponseCode();
        }

        public String getResponseMessage() throws IOException {
            return this.connection.getResponseMessage();
        }

        public void disconnect() {
            this.connection.disconnect();
        }

        public boolean usingProxy() {
            return this.connection.usingProxy();
        }
    }

    private class URLConnectionWrapper
    extends URLConnection {
        private URLConnection connection;

        private URLConnectionWrapper(URL url, URLConnection connection) {
            super(url);
            this.connection = connection;
        }

        public void connect() throws IOException {
            this.connection.connect();
        }

        public URL getURL() {
            return this.url;
        }

        public int getContentLength() {
            return this.connection.getContentLength();
        }

        public String getContentType() {
            return this.connection.getContentType();
        }

        public String getContentEncoding() {
            return this.connection.getContentEncoding();
        }

        public long getExpiration() {
            return this.connection.getExpiration();
        }

        public long getDate() {
            return this.connection.getDate();
        }

        public long getLastModified() {
            return this.connection.getLastModified();
        }

        public String getHeaderField(String name) {
            return this.connection.getHeaderField(name);
        }

        public int getHeaderFieldInt(String name, int Default) {
            return this.connection.getHeaderFieldInt(name, Default);
        }

        public long getHeaderFieldDate(String name, long Default) {
            return this.connection.getHeaderFieldDate(name, Default);
        }

        public String getHeaderFieldKey(int n) {
            return this.connection.getHeaderFieldKey(n);
        }

        public String getHeaderField(int n) {
            return this.connection.getHeaderField(n);
        }

        public Object getContent() throws IOException {
            return this.connection.getContent();
        }

        public InputStream getInputStream() throws IOException {
            return this.connection.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.connection.getOutputStream();
        }

        public String toString() {
            return this.connection.toString();
        }

        public void setDoInput(boolean doinput) {
            this.connection.setDoInput(doinput);
        }

        public boolean getDoInput() {
            return this.connection.getDoInput();
        }

        public void setDoOutput(boolean dooutput) {
            this.connection.setDoOutput(dooutput);
        }

        public boolean getDoOutput() {
            return this.connection.getDoOutput();
        }

        public void setAllowUserInteraction(boolean allowuserinteraction) {
            this.connection.setAllowUserInteraction(allowuserinteraction);
        }

        public boolean getAllowUserInteraction() {
            return this.connection.getAllowUserInteraction();
        }

        public void setUseCaches(boolean usecaches) {
            this.connection.setUseCaches(usecaches);
        }

        public boolean getUseCaches() {
            return this.connection.getUseCaches();
        }

        public void setIfModifiedSince(long ifmodifiedsince) {
            this.connection.setIfModifiedSince(ifmodifiedsince);
        }

        public long getIfModifiedSince() {
            return this.connection.getIfModifiedSince();
        }

        public boolean getDefaultUseCaches() {
            return this.connection.getDefaultUseCaches();
        }

        public void setDefaultUseCaches(boolean defaultusecaches) {
            this.connection.setDefaultUseCaches(defaultusecaches);
        }

        public void setRequestProperty(String key, String value) {
            this.connection.setRequestProperty(key, value);
        }

        public String getRequestProperty(String key) {
            return this.connection.getRequestProperty(key);
        }
    }
}

