/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.net.URL;
import java.util.Hashtable;
import net.fclabs.util.Base64;

class AuthenticationInfo {
    static final char SERVER = 's';
    static final char PROXY = 'p';
    static final char BASIC = 'b';
    static final char DIGEST = 'd';
    static final char NTLM = 'n';
    private static Hashtable realmCache = new Hashtable();
    private static Hashtable urlCache = new Hashtable();
    private char atype;
    private String realm;
    private String username;
    private String password;
    private String value;
    private boolean hasCache;
    private AuthenticationInfo prev;
    private AuthenticationInfo next;

    AuthenticationInfo(String realm, char atype, String username, String password) {
        this.atype = atype;
        this.realm = realm;
        this.username = username;
        this.password = password;
        if (atype == 'b') {
            this.value = "Basic " + new String(Base64.encode((username + ":" + password).getBytes()));
        }
    }

    String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append('{');
        sb.append("realm=");
        sb.append(this.realm);
        sb.append(", user=");
        sb.append(this.username);
        sb.append('}');
        return sb.toString();
    }

    static AuthenticationInfo get(char target, URL url) {
        return AuthenticationInfo.get(target, url, null, '\u0000');
    }

    static AuthenticationInfo get(char target, URL url, String realm, char atype) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(target);
        sb.append(':');
        sb.append(url.getProtocol().toLowerCase());
        sb.append(':');
        sb.append(url.getHost().toLowerCase());
        sb.append(':');
        sb.append(url.getPort());
        if (realm != null) {
            sb.append(':');
            sb.append(realm);
            return (AuthenticationInfo)realmCache.get(sb.toString());
        }
        Host host = (Host)urlCache.get(sb.toString());
        if (host == null) {
            return null;
        }
        return host.find(AuthenticationInfo.getPath(url), atype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void put(char target, AuthenticationInfo auth, URL url) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(target);
        sb.append(':');
        sb.append(url.getProtocol().toLowerCase());
        sb.append(':');
        sb.append(url.getHost().toLowerCase());
        sb.append(':');
        sb.append(url.getPort());
        String key = sb.toString();
        if (!auth.hasCache) {
            sb.append(':');
            sb.append(auth.realm);
            realmCache.put(sb.toString(), auth);
            auth.hasCache = true;
        }
        Hashtable hashtable = urlCache;
        synchronized (hashtable) {
            Path path = new Path(AuthenticationInfo.getPath(url), auth);
            Host host = (Host)urlCache.get(key);
            if (host != null) {
                host.add(path);
            } else {
                host = new Host(path);
                urlCache.put(key, host);
            }
        }
    }

    private static String getPath(URL url) {
        String path = url.getFile();
        if (path == null || path.length() == 0) {
            return "/";
        }
        int p = path.indexOf(63);
        return AuthenticationInfo.cutPath(path, p == -1 ? path.length() : p);
    }

    private static String cutPath(String path, int p) {
        if (p <= 0 || (p = path.lastIndexOf(47, p - 1)) < 0) {
            return null;
        }
        return path.substring(0, p + 1);
    }

    private static class Path {
        private String path;
        private int depth;
        private AuthenticationInfo auth;
        private Path next;
        private Path prev;

        private Path(String path, AuthenticationInfo auth) {
            this.path = path;
            this.auth = auth;
            int p = -1;
            int depth = 0;
            while ((p = path.indexOf(47, p + 1)) != -1) {
                ++depth;
            }
            this.depth = depth;
        }
    }

    private static class Host {
        private Path top;
        private Path last;

        private Host(Path add) {
            this.top = this.last = add;
        }

        private synchronized AuthenticationInfo find(String key, char atype) {
            Path path = this.top;
            while (path != null) {
                if (key.startsWith(path.path) && (atype == '\u0000' || atype == path.auth.atype)) {
                    return path.auth;
                }
                path = path.next;
            }
            return null;
        }

        private synchronized void add(Path add) {
            Path path = this.top;
            int depth = add.depth;
            while (true) {
                if (path == null) {
                    if (this.top == null) {
                        this.top = this.last = add;
                    } else {
                        this.last.next = add;
                        add.prev = this.last;
                        this.last = add;
                    }
                    return;
                }
                if (path.depth <= depth) break;
                path = path.next;
            }
            if (path.prev == null) {
                path.prev = add;
                add.next = path;
                this.top = add;
            } else {
                add.prev = path.prev;
                add.next = path;
                path.prev.next = add;
                path.prev = add;
            }
        }
    }
}

