/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.util;

import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.util.ContentHeaderParser;

public class ContentType {
    private String type = null;
    private String subtype = null;
    private Hashtable parameters = new Hashtable();

    public ContentType(String value) throws ParseException {
        ContentHeaderParser.Data data = ContentHeaderParser.parse(value);
        this.parseMedia(data.type);
        this.parameters = data.parameters;
    }

    public ContentType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
    }

    private void parseMedia(String media) throws ParseException {
        int slash = media.indexOf(47);
        if (slash == -1) {
            throw new ParseException(Resource.getMessage("contenttype.error.media", new String[]{media}), 0);
        }
        this.type = media.substring(0, slash).toLowerCase();
        this.subtype = media.substring(slash + 1).toLowerCase();
        if (this.type.length() == 0 || this.subtype.length() == 0) {
            throw new ParseException(Resource.getMessage("contenttype.error.media", new String[]{media}), 0);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subtype;
    }

    public String getParameter(String key) {
        return (String)this.parameters.get(key.toLowerCase());
    }

    public Enumeration getParameterKeys() {
        return this.parameters.keys();
    }

    public String putParameter(String key, String value) {
        return this.parameters.put(key, value);
    }

    public void clearParameter() {
        this.parameters.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type);
        sb.append('/');
        sb.append(this.subtype);
        if (this.parameters.size() > 0) {
            boolean quote = false;
            StringBuffer v = new StringBuffer();
            Enumeration e = this.parameters.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)this.parameters.get(key);
                sb.append("; ");
                sb.append(key);
                sb.append('=');
                v.setLength(0);
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (quote) {
                        if (c == '\"' || c == '\\') {
                            v.append('\\');
                        }
                    } else {
                        switch (c) {
                            case '(': 
                            case ')': 
                            case ',': 
                            case '/': 
                            case ':': 
                            case ';': 
                            case '<': 
                            case '=': 
                            case '>': 
                            case '?': 
                            case '@': 
                            case '[': 
                            case ']': 
                            case '{': 
                            case '}': {
                                quote = true;
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                quote = true;
                                v.append('\\');
                                break;
                            }
                            default: {
                                if (c > ' ') break;
                                quote = true;
                            }
                        }
                    }
                    v.append(c);
                }
                if (quote) {
                    sb.append('\"');
                }
                sb.append(v.toString());
                if (!quote) continue;
                sb.append('\"');
            }
        }
        return sb.toString();
    }

    public static String normalize(String ct, URL url) {
        if (ct != null && ct.compareTo("content/unknown") != 0) {
            return ct;
        }
        String ext = null;
        ext = url.getFile();
        int p = ext.lastIndexOf(46);
        if (p == -1) {
            return null;
        }
        if ((ext = ext.substring(p + 1).toLowerCase()).compareTo("css") == 0) {
            return "text/css";
        }
        return null;
    }
}

