/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.util;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import net.hizlab.kagetaka.Resource;

public class Charset {
    private static final String RESOURCE = "net.hizlab.kagetaka.util.Charset";
    private static final String DEFAULT_ENCODING_KEY = "DEFAULT";
    private static final byte[] TEST_BYTES = new byte[]{0, 0, 0, 0};
    private static String defaultEncoding;
    private static Hashtable supportedEncoding;

    private Charset() {
    }

    public static String toEncoding(String charset) {
        if (Charset.isSupported(charset)) {
            return charset;
        }
        String encoding = Resource.getMessage(RESOURCE, charset.toLowerCase(), null, null);
        if (encoding != null && Charset.isSupported(encoding)) {
            return encoding;
        }
        return null;
    }

    private static boolean isSupported(String encoding) {
        Boolean check = (Boolean)supportedEncoding.get(encoding);
        if (check != null) {
            return check;
        }
        try {
            String s = new String(TEST_BYTES, encoding);
            supportedEncoding.put(encoding, Boolean.TRUE);
            return true;
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        supportedEncoding.put(encoding, Boolean.FALSE);
        return false;
    }

    public static String getDefaultEncoding() {
        return defaultEncoding;
    }

    static {
        supportedEncoding = new Hashtable();
        String encoding = Resource.getMessage(RESOURCE, DEFAULT_ENCODING_KEY, null, null);
        if (encoding != null && !Charset.isSupported(encoding)) {
            encoding = null;
        }
        defaultEncoding = encoding;
    }
}

