/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token.form;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;

public class InputAttribute
extends Attribute {
    private String attributeType = null;
    private String attributeName = null;
    private String attributeValue = null;
    private boolean attributeChecked = false;
    private boolean attributeDisabled = false;
    private boolean attributeReadonly = false;
    private Integer attributeSize = null;
    private Integer attributeMaxlength = null;
    private String attributeSrc = null;
    private String attributeAlt = null;
    private Integer attributeTabindex = null;
    private String attributeAccesskey = null;
    private String attributeAccept = null;
    private int attributeAlign = 3;

    protected InputAttribute(Document document, Reporter reporter, int line, int column) {
        super(document, reporter, line, column);
    }

    public boolean setAttribute(String key, String value) throws IllegalArgumentException {
        if ("type".compareTo(key) == 0) {
            this.attributeType = value;
            return true;
        }
        if ("name".compareTo(key) == 0) {
            this.attributeName = value;
            return true;
        }
        if ("value".compareTo(key) == 0) {
            this.attributeValue = value;
            return true;
        }
        if ("checked".compareTo(key) == 0) {
            this.attributeChecked = value.toLowerCase().compareTo(key) == 0;
            return true;
        }
        if ("disabled".compareTo(key) == 0) {
            this.attributeDisabled = value.toLowerCase().compareTo(key) == 0;
            return true;
        }
        if ("readonly".compareTo(key) == 0) {
            this.attributeReadonly = value.toLowerCase().compareTo(key) == 0;
            return true;
        }
        if ("size".compareTo(key) == 0) {
            this.attributeSize = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("maxlength".compareTo(key) == 0) {
            this.attributeMaxlength = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("src".compareTo(key) == 0) {
            this.attributeSrc = value;
            return true;
        }
        if ("alt".compareTo(key) == 0) {
            this.attributeAlt = value;
            return true;
        }
        if ("tabindex".compareTo(key) == 0) {
            this.attributeTabindex = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("accesskey".compareTo(key) == 0) {
            this.attributeAccesskey = value;
            return true;
        }
        if ("accept".compareTo(key) == 0) {
            this.attributeAccept = value;
            return true;
        }
        if ("align".compareTo(key) == 0) {
            this.attributeAlign = AttributeConverter.convertToAlign(value);
            return true;
        }
        return this.setBaseAttribute(key, value);
    }

    public String getType() {
        return this.attributeType;
    }

    public String getName() {
        return this.attributeName;
    }

    public String getValue() {
        return this.attributeValue;
    }

    public boolean getChecked() {
        return this.attributeChecked;
    }

    public boolean getDisabled() {
        return this.attributeDisabled;
    }

    public boolean getReadonly() {
        return this.attributeReadonly;
    }

    public Integer getSize() {
        return this.attributeSize;
    }

    public Integer getMaxlength() {
        return this.attributeMaxlength;
    }

    public String getSrc() {
        return this.attributeSrc;
    }

    public String getAlt() {
        return this.attributeAlt;
    }

    public Integer getTabindex() {
        return this.attributeTabindex;
    }

    public String getAccesskey() {
        return this.attributeAccesskey;
    }

    public String getAccept() {
        return this.attributeAccept;
    }

    public int getAlign() {
        return this.attributeAlign;
    }
}

