/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TokenCreater;
import net.hizlab.kagetaka.token.TokenTypes;

public class TokenManager {
    private static TokenCreater rubyCreater;
    private static TokenCreater tableCreater;
    private static TokenCreater styleCreater;
    private static TokenCreater formCreater;

    private TokenManager() {
    }

    public static StartToken createStartToken(Document document, Reporter reporter, int line, int column, int type, boolean complete) {
        if (TokenTypes.isRuby(type)) {
            return rubyCreater.createStartToken(document, reporter, line, column, type, complete);
        }
        if (TokenTypes.isTable(type)) {
            return tableCreater.createStartToken(document, reporter, line, column, type, complete);
        }
        if (type == 2017 || type == 2018) {
            return styleCreater.createStartToken(document, reporter, line, column, type, complete);
        }
        if (TokenTypes.isForm(type)) {
            return formCreater.createStartToken(document, reporter, line, column, type, complete);
        }
        return new StartToken(document, reporter, line, column, type, complete);
    }

    public static EndToken createEndToken(Document document, Reporter reporter, int line, int column, int type, boolean complete) {
        if (TokenTypes.isRuby(type)) {
            return rubyCreater.createEndToken(document, reporter, line, column, type, complete);
        }
        if (TokenTypes.isTable(type)) {
            return tableCreater.createEndToken(document, reporter, line, column, type, complete);
        }
        if (type == 2018 || type == 2017) {
            return styleCreater.createEndToken(document, reporter, line, column, type, complete);
        }
        if (TokenTypes.isForm(type)) {
            return formCreater.createEndToken(document, reporter, line, column, type, complete);
        }
        return new EndToken(document, reporter, line, column, type, complete);
    }

    public static boolean canUseRuby() {
        return rubyCreater != null;
    }

    public static boolean canUseTable() {
        return tableCreater != null;
    }

    public static boolean canUseStyle() {
        return styleCreater != null;
    }

    public static boolean canUseForm() {
        return formCreater != null;
    }

    static {
        Creater creater = new Creater();
        rubyCreater = creater;
        tableCreater = creater;
        styleCreater = creater;
        formCreater = creater;
        try {
            rubyCreater = (TokenCreater)Class.forName(Resource.getMessage("tokencreater.ruby", null)).newInstance();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            tableCreater = (TokenCreater)Class.forName(Resource.getMessage("tokencreater.table", null)).newInstance();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            styleCreater = (TokenCreater)Class.forName(Resource.getMessage("tokencreater.style", null)).newInstance();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            formCreater = (TokenCreater)Class.forName(Resource.getMessage("tokencreater.form", null)).newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class Creater
    implements TokenCreater {
        private Creater() {
        }

        public StartToken createStartToken(Document document, Reporter reporter, int line, int column, int type, boolean complete) {
            this.reportMessage(reporter, line, column, type);
            return null;
        }

        public EndToken createEndToken(Document document, Reporter reporter, int line, int column, int type, boolean complete) {
            this.reportMessage(reporter, line, column, type);
            return null;
        }

        private void reportMessage(Reporter reporter, int line, int column, int type) {
            reporter.report(7, Resource.getMessage("tokenmanager.warning.notsupport", new String[]{TokenTypes.getName(type)}), line, column);
        }
    }
}

