/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;
import net.hizlab.kagetaka.token.Value;

public class ImgAttribute
extends Attribute {
    private String attributeSrc = null;
    private String attributeAlt = null;
    private Value attributeHeight = null;
    private Value attributeWidth = null;
    private Integer attributeBorder = null;
    private int attributeAlign = 3;

    protected ImgAttribute(Document document, Reporter reporter, int line, int column) {
        super(document, reporter, line, column);
    }

    public boolean setAttribute(String key, String value) throws IllegalArgumentException {
        if ("src".compareTo(key) == 0) {
            this.attributeSrc = value;
            return true;
        }
        if ("alt".compareTo(key) == 0) {
            this.attributeAlt = value;
            return true;
        }
        if ("height".compareTo(key) == 0) {
            this.attributeHeight = AttributeConverter.convertToPercent(value);
            return true;
        }
        if ("width".compareTo(key) == 0) {
            this.attributeWidth = AttributeConverter.convertToPercent(value);
            return true;
        }
        if ("border".compareTo(key) == 0) {
            this.attributeBorder = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("align".compareTo(key) == 0) {
            this.attributeAlign = AttributeConverter.convertToAlign(value);
            return true;
        }
        return this.setBaseAttribute(key, value);
    }

    public String getSrc() {
        return this.attributeSrc;
    }

    public String getAlt() {
        return this.attributeAlt;
    }

    public Value getWidth() {
        return this.attributeWidth;
    }

    public Value getHeight() {
        return this.attributeHeight;
    }

    public Integer getBorder() {
        return this.attributeBorder;
    }

    public int getAlign() {
        return this.attributeAlign;
    }
}

