/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import java.awt.Color;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;

public class FontAttribute
extends Attribute {
    private Integer attributeSize = null;
    private boolean attributeSizeRelative = false;
    private Color attributeColor = null;
    private String attributeFace = null;

    protected FontAttribute(Document document, Reporter reporter, int line, int column) {
        super(document, reporter, line, column);
    }

    public boolean setAttribute(String key, String value) throws IllegalArgumentException {
        if ("size".compareTo(key) == 0) {
            boolean bl = this.attributeSizeRelative = value.length() > 0 && (value.charAt(0) == '-' || value.charAt(0) == '+');
            if (value.startsWith("+")) {
                value = value.substring(1);
            }
            this.attributeSize = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("color".compareTo(key) == 0) {
            this.attributeColor = AttributeConverter.convertToColor(value);
            return true;
        }
        if ("face".compareTo(key) == 0) {
            this.attributeFace = value;
            return true;
        }
        return this.setBaseAttribute(key, value);
    }

    public Integer getSize(int base) {
        if (this.attributeSize == null) {
            return null;
        }
        int size = 0;
        size = this.attributeSizeRelative ? base + this.attributeSize : this.attributeSize;
        if (size < 1) {
            size = 1;
        }
        if (size > 7) {
            size = 7;
        }
        return new Integer(size);
    }

    public Color getColor() {
        return this.attributeColor;
    }

    public String getFace() {
        return this.attributeFace;
    }
}

