/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import net.hizlab.kagetaka.token.Value;

public class AttributeConverter {
    private AttributeConverter() {
    }

    public static Color convertToColor(String value) throws IllegalArgumentException {
        Color color = AttributeConverter.convertToColorSilent(value);
        if (color == null) {
            throw new IllegalArgumentException();
        }
        return color;
    }

    public static Color convertToColorSilent(String value) {
        int length = value.length();
        int current = 0;
        if (length == 0) {
            return null;
        }
        if (value.charAt(0) == '#') {
            --length;
            current = 1;
        } else {
            if ("black".compareTo(value = value.toLowerCase()) == 0) {
                return new Color(0);
            }
            if ("silver".compareTo(value) == 0) {
                return new Color(0xC0C0C0);
            }
            if ("gray".compareTo(value) == 0) {
                return new Color(0x808080);
            }
            if ("white".compareTo(value) == 0) {
                return new Color(0xFFFFFF);
            }
            if ("maroon".compareTo(value) == 0) {
                return new Color(0x800000);
            }
            if ("red".compareTo(value) == 0) {
                return new Color(0xFF0000);
            }
            if ("purple".compareTo(value) == 0) {
                return new Color(0x800080);
            }
            if ("fuchsia".compareTo(value) == 0) {
                return new Color(0xFF00FF);
            }
            if ("green".compareTo(value) == 0) {
                return new Color(32768);
            }
            if ("lime".compareTo(value) == 0) {
                return new Color(65280);
            }
            if ("olive".compareTo(value) == 0) {
                return new Color(0x808000);
            }
            if ("yellow".compareTo(value) == 0) {
                return new Color(0xFFFF00);
            }
            if ("navy".compareTo(value) == 0) {
                return new Color(128);
            }
            if ("blue".compareTo(value) == 0) {
                return new Color(255);
            }
            if ("teal".compareTo(value) == 0) {
                return new Color(32896);
            }
            if ("aqua".compareTo(value) == 0) {
                return new Color(65535);
            }
            if ("activeborder".compareTo(value) == 0) {
                return SystemColor.activeCaptionBorder;
            }
            if ("activecaption".compareTo(value) == 0) {
                return SystemColor.activeCaption;
            }
            if ("appworkspace".compareTo(value) == 0) {
                return SystemColor.control;
            }
            if ("background".compareTo(value) == 0) {
                return SystemColor.desktop;
            }
            if ("buttonface".compareTo(value) == 0) {
                return SystemColor.control;
            }
            if ("buttonhighlight".compareTo(value) == 0) {
                return SystemColor.controlHighlight;
            }
            if ("buttonshadow".compareTo(value) == 0) {
                return SystemColor.controlShadow;
            }
            if ("buttontext".compareTo(value) == 0) {
                return SystemColor.controlText;
            }
            if ("captiontext".compareTo(value) == 0) {
                return SystemColor.activeCaptionText;
            }
            if ("graytext".compareTo(value) == 0) {
                return SystemColor.inactiveCaptionText;
            }
            if ("highlight".compareTo(value) == 0) {
                return SystemColor.textHighlight;
            }
            if ("highlighttext".compareTo(value) == 0) {
                return SystemColor.textHighlightText;
            }
            if ("inactiveborder".compareTo(value) == 0) {
                return SystemColor.inactiveCaptionBorder;
            }
            if ("inactivecaption".compareTo(value) == 0) {
                return SystemColor.inactiveCaption;
            }
            if ("inactivecaptiontext".compareTo(value) == 0) {
                return SystemColor.inactiveCaptionText;
            }
            if ("infobackground".compareTo(value) == 0) {
                return SystemColor.info;
            }
            if ("infotext".compareTo(value) == 0) {
                return SystemColor.infoText;
            }
            if ("menu".compareTo(value) == 0) {
                return SystemColor.menu;
            }
            if ("menutext".compareTo(value) == 0) {
                return SystemColor.menuText;
            }
            if ("scrollbar".compareTo(value) == 0) {
                return SystemColor.scrollbar;
            }
            if ("threeddarkshadow".compareTo(value) == 0) {
                return SystemColor.controlDkShadow;
            }
            if ("threedface".compareTo(value) == 0) {
                return SystemColor.controlHighlight;
            }
            if ("threedhighlight".compareTo(value) == 0) {
                return SystemColor.controlLtHighlight;
            }
            if ("threedlightshadow".compareTo(value) == 0) {
                return SystemColor.controlShadow;
            }
            if ("threedshadow".compareTo(value) == 0) {
                return SystemColor.controlShadow;
            }
            if ("window".compareTo(value) == 0) {
                return SystemColor.window;
            }
            if ("windowframe".compareTo(value) == 0) {
                return SystemColor.windowBorder;
            }
            if ("windowtext".compareTo(value) == 0) {
                return SystemColor.windowText;
            }
        }
        if (length != 3 && length != 6) {
            return null;
        }
        if (length == 3) {
            StringBuffer sb = new StringBuffer(7);
            sb.append('#');
            sb.append(value.charAt(current));
            sb.append(value.charAt(current));
            sb.append(value.charAt(current + 1));
            sb.append(value.charAt(current + 1));
            sb.append(value.charAt(current + 2));
            sb.append(value.charAt(current + 2));
            value = sb.toString();
            length = 6;
            current = 1;
        }
        int color = 0;
        while (--length >= 0) {
            char c;
            if ('0' <= (c = value.charAt(current++)) && c <= '9') {
                color = (int)((double)color + (double)(c - 48) * Math.pow(16.0, length));
                continue;
            }
            if ('A' <= c && c <= 'F') {
                color = (int)((double)color + (double)(c - 65 + 10) * Math.pow(16.0, length));
                continue;
            }
            if ('a' <= c && c <= 'f') {
                color = (int)((double)color + (double)(c - 97 + 10) * Math.pow(16.0, length));
                continue;
            }
            return null;
        }
        return new Color(color);
    }

    public static Font convertToFont(String value) throws IllegalArgumentException {
        return new Font(value, 12, 0);
    }

    public static Integer convertToInteger(String value) throws IllegalArgumentException {
        ParsePosition pp = new ParsePosition(0);
        DecimalFormat df = new DecimalFormat("0;-0");
        ((NumberFormat)df).setMaximumFractionDigits(0);
        Number n = df.parse(value, pp);
        if (!(n instanceof Long) || pp.getIndex() < value.length()) {
            throw new IllegalArgumentException();
        }
        long l = n.longValue();
        if (l < Integer.MIN_VALUE || Integer.MAX_VALUE < l) {
            throw new IllegalArgumentException();
        }
        return new Integer((int)l);
    }

    public static int convertToAlign(String value) throws IllegalArgumentException {
        if ((value = value.toLowerCase()).compareTo("left") == 0) {
            return 31;
        }
        if (value.compareTo("center") == 0) {
            return 33;
        }
        if (value.compareTo("right") == 0) {
            return 32;
        }
        throw new IllegalArgumentException();
    }

    public static int convertToVAlign(String value) throws IllegalArgumentException {
        if ((value = value.toLowerCase()).compareTo("top") == 0) {
            return 44;
        }
        if (value.compareTo("middle") == 0) {
            return 46;
        }
        if (value.compareTo("bottom") == 0) {
            return 47;
        }
        throw new IllegalArgumentException();
    }

    public static Value convertToPercent(String value) throws IllegalArgumentException {
        if (value.length() == 0) {
            throw new IllegalArgumentException();
        }
        boolean isPercent = false;
        Integer intValue = null;
        if (value.charAt(value.length() - 1) == '%') {
            isPercent = true;
            value = value.substring(0, value.length() - 1);
        }
        if ((intValue = AttributeConverter.convertToInteger(value)) == null) {
            throw new IllegalArgumentException();
        }
        return new Value((long)intValue.intValue(), isPercent ? 9 : 3);
    }
}

