/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import java.util.StringTokenizer;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Style;
import net.hizlab.kagetaka.token.StyleManager;

public class Attribute {
    protected Document document = null;
    protected Reporter reporter = null;
    protected int lineNumber = 0;
    protected int columnNumber = 0;
    private String attributeId = null;
    private String[] attributeClass = null;
    private String attributeTitle = null;
    private Style attributeStyle = null;

    public Attribute(Document document, Reporter reporter, int line, int column) {
        this.document = document;
        this.reporter = reporter;
        this.lineNumber = line;
        this.columnNumber = column;
    }

    public boolean setAttribute(String key, String value) throws IllegalArgumentException {
        return this.setBaseAttribute(key, value);
    }

    protected boolean setBaseAttribute(String key, String value) throws IllegalArgumentException {
        if ("id".compareTo(key) == 0) {
            this.attributeId = value;
            return true;
        }
        if ("class".compareTo(key) == 0) {
            StringTokenizer st = new StringTokenizer(value, " ");
            this.attributeClass = new String[st.countTokens()];
            for (int i = 0; i < this.attributeClass.length; ++i) {
                this.attributeClass[i] = st.nextToken();
            }
            return true;
        }
        if ("title".compareTo(key) == 0) {
            this.attributeTitle = value;
            return true;
        }
        if ("style".compareTo(key) == 0) {
            this.attributeStyle = StyleManager.createStyle(this.reporter, value);
            return true;
        }
        return false;
    }

    protected void reportMessage(int type, String key, String[] args) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.report(type, Resource.getMessage(key, args), this.lineNumber, this.columnNumber);
    }

    public String getBaseId() {
        return this.attributeId;
    }

    public String[] getBaseClass() {
        return this.attributeClass;
    }

    public String getBaseTitle() {
        return this.attributeTitle;
    }

    public Style getStyle() {
        return this.attributeStyle;
    }
}

