/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.theme;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.OptionListener;
import net.hizlab.kagetaka.option.ViewerController;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.theme.InvalidThemeException;
import net.hizlab.kagetaka.theme.Theme;
import net.hizlab.kagetaka.theme.ThemeListener;

public class ThemeManager {
    private static final String RESOURCE = "net.hizlab.kagetaka.theme.Resource";
    private static final String EXTENSION = ".kth";
    private ViewerOption option;
    private Vector themes = new Vector();
    private Theme theme;
    private Vector listeners = new Vector();

    public ThemeManager(ViewerOption option) {
        this.option = option;
        this.refresh();
        this.initTheme(option.getPropertyString("theme.key"));
        option.addListener(new OptionListener(){

            public void propertyChange(ViewerOption option, String key, Object oldValue, Object newValue) throws InvalidValueException {
            }

            public void propertiesChanged(ViewerOption option, ViewerController c, Enumeration list) {
                while (list.hasMoreElements()) {
                    String key = (String)list.nextElement();
                    if (key.compareTo("theme.key") != 0) continue;
                    String themeKey = option.getPropertyString("theme.key");
                    if (themeKey.compareTo(ThemeManager.this.theme.getKey()) == 0) {
                        return;
                    }
                    ThemeManager.this.initTheme(themeKey);
                    if (ThemeManager.this.listeners.size() > 0) {
                        for (int i = 0; i < ThemeManager.this.listeners.size(); ++i) {
                            ((ThemeListener)ThemeManager.this.listeners.elementAt(i)).themeChanged(ThemeManager.this.theme);
                        }
                    }
                    return;
                }
            }
        });
    }

    private void initTheme(String key) {
        Theme theme = this.getTheme(key);
        if (theme == null) {
            theme = (Theme)this.themes.elementAt(0);
        }
        try {
            theme.load();
        }
        catch (InvalidThemeException e) {
            System.out.println(e);
        }
        this.theme = theme;
    }

    public synchronized void refresh() {
        this.themes.removeAllElements();
        String list = Resource.getMessage(RESOURCE, "themes.list", null);
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            try {
                this.themes.addElement(new Theme(st.nextToken(), 0));
            }
            catch (InvalidThemeException e) {
                System.out.println(e);
            }
        }
        File[] lists = new File[]{this.option.getPropertyFile("theme.user.path"), this.option.getPropertyFile("theme.system.path")};
        for (int i = 0; i < lists.length; ++i) {
            String[] files;
            if (lists[i] == null || !lists[i].exists() || !lists[i].isDirectory() || !lists[i].canRead() || (files = lists[i].list()) == null) continue;
            for (int j = 0; j < files.length; ++j) {
                File file = new File(lists[i], files[j]);
                if (!files[j].toLowerCase().endsWith(EXTENSION) && !file.isDirectory()) continue;
                try {
                    this.themes.addElement(new Theme(file, j == 0 ? 1 : 2));
                    continue;
                }
                catch (InvalidThemeException e) {
                    System.out.println(e);
                }
            }
        }
    }

    public synchronized Theme getTheme() {
        return this.theme;
    }

    public synchronized Theme getTheme(String key) {
        for (int i = 0; i < this.themes.size(); ++i) {
            Theme theme = (Theme)this.themes.elementAt(i);
            if (theme.getKey().compareTo(key) != 0) continue;
            return theme;
        }
        return null;
    }

    public synchronized Theme[] getThemes() {
        Object[] ts = new Theme[this.themes.size()];
        this.themes.copyInto(ts);
        return ts;
    }

    public void addListener(ThemeListener l) {
        this.listeners.addElement(l);
    }

    public void removeListener(ThemeListener l) {
        this.listeners.removeElement(l);
    }
}

